/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;
import org.openqa.grid.web.servlet.handler.WebDriverRequest;

public class DriverServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = -1693540182205547227L;

    public DriverServlet() {
        this(null);
    }

    public DriverServlet(Registry registry) {
        super(registry);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block8: {
            Throwable e2;
            block9: {
                JSONObject resp;
                RequestHandler req = null;
                SeleniumBasedRequest r = null;
                try {
                    r = SeleniumBasedRequest.createFromRequest(request, this.getRegistry());
                    req = new RequestHandler(r, response, this.getRegistry());
                    req.process();
                    break block8;
                }
                catch (Throwable e2) {
                    if (!(r instanceof WebDriverRequest) || response.isCommitted()) break block9;
                    response.reset();
                    response.setContentType("application/json");
                    response.setCharacterEncoding("UTF-8");
                    response.setStatus(500);
                    resp = new JSONObject();
                    try {
                        ExternalSessionKey serverSession = req.getServerSession();
                        resp.put("sessionId", serverSession != null ? serverSession.getKey() : null);
                        resp.put("status", 13);
                        JSONObject value = new JSONObject();
                        value.put("message", e2.getMessage());
                        value.put("class", e2.getClass().getCanonicalName());
                        JSONArray stacktrace = new JSONArray();
                        StackTraceElement[] stackTraceElementArray = e2.getStackTrace();
                        int n = stackTraceElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            StackTraceElement ste = stackTraceElementArray[n2];
                            JSONObject st = new JSONObject();
                            st.put("fileName", ste.getFileName());
                            st.put("className", ste.getClassName());
                            st.put("methodName", ste.getMethodName());
                            st.put("lineNumber", ste.getLineNumber());
                            stacktrace.put(st);
                            ++n2;
                        }
                        value.put("stackTrace", stacktrace);
                        resp.put("value", value);
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
                String json = resp.toString();
                byte[] bytes = json.getBytes("UTF-8");
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                try {
                    response.setHeader("Content-Length", Integer.toString(bytes.length));
                    ByteStreams.copy((InputStream)in, (OutputStream)response.getOutputStream());
                }
                finally {
                    ((InputStream)in).close();
                    response.flushBuffer();
                }
            }
            throw new IOException(e2);
        }
    }
}

