/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocArraySingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocImplicitTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.parser.AbstractCommentParser;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class JavadocParser
extends AbstractCommentParser {
    public Javadoc docComment;
    private int invalidParamReferencesPtr = -1;
    private ASTNode[] invalidParamReferencesStack;

    public JavadocParser(Parser sourceParser) {
        super(sourceParser);
        this.checkDocComment = this.sourceParser.options.docCommentSupport;
        this.jdk15 = this.sourceParser.options.sourceLevel >= 0x310000L;
        this.kind = 1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDeprecation(int commentPtr) {
        block16: {
            this.javadocStart = this.sourceParser.scanner.commentStarts[commentPtr];
            this.javadocEnd = this.sourceParser.scanner.commentStops[commentPtr] - 1;
            this.firstTagPosition = this.sourceParser.scanner.commentTagStarts[commentPtr];
            this.docComment = this.checkDocComment != false ? new Javadoc(this.javadocStart, this.javadocEnd) : null;
            if (this.firstTagPosition == 0) {
                return false;
            }
            try {
                this.source = this.sourceParser.scanner.source;
                if (this.checkDocComment) {
                    this.scanner.lineEnds = this.sourceParser.scanner.lineEnds;
                    this.scanner.linePtr = this.sourceParser.scanner.linePtr;
                    this.lineEnds = this.scanner.lineEnds;
                    this.commentParse();
                    break block16;
                }
                firstLineNumber = this.sourceParser.scanner.getLineNumber(this.javadocStart);
                lastLineNumber = this.sourceParser.scanner.getLineNumber(this.javadocEnd);
                this.index = this.javadocStart + 3;
                line = firstLineNumber;
                while (true) {
                    block18: {
                        if (line > lastLineNumber) {
                            break;
                        }
                        this.index = lineStart = line == firstLineNumber ? this.javadocStart + 3 : this.sourceParser.scanner.getLineStart(line);
                        v0 = this.lineEnd = line == lastLineNumber ? this.javadocEnd - 2 : this.sourceParser.scanner.getLineEnd(line);
lbl26:
                        // 2 sources

                        while (this.index < this.lineEnd) {
                            c = this.readChar();
                            switch (c) {
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case ' ': 
                                case '*': {
                                    ** break;
                                }
                                case '@': {
                                    if (this.readChar() != 'd' || this.readChar() != 'e' || this.readChar() != 'p' || this.readChar() != 'r' || this.readChar() != 'e' || this.readChar() != 'c' || this.readChar() != 'a' || this.readChar() != 't' || this.readChar() != 'e' || this.readChar() != 'd') break block18;
                                    c = this.readChar();
                                    if (Character.isWhitespace(c)) ** GOTO lbl37
                                    if (c != '*') break block18;
lbl37:
                                    // 2 sources

                                    var8_7 = null;
                                    this.source = null;
                                    return true;
                                }
                            }
                        }
                    }
                    ++line;
                }
            }
            catch (Throwable var7_11) {
                var8_9 = null;
                this.source = null;
                throw var7_11;
            }
            var8_8 = null;
            this.source = null;
            return false;
        }
        var8_10 = null;
        this.source = null;
        return this.deprecated;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("check javadoc: ").append(this.checkDocComment).append("\n");
        buffer.append("javadoc: ").append(this.docComment).append("\n");
        buffer.append(super.toString());
        return buffer.toString();
    }

    protected Object createArgumentReference(char[] name, int dim, boolean isVarargs, Object typeRef, long[] dimPositions, long argNamePos) throws InvalidInputException {
        try {
            TypeReference argTypeRef = (TypeReference)typeRef;
            if (dim > 0) {
                long pos = ((long)argTypeRef.sourceStart << 32) + (long)argTypeRef.sourceEnd;
                if (typeRef instanceof JavadocSingleTypeReference) {
                    JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                    argTypeRef = new JavadocArraySingleTypeReference(singleRef.token, dim, pos);
                } else {
                    JavadocQualifiedTypeReference qualifRef = (JavadocQualifiedTypeReference)typeRef;
                    argTypeRef = new JavadocArrayQualifiedTypeReference(qualifRef, dim);
                }
            }
            int argEnd = argTypeRef.sourceEnd;
            if (dim > 0) {
                argEnd = (int)dimPositions[dim - 1];
                if (isVarargs) {
                    argTypeRef.bits |= 0x4000;
                }
            }
            if (argNamePos >= 0L) {
                argEnd = (int)argNamePos;
            }
            return new JavadocArgumentExpression(name, argTypeRef.sourceStart, argEnd, argTypeRef);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    protected Object createFieldReference(Object receiver) throws InvalidInputException {
        try {
            TypeReference typeRef = (TypeReference)receiver;
            if (typeRef == null) {
                char[] name = this.sourceParser.compilationUnit.getMainTypeName();
                typeRef = new JavadocImplicitTypeReference(name, this.memberStart);
            }
            JavadocFieldReference field = new JavadocFieldReference(this.identifierStack[0], this.identifierPositionStack[0]);
            field.receiver = typeRef;
            field.tagSourceStart = this.tagSourceStart;
            field.tagSourceEnd = this.tagSourceEnd;
            field.tagValue = this.tagValue;
            return field;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    protected Object createMethodReference(Object receiver, List arguments) throws InvalidInputException {
        try {
            char[] name;
            TypeReference typeRef = (TypeReference)receiver;
            boolean isConstructor = false;
            if (typeRef == null) {
                name = this.sourceParser.compilationUnit.getMainTypeName();
                int ptr = this.sourceParser.astPtr;
                while (ptr >= 0) {
                    ASTNode node = this.sourceParser.astStack[ptr];
                    if (node instanceof TypeDeclaration) {
                        TypeDeclaration typeDecl = (TypeDeclaration)node;
                        if (typeDecl.bodyEnd == 0) {
                            name = typeDecl.name;
                            break;
                        }
                    }
                    --ptr;
                }
                isConstructor = CharOperation.equals(this.identifierStack[0], name);
                typeRef = new JavadocImplicitTypeReference(name, this.memberStart);
            } else {
                name = null;
                if (typeRef instanceof JavadocSingleTypeReference) {
                    name = ((JavadocSingleTypeReference)typeRef).token;
                } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                    char[][] tokens = ((JavadocQualifiedTypeReference)typeRef).tokens;
                    name = tokens[tokens.length - 1];
                } else {
                    throw new InvalidInputException();
                }
                isConstructor = CharOperation.equals(this.identifierStack[0], name);
            }
            if (arguments == null) {
                if (isConstructor) {
                    JavadocAllocationExpression alloc = new JavadocAllocationExpression(this.identifierPositionStack[0]);
                    alloc.type = typeRef;
                    alloc.tagValue = this.tagValue;
                    alloc.sourceEnd = this.scanner.getCurrentTokenEndPosition();
                    return alloc;
                }
                JavadocMessageSend msg = new JavadocMessageSend(this.identifierStack[0], this.identifierPositionStack[0]);
                msg.receiver = typeRef;
                msg.tagValue = this.tagValue;
                msg.sourceEnd = this.scanner.getCurrentTokenEndPosition();
                return msg;
            }
            JavadocArgumentExpression[] expressions = new JavadocArgumentExpression[arguments.size()];
            arguments.toArray(expressions);
            if (isConstructor) {
                JavadocAllocationExpression alloc = new JavadocAllocationExpression(this.identifierPositionStack[0]);
                alloc.arguments = expressions;
                alloc.type = typeRef;
                alloc.tagValue = this.tagValue;
                alloc.sourceEnd = this.scanner.getCurrentTokenEndPosition();
                return alloc;
            }
            JavadocMessageSend msg = new JavadocMessageSend(this.identifierStack[0], this.identifierPositionStack[0], expressions);
            msg.receiver = typeRef;
            msg.tagValue = this.tagValue;
            msg.sourceEnd = this.scanner.getCurrentTokenEndPosition();
            return msg;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    protected Object createReturnStatement() {
        return new JavadocReturnStatement(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
    }

    protected Object createTypeReference(int primitiveToken) {
        int size;
        TypeReference typeRef = null;
        if ((size = this.identifierLengthStack[this.identifierLengthPtr--]) == 1) {
            typeRef = new JavadocSingleTypeReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr], this.tagSourceStart, this.tagSourceEnd);
        } else if (size > 1) {
            char[][] tokens = new char[size][];
            System.arraycopy(this.identifierStack, this.identifierPtr - size + 1, tokens, 0, size);
            long[] positions = new long[size];
            System.arraycopy(this.identifierPositionStack, this.identifierPtr - size + 1, positions, 0, size);
            typeRef = new JavadocQualifiedTypeReference(tokens, positions, this.tagSourceStart, this.tagSourceEnd);
        }
        this.identifierPtr -= size;
        return typeRef;
    }

    protected boolean parseReturn() {
        if (this.returnStatement == null) {
            this.returnStatement = this.createReturnStatement();
            return true;
        }
        if (this.sourceParser != null) {
            this.sourceParser.problemReporter().javadocDuplicatedReturnTag(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
        }
        return false;
    }

    protected boolean parseTag(int previousPosition) throws InvalidInputException {
        boolean valid = false;
        int token = this.readTokenAndConsume();
        this.tagSourceStart = this.scanner.getCurrentTokenStartPosition();
        this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
        char pc = this.peekChar();
        boolean validTag = false;
        switch (token) {
            case 15: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                validTag = true;
            }
        }
        block21: while (token != 66 && this.index < this.scanner.eofPosition) {
            switch (pc) {
                case '*': 
                case '}': {
                    break block21;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '%': 
                case '&': 
                case '\'': 
                case ':': 
                case '<': 
                case '>': {
                    this.readChar();
                    this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
                    validTag = false;
                    break;
                }
                default: {
                    if (pc == ' ' || Character.isWhitespace(pc)) break block21;
                    this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
                    token = this.readTokenAndConsume();
                }
            }
            pc = this.peekChar();
        }
        if (!validTag) {
            this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
            if (this.reportProblems) {
                this.sourceParser.problemReporter().javadocInvalidTag(this.tagSourceStart, this.tagSourceEnd);
            }
            return false;
        }
        int length = this.tagSourceEnd - this.tagSourceStart + 1;
        char[] tag = new char[length];
        System.arraycopy(this.source, this.tagSourceStart, tag, 0, length);
        this.index = this.tagSourceEnd + 1;
        this.scanner.currentPosition = this.tagSourceEnd + 1;
        this.tagValue = 0;
        switch (token) {
            case 26: {
                switch (tag[0]) {
                    case 'd': {
                        if (!CharOperation.equals(tag, TAG_DEPRECATED)) break;
                        this.deprecated = true;
                        valid = true;
                        this.tagValue = 1;
                        break;
                    }
                    case 'i': {
                        if (!CharOperation.equals(tag, TAG_INHERITDOC)) break;
                        if (this.astPtr == -1) {
                            this.inheritedPositions = ((long)this.tagSourceStart << 32) + (long)this.tagSourceEnd;
                        }
                        valid = true;
                        this.tagValue = 9;
                        break;
                    }
                    case 'p': {
                        if (!CharOperation.equals(tag, TAG_PARAM)) break;
                        this.tagValue = 2;
                        valid = this.parseParam();
                        break;
                    }
                    case 'e': {
                        if (!CharOperation.equals(tag, TAG_EXCEPTION)) break;
                        this.tagValue = 5;
                        valid = this.parseThrows();
                        break;
                    }
                    case 's': {
                        if (!CharOperation.equals(tag, TAG_SEE)) break;
                        if (this.inlineTagStarted) {
                            valid = false;
                            if (this.sourceParser == null) break;
                            this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                            break;
                        }
                        this.tagValue = 6;
                        valid = this.parseReference();
                        break;
                    }
                    case 'l': {
                        if (CharOperation.equals(tag, TAG_LINK)) {
                            this.tagValue = 7;
                            if (this.inlineTagStarted) {
                                valid = this.parseReference();
                                break;
                            }
                            valid = false;
                            if (this.sourceParser == null) break;
                            this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                            break;
                        }
                        if (!CharOperation.equals(tag, TAG_LINKPLAIN)) break;
                        this.tagValue = 8;
                        if (this.inlineTagStarted) {
                            valid = this.parseReference();
                            break;
                        }
                        valid = false;
                        if (this.sourceParser == null) break;
                        this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                        break;
                    }
                    case 'v': {
                        if (this.jdk15 && CharOperation.equals(tag, TAG_VALUE)) {
                            this.tagValue = 10;
                            if (this.inlineTagStarted) {
                                valid = this.parseReference();
                                break;
                            }
                            valid = false;
                            if (this.sourceParser == null) break;
                            this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                            break;
                        }
                        this.createTag();
                    }
                }
                break;
            }
            case 80: {
                this.tagValue = 3;
                valid = this.parseReturn();
                break;
            }
            case 105: {
                this.tagValue = 4;
                valid = this.parseThrows();
            }
        }
        this.textStart = this.index;
        return valid;
    }

    protected void createTag() {
        this.tagValue = 11;
    }

    protected boolean pushParamName(boolean isTypeParam) {
        Expression ref;
        Expression nameRef = null;
        nameRef = isTypeParam ? (ref = new JavadocSingleTypeReference(this.identifierStack[1], this.identifierPositionStack[1], this.tagSourceStart, this.tagSourceEnd)) : (ref = new JavadocSingleNameReference(this.identifierStack[0], this.identifierPositionStack[0], this.tagSourceStart, this.tagSourceEnd));
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(nameRef, true);
        } else {
            if (!isTypeParam) {
                int i = 1;
                while (i <= this.astLengthPtr) {
                    if (this.astLengthStack[i] != 0) {
                        int stackLength;
                        if (this.sourceParser != null) {
                            this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                        }
                        if ((long)this.invalidParamReferencesPtr == -1L) {
                            this.invalidParamReferencesStack = new JavadocSingleNameReference[10];
                        }
                        if (++this.invalidParamReferencesPtr >= (stackLength = this.invalidParamReferencesStack.length)) {
                            this.invalidParamReferencesStack = new JavadocSingleNameReference[stackLength + AstStackIncrement];
                            System.arraycopy(this.invalidParamReferencesStack, 0, this.invalidParamReferencesStack, 0, stackLength);
                        }
                        this.invalidParamReferencesStack[this.invalidParamReferencesPtr] = nameRef;
                        return false;
                    }
                    i += 3;
                }
            }
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(nameRef, false);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(nameRef, true);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean pushSeeRef(Object statement) {
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(statement, true);
        } else {
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(null, true);
                    this.pushOnAstStack(statement, true);
                    break;
                }
                case 1: {
                    this.pushOnAstStack(statement, true);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(statement, false);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean pushThrowName(Object typeRef) {
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(typeRef, true);
        } else {
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(typeRef, true);
                    break;
                }
                case 1: {
                    this.pushOnAstStack(typeRef, false);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(null, true);
                    this.pushOnAstStack(typeRef, true);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    protected void refreshReturnStatement() {
        ((JavadocReturnStatement)this.returnStatement).empty = false;
    }

    protected void updateDocComment() {
        this.docComment.inheritedPositions = this.inheritedPositions;
        if (this.returnStatement != null) {
            this.docComment.returnStatement = (JavadocReturnStatement)this.returnStatement;
        }
        if (this.invalidParamReferencesPtr >= 0) {
            this.docComment.invalidParameters = new JavadocSingleNameReference[this.invalidParamReferencesPtr + 1];
            System.arraycopy(this.invalidParamReferencesStack, 0, this.docComment.invalidParameters, 0, this.invalidParamReferencesPtr + 1);
        }
        if (this.astLengthPtr == -1) {
            return;
        }
        int[] sizes = new int[3];
        int i = 0;
        while (i <= this.astLengthPtr) {
            int n = i % 3;
            sizes[n] = sizes[n] + this.astLengthStack[i];
            ++i;
        }
        this.docComment.seeReferences = new Expression[sizes[2]];
        this.docComment.exceptionReferences = new TypeReference[sizes[1]];
        this.docComment.paramReferences = new JavadocSingleNameReference[sizes[0]];
        int paramRefPtr = sizes[0];
        this.docComment.paramTypeParameters = new JavadocSingleTypeReference[sizes[0]];
        int paramTypeParamPtr = sizes[0];
        block6: while (this.astLengthPtr >= 0) {
            int ptr = this.astLengthPtr % 3;
            switch (ptr) {
                case 2: {
                    int size = this.astLengthStack[this.astLengthPtr--];
                    int i2 = 0;
                    while (i2 < size) {
                        int n = ptr;
                        int n2 = sizes[n] - 1;
                        sizes[n] = n2;
                        this.docComment.seeReferences[n2] = (Expression)this.astStack[this.astPtr--];
                        ++i2;
                    }
                    continue block6;
                }
                case 1: {
                    int size = this.astLengthStack[this.astLengthPtr--];
                    int i2 = 0;
                    while (i2 < size) {
                        int n = ptr;
                        int n3 = sizes[n] - 1;
                        sizes[n] = n3;
                        this.docComment.exceptionReferences[n3] = (TypeReference)this.astStack[this.astPtr--];
                        ++i2;
                    }
                    continue block6;
                }
                case 0: {
                    int size = this.astLengthStack[this.astLengthPtr--];
                    int i2 = 0;
                    while (i2 < size) {
                        Expression reference;
                        if ((reference = (Expression)this.astStack[this.astPtr--]) instanceof JavadocSingleNameReference) {
                            this.docComment.paramReferences[--paramRefPtr] = (JavadocSingleNameReference)reference;
                        } else if (reference instanceof JavadocSingleTypeReference) {
                            this.docComment.paramTypeParameters[--paramTypeParamPtr] = (JavadocSingleTypeReference)reference;
                        }
                        ++i2;
                    }
                    continue block6;
                }
            }
        }
        if (paramRefPtr == 0) {
            this.docComment.paramTypeParameters = null;
        } else if (paramTypeParamPtr == 0) {
            this.docComment.paramReferences = null;
        } else {
            int size = sizes[0];
            this.docComment.paramReferences = new JavadocSingleNameReference[size - paramRefPtr];
            System.arraycopy(this.docComment.paramReferences, paramRefPtr, this.docComment.paramReferences, 0, size - paramRefPtr);
            this.docComment.paramTypeParameters = new JavadocSingleTypeReference[size - paramTypeParamPtr];
            System.arraycopy(this.docComment.paramTypeParameters, paramTypeParamPtr, this.docComment.paramTypeParameters, 0, size - paramTypeParamPtr);
        }
    }
}

