/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.OriginatorInfo;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSPBEKey;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.KEKRecipientInfoGenerator;
import org.bouncycastle.cms.OriginatorInformation;
import org.bouncycastle.cms.PKCS5Scheme2UTF8PBEKey;
import org.bouncycastle.cms.PasswordRecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKEKRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JcePasswordRecipientInfoGenerator;

public class CMSEnvelopedGenerator {
    public static final String DES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String RC2_CBC = PKCSObjectIdentifiers.RC2_CBC.getId();
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String CAMELLIA128_CBC = NTTObjectIdentifiers.id_camellia128_cbc.getId();
    public static final String CAMELLIA192_CBC = NTTObjectIdentifiers.id_camellia192_cbc.getId();
    public static final String CAMELLIA256_CBC = NTTObjectIdentifiers.id_camellia256_cbc.getId();
    public static final String SEED_CBC = KISAObjectIdentifiers.id_seedCBC.getId();
    public static final String DES_EDE3_WRAP = PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId();
    public static final String AES128_WRAP = NISTObjectIdentifiers.id_aes128_wrap.getId();
    public static final String AES192_WRAP = NISTObjectIdentifiers.id_aes192_wrap.getId();
    public static final String AES256_WRAP = NISTObjectIdentifiers.id_aes256_wrap.getId();
    public static final String CAMELLIA128_WRAP = NTTObjectIdentifiers.id_camellia128_wrap.getId();
    public static final String CAMELLIA192_WRAP = NTTObjectIdentifiers.id_camellia192_wrap.getId();
    public static final String CAMELLIA256_WRAP = NTTObjectIdentifiers.id_camellia256_wrap.getId();
    public static final String SEED_WRAP = KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId();
    public static final String ECDH_SHA1KDF = X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme.getId();
    public static final String ECMQV_SHA1KDF = X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme.getId();
    final List oldRecipientInfoGenerators = new ArrayList();
    final List recipientInfoGenerators = new ArrayList();
    protected CMSAttributeTableGenerator unprotectedAttributeGenerator = null;
    final SecureRandom rand;
    protected OriginatorInfo originatorInfo;

    public CMSEnvelopedGenerator() {
        this(new SecureRandom());
    }

    public CMSEnvelopedGenerator(SecureRandom secureRandom) {
        this.rand = secureRandom;
    }

    public void setUnprotectedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.unprotectedAttributeGenerator = cMSAttributeTableGenerator;
    }

    public void setOriginatorInfo(OriginatorInformation originatorInformation) {
        this.originatorInfo = originatorInformation.toASN1Structure();
    }

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        try {
            this.oldRecipientInfoGenerators.add(new JceKeyTransRecipientInfoGenerator(x509Certificate));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("unable to encode certificate: " + certificateEncodingException.getMessage());
        }
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        this.oldRecipientInfoGenerators.add(new JceKeyTransRecipientInfoGenerator(byArray, publicKey));
    }

    public void addKEKRecipient(SecretKey secretKey, byte[] byArray) {
        this.addKEKRecipient(secretKey, new KEKIdentifier(byArray, null, null));
    }

    public void addKEKRecipient(SecretKey secretKey, KEKIdentifier kEKIdentifier) {
        this.oldRecipientInfoGenerators.add(new JceKEKRecipientInfoGenerator(kEKIdentifier, secretKey));
    }

    public void addPasswordRecipient(CMSPBEKey cMSPBEKey, String string) {
        this.oldRecipientInfoGenerators.add(new JcePasswordRecipientInfoGenerator(new ASN1ObjectIdentifier(string), cMSPBEKey.getPassword()).setSaltAndIterationCount(cMSPBEKey.getSalt(), cMSPBEKey.getIterationCount()).setPasswordConversionScheme(cMSPBEKey instanceof PKCS5Scheme2UTF8PBEKey ? 1 : 0));
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, String string3) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipient(string, privateKey, publicKey, x509Certificate, string2, CMSUtils.getProvider(string3));
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        this.addKeyAgreementRecipients(string, privateKey, publicKey, arrayList, string2, provider);
    }

    public void addKeyAgreementRecipients(String string, PrivateKey privateKey, PublicKey publicKey, Collection collection, String string2, String string3) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipients(string, privateKey, publicKey, collection, string2, CMSUtils.getProvider(string3));
    }

    public void addKeyAgreementRecipients(String string, PrivateKey privateKey, PublicKey publicKey, Collection collection, String string2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        JceKeyAgreeRecipientInfoGenerator jceKeyAgreeRecipientInfoGenerator = new JceKeyAgreeRecipientInfoGenerator(new ASN1ObjectIdentifier(string), privateKey, publicKey, new ASN1ObjectIdentifier(string2)).setProvider(provider);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                jceKeyAgreeRecipientInfoGenerator.addRecipient((X509Certificate)iterator.next());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IllegalArgumentException("unable to encode certificate: " + certificateEncodingException.getMessage());
            }
        }
        this.oldRecipientInfoGenerators.add(jceKeyAgreeRecipientInfoGenerator);
    }

    public void addRecipientInfoGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.recipientInfoGenerators.add(recipientInfoGenerator);
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String string, AlgorithmParameters algorithmParameters) throws IOException {
        ASN1Primitive aSN1Primitive = algorithmParameters != null ? ASN1Primitive.fromByteArray(algorithmParameters.getEncoded("ASN.1")) : DERNull.INSTANCE;
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(string), (ASN1Encodable)aSN1Primitive);
    }

    protected void convertOldRecipients(SecureRandom secureRandom, Provider provider) {
        for (Object e : this.oldRecipientInfoGenerators) {
            RecipientInfoGenerator recipientInfoGenerator;
            if (e instanceof JceKeyTransRecipientInfoGenerator) {
                recipientInfoGenerator = (JceKeyTransRecipientInfoGenerator)e;
                if (provider != null) {
                    ((JceKeyTransRecipientInfoGenerator)recipientInfoGenerator).setProvider(provider);
                }
                this.recipientInfoGenerators.add(recipientInfoGenerator);
                continue;
            }
            if (e instanceof KEKRecipientInfoGenerator) {
                recipientInfoGenerator = (JceKEKRecipientInfoGenerator)e;
                if (provider != null) {
                    ((JceKEKRecipientInfoGenerator)recipientInfoGenerator).setProvider(provider);
                }
                ((JceKEKRecipientInfoGenerator)recipientInfoGenerator).setSecureRandom(secureRandom);
                this.recipientInfoGenerators.add(recipientInfoGenerator);
                continue;
            }
            if (e instanceof JcePasswordRecipientInfoGenerator) {
                recipientInfoGenerator = (JcePasswordRecipientInfoGenerator)e;
                if (provider != null) {
                    ((JcePasswordRecipientInfoGenerator)recipientInfoGenerator).setProvider(provider);
                }
                ((PasswordRecipientInfoGenerator)recipientInfoGenerator).setSecureRandom(secureRandom);
                this.recipientInfoGenerators.add(recipientInfoGenerator);
                continue;
            }
            if (!(e instanceof JceKeyAgreeRecipientInfoGenerator)) continue;
            recipientInfoGenerator = (JceKeyAgreeRecipientInfoGenerator)e;
            if (provider != null) {
                ((JceKeyAgreeRecipientInfoGenerator)recipientInfoGenerator).setProvider(provider);
            }
            ((JceKeyAgreeRecipientInfoGenerator)recipientInfoGenerator).setSecureRandom(secureRandom);
            this.recipientInfoGenerators.add(recipientInfoGenerator);
        }
        this.oldRecipientInfoGenerators.clear();
    }
}

