/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.io.Serializable;
import java.util.Iterator;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.InvalidPropertyValueException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.schema.types.Schema;

public abstract class AbstractProperty
implements Property {
    private static final long serialVersionUID = -4689902294497020548L;
    public static final int IS_READONLY = 32;
    public static final int IS_VALIDATING = 64;
    public static final int KEYED_DATA = 128;
    protected final Property parent;
    protected int flags;
    protected Object data;

    protected AbstractProperty(Property parent) {
        this.parent = parent;
    }

    protected AbstractProperty(Property parent, int flags) {
        this.parent = parent;
        this.flags = flags;
    }

    public abstract void internalSetValue(Serializable var1) throws PropertyException;

    public abstract Serializable internalGetValue() throws PropertyException;

    @Override
    public void init(Serializable value) throws PropertyException {
        if (value == null) {
            return;
        }
        this.internalSetValue(value);
        this.removePhantomFlag();
    }

    public void removePhantomFlag() {
        this.flags &= 0xFFFFFFEF;
        if (this.parent != null) {
            ((AbstractProperty)this.parent).removePhantomFlag();
        }
    }

    @Override
    public void setValue(int index, Object value) throws PropertyException {
        Property property = this.get(index);
        property.setValue(value);
    }

    @Override
    public int size() {
        return this.getChildren().size();
    }

    @Override
    public Iterator<Property> iterator() {
        return this.getChildren().iterator();
    }

    @Override
    public Serializable remove() throws PropertyException {
        Serializable value = this.getValue();
        if (this.parent != null && this.parent.isList()) {
            ListProperty list = (ListProperty)this.parent;
            list.remove(this);
        } else if (!this.isPhantom()) {
            this.init(null);
            this.setIsRemoved();
        }
        return value;
    }

    @Override
    public Property getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        Path path = this.collectPath(new Path("/"));
        return path.toString();
    }

    protected Path collectPath(Path path) {
        String name = this.getName();
        if (this.parent != null) {
            if (this.parent.isList()) {
                int i = ((ListProperty)this.parent).children.indexOf(this);
                name = name + '[' + i + ']';
            }
            path = ((AbstractProperty)this.parent).collectPath(path);
        }
        return path.append(name);
    }

    @Override
    public Schema getSchema() {
        return this.getRoot().getSchema();
    }

    @Override
    public boolean isList() {
        return this.getType().isListType();
    }

    @Override
    public boolean isComplex() {
        return this.getType().isComplexType();
    }

    @Override
    public boolean isScalar() {
        return this.getType().isSimpleType();
    }

    @Override
    public boolean isNew() {
        return this.areFlagsSet(1L);
    }

    @Override
    public boolean isRemoved() {
        return this.areFlagsSet(4L);
    }

    @Override
    public boolean isMoved() {
        return this.areFlagsSet(8L);
    }

    @Override
    public boolean isModified() {
        return this.areFlagsSet(2L);
    }

    @Override
    public boolean isPhantom() {
        return this.areFlagsSet(16L);
    }

    @Override
    public final boolean isDirty() {
        return (this.flags & 0xF) != 0;
    }

    protected final void setDirtyFlags(int dirtyFlags) {
        this.flags = dirtyFlags & 0x1F | this.flags & 0xFFFFFFE0;
    }

    protected final void appendDirtyFlags(int dirtyFlags) {
        this.flags |= dirtyFlags & 0x1F;
    }

    @Override
    public boolean isValidating() {
        return this.areFlagsSet(64L);
    }

    @Override
    public boolean isReadOnly() {
        return this.areFlagsSet(32L);
    }

    @Override
    public void setReadOnly(boolean value) {
        if (value) {
            this.setFlags(32L);
        } else {
            this.clearFlags(32L);
        }
    }

    @Override
    public void setValidating(boolean value) {
        if (value) {
            this.setFlags(64L);
        } else {
            this.clearFlags(64L);
        }
    }

    public final boolean areFlagsSet(long flags) {
        return ((long)this.flags & flags) != 0L;
    }

    public final void setFlags(long flags) {
        this.flags = (int)((long)this.flags | flags);
    }

    public final void clearFlags(long flags) {
        this.flags = (int)((long)this.flags & (flags ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public int getDirtyFlags() {
        return this.flags & 0x1F;
    }

    @Override
    public void clearDirtyFlags() {
        if ((this.flags & 4) != 0) {
            this.setDirtyFlags(16);
        } else {
            this.setDirtyFlags(0);
        }
    }

    public void setIsModified() {
        if ((this.flags & 2) == 0) {
            this.flags |= 2;
            this.flags &= 0xFFFFFFEF;
            if (this.parent != null) {
                ((AbstractProperty)this.parent).setIsModified();
            }
        }
    }

    protected void setIsNew() {
        if (this.isDirty()) {
            throw new IllegalStateException("Cannot set IS_NEW flag on a dirty property");
        }
        this.setDirtyFlags(1);
        if (this.parent != null) {
            ((AbstractProperty)this.parent).setIsModified();
        }
    }

    protected void setIsRemoved() {
        if (this.isPhantom() || this.parent == null || this.parent.isList()) {
            throw new IllegalStateException("Cannot set IS_REMOVED on removed or properties that are not map elements");
        }
        if ((this.flags & 4) == 0) {
            this.setDirtyFlags(4);
            ((AbstractProperty)this.parent).setIsModified();
        }
    }

    protected void setIsMoved() {
        if (this.parent == null || !this.parent.isList()) {
            throw new IllegalStateException("Cannot set IS_MOVED on removed or properties that are not map elements");
        }
        if ((this.flags & 8) == 0) {
            this.flags |= 8;
            ((AbstractProperty)this.parent).setIsModified();
        }
    }

    @Override
    public <T> T getValue(Class<T> type) throws PropertyException {
        return this.convertTo(this.getValue(), type);
    }

    @Override
    public void setValue(Object value) throws PropertyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyPropertyException(this.getPath());
        }
        Serializable normalizedValue = this.normalize(value);
        if (this.areFlagsSet(64L) && !this.validate(normalizedValue)) {
            throw new InvalidPropertyValueException("validating failed for " + normalizedValue);
        }
        this.internalSetValue(normalizedValue);
        this.setIsModified();
    }

    @Override
    public void setValue(String path, Object value) throws PropertyException {
        this.resolvePath(path).setValue(value);
    }

    @Override
    public <T> T getValue(Class<T> type, String path) throws PropertyException {
        return this.resolvePath(path).getValue(type);
    }

    @Override
    public Serializable getValue(String path) throws PropertyException {
        return this.resolvePath(path).getValue();
    }

    @Override
    public Serializable getValue() throws PropertyException {
        if (this.isPhantom() || this.isRemoved()) {
            return this.getDefaultValue();
        }
        return this.internalGetValue();
    }

    @Override
    public Serializable getValueForWrite() throws PropertyException {
        return this.getValue();
    }

    protected Serializable getDefaultValue() {
        return (Serializable)this.getField().getDefaultValue();
    }

    @Override
    public void moveTo(int index) {
        if (this.parent == null || !this.parent.isList()) {
            throw new UnsupportedOperationException("Not a list item property");
        }
        ListProperty list = (ListProperty)this.parent;
        if (list.moveTo(this, index)) {
            this.setIsMoved();
        }
    }

    @Override
    public DocumentPart getRoot() {
        return this.parent == null ? (DocumentPart)((Object)this) : this.parent.getRoot();
    }

    @Override
    public Property resolvePath(String path) throws PropertyNotFoundException {
        return this.resolvePath(new Path(path));
    }

    @Override
    public Property resolvePath(Path path) throws PropertyNotFoundException {
        if (path.isAbsolute()) {
            return this.getRoot().resolvePath(path.makeRelative());
        }
        String[] segments = path.segments();
        Property property = this;
        for (int start = 0; start < segments.length && segments[start].equals(".."); ++start) {
            property = property.getParent();
        }
        for (int i = start; i < segments.length; ++i) {
            String segment = segments[i];
            if (property.isScalar()) {
                throw new PropertyNotFoundException(path.toString(), "segment " + segment + " points to a scalar property");
            }
            String index = null;
            if (segment.endsWith("]")) {
                int p = segment.lastIndexOf(91);
                if (p == -1) {
                    throw new PropertyNotFoundException(path.toString(), "Parse error: no matching '[' was found");
                }
                index = segment.substring(p + 1, segment.length() - 1);
                segment = segment.substring(0, p);
            }
            if (index == null) {
                if ((property = property.get(segment)) != null) continue;
                throw new PropertyNotFoundException(path.toString(), "segment " + segments[i] + " cannot be resolved");
            }
            property = property.get(index);
        }
        return property;
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        throw new PropertyConversionException(value.getClass(), Serializable.class, this.getPath());
    }

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value instanceof Serializable;
    }

    @Override
    public <T> T convertTo(Serializable value, Class<T> toType) throws PropertyConversionException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean validateType(Class<?> type) {
        return true;
    }

    @Override
    public boolean validate(Serializable value) {
        return true;
    }

    @Override
    public Object newInstance() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getPath() + ')';
    }

    @Override
    public Object getData() {
        return (this.flags & 0x80) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    @Override
    public Object getData(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Data Key must not be null");
        }
        if ((this.flags & 0x80) != 0) {
            Object[] table = (Object[])this.data;
            for (int i = 1; i < table.length; i += 2) {
                if (!key.equals(table[i])) continue;
                return table[i + 1];
            }
        }
        return null;
    }

    @Override
    public void setData(Object value) {
        if ((this.flags & 0x80) != 0) {
            ((Object[])this.data)[0] = value;
        } else {
            this.data = value;
        }
    }

    @Override
    public void setData(String key, Object value) {
        int index;
        if (key == null) {
            throw new IllegalArgumentException("Data Key must not be null");
        }
        Object[] table = null;
        if ((this.flags & 0x80) != 0) {
            table = (Object[])this.data;
            for (index = 1; index < table.length && !key.equals(table[index]); index += 2) {
            }
        }
        if (value != null) {
            if ((this.flags & 0x80) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.flags |= 0x80;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.flags & 0x80) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.flags &= 0xFFFFFF7F;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
    }
}

