/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.DefaultStreamBlob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.StreamManager;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class LazyBlob
extends DefaultStreamBlob
implements Serializable {
    private static final long serialVersionUID = -6138173743804682559L;
    private static final Log log = LogFactory.getLog(LazyBlob.class);
    public static final InputStream EMPTY_INPUT_STREAM = new EmptyInputStream();
    private static final Random RANDOM = new Random();
    private static final File TMP_DIR = new File(Framework.getRuntime().getHome(), "tmp/blobs");
    private String sid;
    private final String repositoryName;
    private final String dataKey;
    private transient InputStream in;
    private transient File file;
    private final long length;

    public LazyBlob(InputStream in, String encoding, String mimeType, String sid, String dataKey, String repositoryName, String filename, String digest, long length) {
        this.in = in == null ? EMPTY_INPUT_STREAM : in;
        this.encoding = encoding;
        this.mimeType = mimeType;
        this.sid = sid;
        this.dataKey = dataKey;
        this.repositoryName = repositoryName;
        this.filename = filename;
        this.digest = digest;
        this.length = length;
    }

    public LazyBlob(InputStream in, String encoding, String mimeType, String sid, String dataKey, String repositoryName) {
        this(in, encoding, mimeType, sid, dataKey, repositoryName, null, null, -1L);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public String getSid() {
        return this.sid;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void reset() {
        FileUtils.close((InputStream)this.in);
        this.in = null;
    }

    private CoreSession getClient() throws ClientException {
        CoreSession client = null;
        if (this.sid != null) {
            client = CoreInstance.getInstance().getSession(this.sid);
        }
        if (client == null) {
            if (this.repositoryName != null) {
                this.sid = null;
                HashMap<String, Serializable> ctx = new HashMap<String, Serializable>();
                client = CoreInstance.getInstance().open(this.repositoryName, ctx);
            } else {
                throw new ClientException("Cannot reconnect to a Nuxeo core instance... No repository name provided...");
            }
        }
        return client;
    }

    @Override
    public InputStream getStream() throws IOException {
        CoreSession client;
        try {
            client = this.getClient();
        }
        catch (ClientException ce) {
            throw new IOException(ce.getMessage());
        }
        if (this.in == null) {
            StreamManager sm = (StreamManager)Framework.getLocalService(StreamManager.class);
            String uri = null;
            try {
                if (sm == null) {
                    throw new IOException("No Streaming service was registered");
                }
                uri = client.getStreamURI(this.dataKey);
                StreamSource src = sm.getStream(uri);
                this.file = new File(TMP_DIR, Long.toHexString(RANDOM.nextLong()));
                this.file.deleteOnExit();
                src.copyTo(this.file);
                Framework.trackFile((File)this.file, (Object)this);
                this.in = new FileInputStream(this.file);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new IOException("Failed to load lazy content for: " + this.dataKey);
            }
            finally {
                if (uri != null) {
                    sm.removeStream(uri);
                }
            }
        } else if (this.file != null) {
            this.in = new FileInputStream(this.file);
        }
        if (this.sid == null) {
            CoreInstance.getInstance().close(client);
        }
        return this.in;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public Blob persist() throws IOException {
        if (this.in == null) {
            this.getStream();
        }
        return new FileBlob(this.in, this.mimeType, this.encoding);
    }

    protected void finalize() {
        if (this.file != null) {
            FileUtils.close((InputStream)this.in);
            this.file.delete();
        }
    }

    protected static boolean equalValues(Object first, Object second) {
        if (first == null) {
            return second == null;
        }
        return first.equals(second);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LazyBlob)) {
            return false;
        }
        LazyBlob other = (LazyBlob)obj;
        boolean encodingEquals = LazyBlob.equalValues(this.encoding, other.encoding);
        if (!encodingEquals) {
            return false;
        }
        boolean mimetypeEquals = LazyBlob.equalValues(this.mimeType, other.mimeType);
        if (!mimetypeEquals) {
            return false;
        }
        boolean sidEquals = LazyBlob.equalValues(this.sid, other.sid);
        if (!sidEquals) {
            return false;
        }
        boolean dataKeyEquals = LazyBlob.equalValues(this.dataKey, other.dataKey);
        if (!dataKeyEquals) {
            return false;
        }
        return LazyBlob.equalValues(this.repositoryName, other.repositoryName);
    }

    public int hashCode() {
        int result = this.sid != null ? this.sid.hashCode() : 0;
        result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
        result = 31 * result + (this.dataKey != null ? this.dataKey.hashCode() : 0);
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        return result;
    }

    static {
        TMP_DIR.mkdirs();
    }

    public static class EmptyInputStream
    extends InputStream {
        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

