/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.DefaultStreamBlob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

public class InputStreamBlob
extends DefaultStreamBlob {
    private static final long serialVersionUID = 2044137587685886328L;
    protected final InputStream in;
    protected File file;

    public InputStreamBlob(InputStream in) {
        this(in, null, null);
    }

    public InputStreamBlob(InputStream in, String ctype) {
        this(in, ctype, null);
    }

    public InputStreamBlob(InputStream in, String ctype, String encoding) {
        this.in = in;
        this.mimeType = ctype;
        this.encoding = encoding;
    }

    public InputStreamBlob(InputStream in, String ctype, String encoding, String filename, String digest) {
        this.in = in;
        this.mimeType = ctype;
        this.encoding = encoding;
        this.filename = filename;
        this.digest = digest;
    }

    @Override
    public InputStream getStream() {
        return this.in;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public Blob persist() throws IOException {
        return new FileBlob(this.in, this.mimeType, this.encoding);
    }
}

