/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;

public class FacetFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    public static final FacetFilter ALLOW = new FacetFilter((List<String>)null, (List<String>)null);
    public final Set<String> required;
    public final Set<String> excluded;
    public final Boolean shortcut;

    public FacetFilter(List<String> required, List<String> excluded) {
        this.required = required == null ? Collections.emptySet() : new HashSet<String>(required);
        this.excluded = excluded == null ? Collections.emptySet() : new HashSet<String>(excluded);
        this.shortcut = this.findShortcut();
    }

    public FacetFilter(String facet, boolean isRequired) {
        if (isRequired) {
            this.required = Collections.singleton(facet);
            this.excluded = Collections.emptySet();
        } else {
            this.required = Collections.emptySet();
            this.excluded = Collections.singleton(facet);
        }
        this.shortcut = null;
    }

    public FacetFilter(FacetFilter filter1, FacetFilter filter2) {
        if (filter1.required.isEmpty() && filter2.required.isEmpty()) {
            this.required = Collections.emptySet();
        } else {
            this.required = new HashSet<String>(filter1.required);
            this.required.addAll(filter2.required);
        }
        if (filter1.excluded.isEmpty() && filter2.excluded.isEmpty()) {
            this.excluded = Collections.emptySet();
        } else {
            this.excluded = new HashSet<String>(filter1.excluded);
            this.excluded.addAll(filter2.excluded);
        }
        this.shortcut = this.findShortcut();
    }

    protected Boolean findShortcut() {
        if (this.required.isEmpty() && this.excluded.isEmpty()) {
            return Boolean.TRUE;
        }
        HashSet<String> intersection = new HashSet<String>(this.required);
        intersection.retainAll(this.excluded);
        if (!intersection.isEmpty()) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean accept(DocumentModel docModel) {
        if (this.shortcut != null) {
            return this.shortcut;
        }
        for (String exc : this.excluded) {
            if (!docModel.hasFacet(exc)) continue;
            return false;
        }
        for (String req : this.required) {
            if (docModel.hasFacet(req)) continue;
            return false;
        }
        return true;
    }
}

