/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

public class DocumentsPageProvider
implements PagedDocumentsProvider {
    private static final long serialVersionUID = 1016097877999734437L;
    private static final Log log = LogFactory.getLog(DocumentsPageProvider.class);
    private final DocumentModelIterator docsIterator;
    private final int pageSize;
    private int currentPageIndex = -1;
    private final List<DocumentModelList> loadedPages = new ArrayList<DocumentModelList>();
    private long totalResultsCount;
    private String providerName;

    public DocumentsPageProvider(DocumentModelIterator docsIterator, int pageSize) {
        this.docsIterator = docsIterator;
        this.pageSize = pageSize;
        this.totalResultsCount = docsIterator.size();
    }

    public void setCurrentPage(int page) {
        this.getPage(page);
    }

    @Override
    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    @Override
    public DocumentModelList getCurrentPage() {
        if (this.currentPageIndex == -1) {
            return this.getPage(0);
        }
        return this.getPage(this.currentPageIndex);
    }

    @Override
    public DocumentModelList getPage(int page) {
        if (page < 0) {
            page = 0;
        }
        DocumentModelList docsPage = null;
        if (this.loadedPages.size() > page) {
            docsPage = this.loadedPages.get(page);
            this.currentPageIndex = page;
        } else {
            while (this.currentPageIndex < page) {
                if (this.docsIterator.hasNext()) {
                    docsPage = this.loadNextPage();
                    this.loadedPages.add(docsPage);
                    continue;
                }
                docsPage = new DocumentModelListImpl();
                break;
            }
        }
        return docsPage;
    }

    @Override
    public boolean isNextPageAvailable() {
        return this.docsIterator.hasNext() || this.currentPageIndex < this.loadedPages.size() - 1;
    }

    private DocumentModelList loadNextPage() {
        if (!this.docsIterator.hasNext()) {
            return new DocumentModelListImpl();
        }
        ++this.currentPageIndex;
        DocumentModelListImpl docsPage = new DocumentModelListImpl();
        for (int i = 0; i < this.pageSize; ++i) {
            if (this.docsIterator.hasNext()) {
                try {
                    DocumentModel docModel = (DocumentModel)this.docsIterator.next();
                    docsPage.add(docModel);
                    continue;
                }
                catch (NoSuchElementException e) {
                    log.error((Object)"Unpredicted end of iterator !!");
                    this.endReached(i);
                    break;
                }
            }
            this.endReached(i);
            break;
        }
        return docsPage;
    }

    private void endReached(int posInPage) {
        if (-1L == this.totalResultsCount) {
            this.totalResultsCount = this.pageSize * this.currentPageIndex + posInPage;
        }
    }

    @Override
    public long getResultsCount() {
        long resultsCount = this.totalResultsCount;
        if (-1L == resultsCount) {
            resultsCount = -1L;
        }
        return resultsCount;
    }

    @Override
    public boolean isPreviousPageAvailable() {
        return this.currentPageIndex > 0;
    }

    @Override
    public void last() {
        int lastPage = this.getNumberOfPages();
        if (lastPage == -1) {
            while (this.isNextPageAvailable()) {
                this.getNextPage();
            }
        } else {
            this.setCurrentPage(lastPage - 1);
        }
    }

    @Override
    public DocumentModelList getNextPage() {
        return this.getPage(this.currentPageIndex + 1);
    }

    @Override
    public void next() {
        this.getPage(this.currentPageIndex + 1);
    }

    @Override
    public void previous() {
        if (this.currentPageIndex > 0) {
            this.setCurrentPage(this.currentPageIndex - 1);
        }
    }

    @Override
    public void rewind() {
        this.getPage(0);
    }

    @Override
    public int getNumberOfPages() {
        long size = this.docsIterator.size();
        if (size == -1L) {
            return -1;
        }
        return (int)(1L + (size - 1L) / (long)this.pageSize);
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getCurrentPageStatus() {
        int total = this.getNumberOfPages();
        int current = this.currentPageIndex + 1;
        if (total == -1) {
            return String.format("%d", current);
        }
        return String.format("%d/%d", current, total);
    }

    @Override
    public int getCurrentPageOffset() {
        return this.currentPageIndex * this.pageSize;
    }

    @Override
    public int getCurrentPageSize() {
        return this.getCurrentPage().size();
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public String getName() {
        return this.providerName;
    }

    @Override
    public SortInfo getSortInfo() {
        return null;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public void setName(String name) {
        this.providerName = name;
    }
}

