/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.impl.AbstractProperty;
import org.nuxeo.ecm.core.api.model.impl.DefaultPropertyFactory;

public class DataModelImpl
implements DataModel {
    private static final long serialVersionUID = -186670993439802490L;
    private final DocumentPart dp;

    public DataModelImpl(String schema) {
        this(schema, new HashMap<String, Object>());
    }

    public DataModelImpl(String schema, Map<String, Object> data) {
        assert (data != null);
        this.dp = DefaultPropertyFactory.newDocumentPart(schema);
        if (!data.isEmpty()) {
            try {
                this.dp.init((Serializable)((Object)data));
            }
            catch (PropertyException e) {
                throw new ClientRuntimeException(e);
            }
        }
    }

    public DataModelImpl(DocumentPart part) {
        assert (part != null);
        this.dp = part;
    }

    public DocumentPart getDocumentPart() {
        return this.dp;
    }

    @Override
    public String getSchema() {
        return this.dp.getSchema().getName();
    }

    @Override
    public Object getData(String key) throws PropertyException {
        return this.dp.getValue(key);
    }

    @Override
    public void setData(String key, Object value) throws PropertyException {
        this.dp.setValue(key, value);
    }

    @Override
    public Map<String, Object> getMap() throws PropertyException {
        return (Map)((Object)this.dp.getValue());
    }

    @Override
    public void setMap(Map<String, Object> data) throws PropertyException {
        this.dp.setValue(data);
    }

    @Override
    public boolean isDirty() {
        return this.dp.isDirty();
    }

    @Override
    public boolean isDirty(String name) throws PropertyNotFoundException {
        return this.dp.get(name).isDirty();
    }

    @Override
    public Collection<String> getDirtyFields() {
        ArrayList<String> dirtyFields = new ArrayList<String>();
        for (Property prop : this.dp.getChildren()) {
            if (!prop.isDirty()) continue;
            dirtyFields.add(prop.getName());
        }
        return dirtyFields;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getSchema() + (this.dp.isDirty() ? "*" : "") + ')';
    }

    @Override
    public void setDirty(String name) throws PropertyNotFoundException {
        ((AbstractProperty)this.dp.get(name)).setIsModified();
    }

    @Override
    public Object getValue(String path) throws PropertyException {
        return this.dp.getValue(path);
    }

    @Override
    public Object setValue(String path, Object value) throws PropertyException {
        Property prop = this.dp.resolvePath(path);
        Serializable oldValue = prop.getValue();
        prop.setValue(value);
        return oldValue;
    }
}

