/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;
import org.apache.poi.hssf.record.formula.ExpPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.CellReference;

public final class FormulaRecordAggregate
extends RecordAggregate
implements CellValueRecordInterface {
    private final FormulaRecord _formulaRecord;
    private SharedValueManager _sharedValueManager;
    private StringRecord _stringRecord;
    private SharedFormulaRecord _sharedFormulaRecord;

    public FormulaRecordAggregate(FormulaRecord formulaRec, StringRecord stringRec, SharedValueManager svm) {
        if (svm == null) {
            throw new IllegalArgumentException("sfm must not be null");
        }
        if (formulaRec.hasCachedResultString()) {
            if (stringRec == null) {
                throw new RecordFormatException("Formula record flag is set but String record was not found");
            }
            this._stringRecord = stringRec;
        } else {
            this._stringRecord = null;
        }
        if (formulaRec.isSharedFormula()) {
            CellReference firstCell = formulaRec.getFormula().getExpReference();
            if (firstCell == null) {
                FormulaRecordAggregate.handleMissingSharedFormulaRecord(formulaRec);
            } else {
                this._sharedFormulaRecord = svm.linkSharedFormulaRecord(firstCell, this);
            }
        }
        this._formulaRecord = formulaRec;
        this._sharedValueManager = svm;
    }

    private static void handleMissingSharedFormulaRecord(FormulaRecord formula) {
        Ptg firstToken = formula.getParsedExpression()[0];
        if (firstToken instanceof ExpPtg) {
            throw new RecordFormatException("SharedFormulaRecord not found for FormulaRecord with (isSharedFormula=true)");
        }
        formula.setSharedFormula(false);
    }

    public FormulaRecord getFormulaRecord() {
        return this._formulaRecord;
    }

    public StringRecord getStringRecord() {
        return this._stringRecord;
    }

    public short getXFIndex() {
        return this._formulaRecord.getXFIndex();
    }

    public void setXFIndex(short xf) {
        this._formulaRecord.setXFIndex(xf);
    }

    public void setColumn(short col) {
        this._formulaRecord.setColumn(col);
    }

    public void setRow(int row) {
        this._formulaRecord.setRow(row);
    }

    public short getColumn() {
        return this._formulaRecord.getColumn();
    }

    public int getRow() {
        return this._formulaRecord.getRow();
    }

    public String toString() {
        return this._formulaRecord.toString();
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        SharedValueRecordBase sharedFormulaRecord;
        rv.visitRecord(this._formulaRecord);
        CellReference sharedFirstCell = this._formulaRecord.getFormula().getExpReference();
        if (sharedFirstCell != null && (sharedFormulaRecord = this._sharedValueManager.getRecordForFirstCell(sharedFirstCell, this)) != null) {
            rv.visitRecord(sharedFormulaRecord);
        }
        if (this._formulaRecord.hasCachedResultString() && this._stringRecord != null) {
            rv.visitRecord(this._stringRecord);
        }
    }

    public String getStringValue() {
        if (this._stringRecord == null) {
            return null;
        }
        return this._stringRecord.getString();
    }

    public void setCachedStringResult(String value) {
        if (this._stringRecord == null) {
            this._stringRecord = new StringRecord();
        }
        this._stringRecord.setString(value);
        if (value.length() < 1) {
            this._formulaRecord.setCachedResultTypeEmptyString();
        } else {
            this._formulaRecord.setCachedResultTypeString();
        }
    }

    public void setCachedBooleanResult(boolean value) {
        this._stringRecord = null;
        this._formulaRecord.setCachedResultBoolean(value);
    }

    public void setCachedErrorResult(int errorCode) {
        this._stringRecord = null;
        this._formulaRecord.setCachedResultErrorCode(errorCode);
    }

    public void setCachedDoubleResult(double value) {
        this._stringRecord = null;
        this._formulaRecord.setValue(value);
    }

    public Ptg[] getFormulaTokens() {
        if (this._sharedFormulaRecord == null) {
            return this._formulaRecord.getParsedExpression();
        }
        return this._sharedFormulaRecord.getFormulaTokens(this._formulaRecord);
    }

    public void setParsedExpression(Ptg[] ptgs) {
        this.notifyFormulaChanging();
        this._formulaRecord.setParsedExpression(ptgs);
    }

    public void unlinkSharedFormula() {
        SharedFormulaRecord sfr = this._sharedFormulaRecord;
        if (sfr == null) {
            throw new IllegalStateException("Formula not linked to shared formula");
        }
        Ptg[] ptgs = sfr.getFormulaTokens(this._formulaRecord);
        this._formulaRecord.setParsedExpression(ptgs);
        this._formulaRecord.setSharedFormula(false);
        this._sharedFormulaRecord = null;
    }

    public void notifyFormulaChanging() {
        if (this._sharedFormulaRecord != null) {
            this._sharedValueManager.unlink(this._sharedFormulaRecord);
        }
    }
}

