/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.el.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import org.jboss.el.lang.ELSupport;
import org.jboss.el.util.MessageFactory;
import org.jboss.el.util.ReferenceCache;

public final class ReflectionUtil {
    protected static final String[] EMPTY_STRING = new String[0];
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private static ReferenceCache<Class, MethodCache> methodCache = new ReferenceCache<Class, MethodCache>(ReferenceCache.Type.Weak, ReferenceCache.Type.Soft){

        @Override
        public MethodCache create(Class key) {
            return new MethodCache(key);
        }
    };
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private static Class[] NO_TYPES = new Class[0];

    private ReflectionUtil() {
    }

    public static Class forName(String name) throws ClassNotFoundException {
        if (null == name || "".equals(name)) {
            return null;
        }
        Class<?> c = ReflectionUtil.forNamePrimitive(name);
        if (c == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c = Class.forName(nc, true, Thread.currentThread().getContextClassLoader());
                c = Array.newInstance(c, 0).getClass();
            } else {
                c = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            }
        }
        return c;
    }

    protected static Class forNamePrimitive(String name) {
        int p;
        if (name.length() <= 8 && (p = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p];
        }
        return null;
    }

    public static Class[] toTypeArray(String[] s) throws ClassNotFoundException {
        if (s == null) {
            return null;
        }
        Class[] c = new Class[s.length];
        for (int i = 0; i < s.length; ++i) {
            c[i] = ReflectionUtil.forName(s[i]);
        }
        return c;
    }

    public static String[] toTypeNameArray(Class[] c) {
        if (c == null) {
            return null;
        }
        String[] s = new String[c.length];
        for (int i = 0; i < c.length; ++i) {
            s[i] = c[i].getName();
        }
        return s;
    }

    private static Method pickBest(Class[] paramTypes, Method a, Method b) {
        int r = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i] == null) continue;
            r += ReflectionUtil.matches(paramTypes[i], a.getParameterTypes()[i]);
            r -= ReflectionUtil.matches(paramTypes[i], b.getParameterTypes()[i]);
        }
        return r >= 0 ? a : b;
    }

    private static int matches(Class t, Class p) {
        if (t == p || t.equals(p)) {
            return 2;
        }
        if (p.isAssignableFrom(t)) {
            return 1;
        }
        return 0;
    }

    public static Method findMethod(Object base, Object name, Object[] params) {
        Method r = null;
        if (base != null && name != null) {
            Class<?> type = base.getClass();
            String methodName = ELSupport.coerceToString(name);
            MethodCache m = methodCache.get(type);
            r = m.findMethod(methodName, params);
            if (r == null) {
                throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, name, ReflectionUtil.paramString(ReflectionUtil.paramTypes(params))));
            }
        } else {
            throw new MethodNotFoundException();
        }
        return r;
    }

    public static Method getMethod(Object base, Object property, Class[] paramTypes) throws MethodNotFoundException {
        if (base == null || property == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        String methodName = property instanceof String ? (String)property : property.toString();
        Method method = null;
        try {
            method = base.getClass().getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        return method;
    }

    public static MethodInfo getMethodInfo(Object base, Object property, Class[] paramTypes) throws MethodNotFoundException {
        Method m = ReflectionUtil.getMethod(base, property, paramTypes);
        return new MethodInfo(m.getName(), m.getReturnType(), (Class[])m.getParameterTypes());
    }

    public static MethodInfo getMethodInfo(Object base, Object property, Object[] paramValues) throws MethodNotFoundException {
        Method m = ReflectionUtil.findMethod(base, property, paramValues);
        return new MethodInfo(m.getName(), m.getReturnType(), (Class[])m.getParameterTypes());
    }

    public static Object invokeMethod(Object base, Object property, Object[] paramValues) throws ELException {
        Method m = ReflectionUtil.findMethod(base, property, paramValues);
        return ReflectionUtil.invokeMethod(base, m, paramValues);
    }

    public static Object invokeMethod(Object base, Method m, Object[] paramValues) throws ELException {
        if (m == null) {
            throw new MethodNotFoundException();
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        Object[] params = null;
        if (paramTypes.length != 0) {
            int i;
            if (paramValues == null) {
                throw new MethodNotFoundException(m.getDeclaringClass() + "." + m.getName() + " has " + paramTypes.length + " params");
            }
            if (m.isVarArgs()) {
                params = new Object[paramTypes.length];
                for (i = 0; i < paramTypes.length - 1; ++i) {
                    params[i] = ELSupport.coerceToType(paramValues[i], paramTypes[i]);
                }
                Class<?> argType = paramTypes[i].getComponentType();
                if (paramTypes.length == paramValues.length) {
                    if (paramValues[i] == null) {
                        params[i] = Array.newInstance(argType, 0);
                    } else if (paramValues[i].getClass().isArray()) {
                        params[i] = paramValues[i];
                    } else {
                        params[i] = Array.newInstance(argType, 1);
                        Array.set(params[i], 0, ELSupport.coerceToType(paramValues[i], argType));
                    }
                } else {
                    int len = paramValues.length - paramTypes.length + 1;
                    Object ar = Array.newInstance(argType, len);
                    for (int j = 0; j < len; ++j) {
                        Array.set(ar, j, ELSupport.coerceToType(paramValues[paramTypes.length - 1 + j], argType));
                    }
                    params[i] = ar;
                }
            } else if (paramValues.length == paramTypes.length) {
                params = new Object[paramTypes.length];
                for (i = 0; i < paramTypes.length; ++i) {
                    params[i] = ELSupport.coerceToType(paramValues[i], paramTypes[i]);
                }
            } else {
                throw new MethodNotFoundException(m.getDeclaringClass().getName() + "." + m.getName() + " has " + paramTypes.length + ", only passed " + paramValues.length + " parameters");
            }
        }
        try {
            return m.invoke(base, params);
        }
        catch (IllegalAccessException iae) {
            throw new ELException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
    }

    public static Object invokeMethod(Object base, Object property, Class[] paramTypes, Object[] paramValues) throws ELException, MethodNotFoundException {
        Method m = ReflectionUtil.getMethod(base, property, paramTypes);
        return ReflectionUtil.invokeMethod(base, m, paramValues);
    }

    protected static final String paramString(Class[] types) {
        if (types != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != null) {
                    sb.append(types[i].getName()).append(", ");
                    continue;
                }
                sb.append("null, ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    protected static final Class[] paramTypes(Object[] ar) {
        if (ar != null) {
            Class[] p = new Class[ar.length];
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i] == null) continue;
                p[i] = ar[i].getClass();
            }
            return p;
        }
        return NO_TYPES;
    }

    private static final class MethodCache {
        private final Method[] methods;
        private final Class type;
        private final Map<String, Object> cache;

        public MethodCache(Class type) {
            boolean isAnonymous = type.isAnonymousClass();
            boolean isPrivate = !Modifier.isPublic(type.getModifiers());
            this.type = type;
            this.methods = type.getMethods();
            this.cache = new HashMap<String, Object>();
            for (Method m : this.methods) {
                Object c;
                if ((isPrivate || isAnonymous) && Modifier.isPublic(m.getModifiers())) {
                    m.setAccessible(true);
                }
                if ((c = this.cache.get(m.getName())) == null) {
                    this.cache.put(m.getName(), m);
                    continue;
                }
                if (c instanceof Method) {
                    ArrayList<Object> l = new ArrayList<Object>(5);
                    l.add(m);
                    l.add(c);
                    this.cache.put(m.getName(), l);
                    continue;
                }
                ((List)c).add(m);
            }
        }

        public Class getType() {
            return this.type;
        }

        public Method findMethod(String name, Object[] in) {
            Object o = this.cache.get(name);
            if (o == null) {
                return null;
            }
            if (o instanceof Method) {
                return (Method)o;
            }
            Method r = null;
            Class[] types = ReflectionUtil.paramTypes(in);
            for (Method m : (List)o) {
                if (m.getParameterTypes().length != types.length) continue;
                if (r == null) {
                    r = m;
                    continue;
                }
                r = ReflectionUtil.pickBest(types, r, m);
            }
            return r;
        }
    }
}

