/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wi.backend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.wi.backend.AbstractCoreBackend;
import org.nuxeo.ecm.platform.wi.backend.Backend;
import org.nuxeo.ecm.platform.wi.backend.RealBackendFactory;
import org.nuxeo.ecm.platform.wi.backend.VirtualBackend;

public abstract class AbstractVirtualBackend
extends AbstractCoreBackend
implements VirtualBackend {
    private static final Log log = LogFactory.getLog(AbstractVirtualBackend.class);
    protected Map<String, Backend> backendMap;
    protected LinkedList<String> orderedBackendNames;
    protected String rootUrl;
    private String backendDisplayName;
    private RealBackendFactory realBackendFactory;

    protected AbstractVirtualBackend(String name, String rootUrl, RealBackendFactory realBackendFactory) {
        this(name, rootUrl, null, realBackendFactory);
    }

    protected AbstractVirtualBackend(String name, String rootUrl, CoreSession session, RealBackendFactory realBackendFactory) {
        super(session);
        this.backendDisplayName = name;
        this.rootUrl = new Path(rootUrl).append(this.backendDisplayName).toString();
        this.realBackendFactory = realBackendFactory;
    }

    protected void registerSimpleBackends(List<DocumentModel> docs) throws ClientException {
        ArrayList<String> paths = new ArrayList<String>();
        for (DocumentModel doc : docs) {
            paths.add(doc.getPathAsString());
        }
        ArrayList<String> heads = new ArrayList<String>();
        for (int idx = 0; idx < paths.size(); ++idx) {
            String path = (String)paths.get(idx);
            if (!this.isHead(path, paths, idx)) continue;
            heads.add(path);
        }
        for (String head : heads) {
            String headName;
            String name = headName = new Path(head).lastSegment();
            int idx = 1;
            while (this.backendMap.containsKey(name)) {
                name = headName + "-" + idx;
                ++idx;
            }
            Backend backend = this.realBackendFactory.createBackend(name, head, new Path(this.rootUrl).append(name).toString(), this.getSession());
            this.registerBackend(backend);
        }
    }

    private boolean isHead(String path, List<String> paths, int idx) {
        int level = new Path(path).segmentCount();
        for (int i = idx; i >= 0; --i) {
            String other = paths.get(i);
            if (!path.contains(other) || new Path(other).segmentCount() != level - 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getRootPath() {
        return "";
    }

    @Override
    public String getRootUrl() {
        return this.rootUrl;
    }

    @Override
    public final boolean isVirtual() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public String getBackendDisplayName() {
        return this.backendDisplayName;
    }

    @Override
    public LinkedList<String> getVirtualFolderNames() throws ClientException {
        this.initIfNeed();
        if (this.orderedBackendNames == null) {
            return new LinkedList<String>();
        }
        return this.orderedBackendNames;
    }

    protected void registerBackend(Backend backend) {
        if (this.backendMap == null) {
            this.backendMap = new ConcurrentHashMap<String, Backend>();
        }
        if (this.orderedBackendNames == null) {
            this.orderedBackendNames = new LinkedList();
        }
        this.backendMap.put(backend.getBackendDisplayName(), backend);
        this.orderedBackendNames.add(backend.getBackendDisplayName());
    }

    @Override
    public Backend getBackend(String uri) {
        Path path = new Path(uri);
        if (path.segmentCount() == 0) {
            return this;
        }
        String key = path.segment(0);
        try {
            this.initIfNeed();
        }
        catch (ClientException e) {
            log.error((Object)"Error during backend initialization", (Throwable)e);
            return null;
        }
        if (this.backendMap == null) {
            return null;
        }
        Backend backend = this.backendMap.get(key);
        if (backend == null) {
            return null;
        }
        String location = path.removeFirstSegments(1).toString();
        return backend.getBackend(location);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.backendMap != null) {
            for (Backend backend : this.backendMap.values()) {
                backend.destroy();
            }
        }
    }

    protected boolean initIfNeed() throws ClientException {
        if (this.backendMap == null || this.orderedBackendNames == null) {
            this.backendMap = new HashMap<String, Backend>();
            this.orderedBackendNames = new LinkedList();
            try {
                this.init();
                return true;
            }
            catch (Exception e) {
                log.error((Object)("Execute during virtual backend initialization. Backend name:" + this.getBackendDisplayName()), (Throwable)e);
            }
        }
        return false;
    }

    protected abstract void init() throws Exception;

    @Override
    public boolean isLocked(DocumentRef ref) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canUnlock(DocumentRef ref) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lock(DocumentRef ref) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean unlock(DocumentRef ref) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCheckoutUser(DocumentRef ref) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel resolveLocation(String location) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path parseLocation(String location) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeItem(String location) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeItem(DocumentRef ref) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameItem(DocumentModel source, String destinationName) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel moveItem(DocumentModel source, PathRef targetParentRef) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel copyItem(DocumentModel source, PathRef targetParentRef) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel createFolder(String parentPath, String name) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel createFile(String parentPath, String name, Blob content) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel createFile(String parentPath, String name) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DocumentModel> getChildren(DocumentRef ref) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRename(String source, String destination) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists(String location) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDisplayName(DocumentModel doc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasPermission(DocumentRef docRef, String permission) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel getDocument(String location) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel updateDocument(DocumentModel doc, String name, Blob content) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentModel moveItem(DocumentModel source, DocumentRef targetParentRef, String name) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVirtualPath(String path) throws ClientException {
        this.initIfNeed();
        for (String backendName : this.orderedBackendNames) {
            Backend backend = this.backendMap.get(backendName);
            String url = backend.getVirtualPath(path);
            if (!StringUtils.isNotEmpty((String)url)) continue;
            return url;
        }
        return null;
    }

    @Override
    public LinkedList<String> getOrderedBackendNames() throws ClientException {
        this.initIfNeed();
        return this.orderedBackendNames;
    }

    protected RealBackendFactory getRealBackendFactory() {
        return this.realBackendFactory;
    }
}

