/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.web.listener.ejb;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.RelationDate;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.ecm.platform.relations.jena.JenaGraph;
import org.nuxeo.ecm.platform.relations.web.NodeInfoImpl;
import org.nuxeo.ecm.platform.relations.web.StatementInfo;
import org.nuxeo.ecm.platform.relations.web.StatementInfoComparator;
import org.nuxeo.ecm.platform.relations.web.StatementInfoImpl;
import org.nuxeo.ecm.platform.relations.web.listener.RelationActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.ui.web.invalidations.DocumentContextBoundActionBean;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="relationActions")
@Scope(value=ScopeType.CONVERSATION)
@AutomaticDocumentBasedInvalidation
public class RelationActionsBean
extends DocumentContextBoundActionBean
implements RelationActions,
Serializable {
    private static final long serialVersionUID = 2336539966097558178L;
    private static final Log log = LogFactory.getLog(RelationActionsBean.class);
    protected static boolean includeStatementsInEvents = false;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected RelationManager relationManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(required=false)
    protected transient Principal currentUser;
    protected List<Statement> incomingStatements;
    protected List<StatementInfo> incomingStatementsInfo;
    protected List<Statement> outgoingStatements;
    protected List<StatementInfo> outgoingStatementsInfo;
    protected String predicateUri;
    protected String objectType;
    protected String objectLiteralValue;
    protected String objectUri;
    protected String objectDocumentUid;
    protected String objectDocumentTitle;
    protected String comment;
    protected Boolean showCreateForm = false;
    protected Boolean popupDisplayed = false;

    @Override
    public DocumentModel getDocumentModel(Node node) throws ClientException {
        if (node.isQNameResource()) {
            QNameResource resource = (QNameResource)node;
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("CoreSession", this.documentManager.getSessionId());
            Serializable o = this.relationManager.getResourceRepresentation(resource.getNamespace(), (Resource)resource, context);
            if (o instanceof DocumentModel) {
                return (DocumentModel)o;
            }
        }
        return null;
    }

    @Deprecated
    private static QNameResource getOldDocumentResource(DocumentModel document) {
        QNameResourceImpl documentResource = null;
        if (document != null) {
            documentResource = new QNameResourceImpl("http://www.nuxeo.org/document/uid/", document.getId());
        }
        return documentResource;
    }

    @Override
    public QNameResource getDocumentResource(DocumentModel document) throws ClientException {
        QNameResource documentResource = null;
        if (document != null) {
            documentResource = (QNameResource)this.relationManager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)document, null);
        }
        return documentResource;
    }

    protected List<StatementInfo> getStatementsInfo(List<Statement> statements) throws ClientException {
        if (statements == null) {
            return null;
        }
        ArrayList<StatementInfo> infoList = new ArrayList<StatementInfo>();
        for (Statement statement : statements) {
            Subject subject = statement.getSubject();
            NodeInfoImpl subjectInfo = new NodeInfoImpl((Node)subject, this.getDocumentModel((Node)subject), true);
            Resource predicate = statement.getPredicate();
            Node object = statement.getObject();
            NodeInfoImpl objectInfo = new NodeInfoImpl(object, this.getDocumentModel(object), true);
            StatementInfoImpl info = new StatementInfoImpl(statement, subjectInfo, new NodeInfoImpl((Node)predicate), objectInfo);
            infoList.add(info);
        }
        return infoList;
    }

    protected void resetEventContext() {
        Context evtCtx = Contexts.getEventContext();
        if (evtCtx != null) {
            evtCtx.remove("currentDocumentIncomingRelations");
            evtCtx.remove("currentDocumentOutgoingRelations");
        }
    }

    @Override
    @Factory(value="currentDocumentIncomingRelations", scope=ScopeType.EVENT)
    public List<StatementInfo> getIncomingStatementsInfo() throws ClientException {
        if (this.incomingStatementsInfo != null) {
            return this.incomingStatementsInfo;
        }
        DocumentModel currentDoc = this.getCurrentDocument();
        QNameResource docResource = this.getDocumentResource(currentDoc);
        if (docResource == null) {
            this.incomingStatements = Collections.emptyList();
            this.incomingStatementsInfo = Collections.emptyList();
        } else {
            Graph graph = this.relationManager.getGraphByName("default");
            this.incomingStatements = graph.getStatements(null, null, (Node)docResource);
            if (graph instanceof JenaGraph) {
                QNameResource oldDocResource = RelationActionsBean.getOldDocumentResource(currentDoc);
                this.incomingStatements.addAll(graph.getStatements(null, null, (Node)oldDocResource));
            }
            this.incomingStatementsInfo = this.getStatementsInfo(this.incomingStatements);
            Comparator<StatementInfo> comp = Collections.reverseOrder(new StatementInfoComparator());
            Collections.sort(this.incomingStatementsInfo, comp);
        }
        return this.incomingStatementsInfo;
    }

    @Override
    @Factory(value="currentDocumentOutgoingRelations", scope=ScopeType.EVENT)
    public List<StatementInfo> getOutgoingStatementsInfo() throws ClientException {
        if (this.outgoingStatementsInfo != null) {
            return this.outgoingStatementsInfo;
        }
        DocumentModel currentDoc = this.getCurrentDocument();
        QNameResource docResource = this.getDocumentResource(currentDoc);
        if (docResource == null) {
            this.outgoingStatements = Collections.emptyList();
            this.outgoingStatementsInfo = Collections.emptyList();
        } else {
            Graph graph = this.relationManager.getGraphByName("default");
            this.outgoingStatements = graph.getStatements((Node)docResource, null, null);
            if (graph instanceof JenaGraph) {
                QNameResource oldDocResource = RelationActionsBean.getOldDocumentResource(currentDoc);
                this.outgoingStatements.addAll(graph.getStatements((Node)oldDocResource, null, null));
            }
            this.outgoingStatementsInfo = this.getStatementsInfo(this.outgoingStatements);
            Comparator<StatementInfo> comp = Collections.reverseOrder(new StatementInfoComparator());
            Collections.sort(this.outgoingStatementsInfo, comp);
        }
        return this.outgoingStatementsInfo;
    }

    @Override
    public void resetStatements() {
        this.incomingStatements = null;
        this.incomingStatementsInfo = null;
        this.outgoingStatements = null;
        this.outgoingStatementsInfo = null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getObjectDocumentTitle() {
        return this.objectDocumentTitle;
    }

    @Override
    public void setObjectDocumentTitle(String objectDocumentTitle) {
        this.objectDocumentTitle = objectDocumentTitle;
    }

    @Override
    public String getObjectDocumentUid() {
        return this.objectDocumentUid;
    }

    @Override
    public void setObjectDocumentUid(String objectDocumentUid) {
        this.objectDocumentUid = objectDocumentUid;
    }

    @Override
    public String getObjectLiteralValue() {
        return this.objectLiteralValue;
    }

    @Override
    public void setObjectLiteralValue(String objectLiteralValue) {
        this.objectLiteralValue = objectLiteralValue;
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    @Override
    public String getObjectUri() {
        return this.objectUri;
    }

    @Override
    public void setObjectUri(String objectUri) {
        this.objectUri = objectUri;
    }

    @Override
    public String getPredicateUri() {
        return this.predicateUri;
    }

    @Override
    public void setPredicateUri(String predicateUri) {
        this.predicateUri = predicateUri;
    }

    protected void notifyEvent(String eventId, DocumentModel source, Map<String, Serializable> options, String comment) {
        EventProducer evtProducer = null;
        try {
            evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            log.error((Object)"Unable to get EventProducer to send event notification", (Throwable)e);
        }
        DocumentEventContext docCtx = new DocumentEventContext(this.documentManager, this.documentManager.getPrincipal(), source);
        options.put("category", (Serializable)((Object)"relationNotificationCategory"));
        options.put("comment", (Serializable)((Object)comment));
        try {
            evtProducer.fireEvent(docCtx.newEvent(eventId));
        }
        catch (ClientException e) {
            log.error((Object)"Error while trying to send notification message", (Throwable)e);
        }
    }

    @Override
    public String addStatement() throws ClientException {
        this.resetEventContext();
        DocumentModel currentDoc = this.getCurrentDocument();
        QNameResource documentResource = this.getDocumentResource(currentDoc);
        if (documentResource == null) {
            throw new ClientException("Document resource could not be retrieved");
        }
        ResourceImpl predicate = new ResourceImpl(this.predicateUri);
        LiteralImpl object = null;
        if (this.objectType.equals("literal")) {
            this.objectLiteralValue = this.objectLiteralValue.trim();
            object = new LiteralImpl(this.objectLiteralValue);
        } else if (this.objectType.equals("uri")) {
            this.objectUri = this.objectUri.trim();
            object = new ResourceImpl(this.objectUri);
        } else if (this.objectType.equals("document")) {
            this.objectDocumentUid = this.objectDocumentUid.trim();
            String repositoryName = this.navigationContext.getCurrentServerLocation().getName();
            String localName = repositoryName + "/" + this.objectDocumentUid;
            object = new QNameResourceImpl("http://www.nuxeo.org/document/uid/", localName);
        }
        StatementImpl stmt = new StatementImpl((Node)documentResource, (Node)predicate, (Node)object);
        if (!this.outgoingStatements.contains(stmt)) {
            String eventComment = null;
            if (this.comment != null) {
                this.comment = this.comment.trim();
                if (this.comment.length() > 0) {
                    stmt.addProperty(RelationConstants.COMMENT, (Node)new LiteralImpl(this.comment));
                    eventComment = this.comment;
                }
            }
            Literal now = RelationDate.getLiteralDate((Date)new Date());
            stmt.addProperty(RelationConstants.CREATION_DATE, (Node)now);
            stmt.addProperty(RelationConstants.MODIFICATION_DATE, (Node)now);
            if (this.currentUser != null) {
                stmt.addProperty(RelationConstants.AUTHOR, (Node)new LiteralImpl(this.currentUser.getName()));
            }
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            String currentLifeCycleState = currentDoc.getCurrentLifeCycleState();
            options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
            if (includeStatementsInEvents) {
                RelationActionsBean.putStatements(options, (Statement)stmt);
            }
            options.put("graph", (Serializable)((Object)"default"));
            this.notifyEvent("beforeRelationCreation", currentDoc, options, eventComment);
            Graph graph = this.relationManager.getGraphByName("default");
            graph.add((Statement)stmt);
            if (includeStatementsInEvents) {
                RelationActionsBean.putStatements(options, graph.getStatements((Statement)stmt));
            }
            this.notifyEvent("afterRelationCreation", currentDoc, options, eventComment);
            this.resetStatements();
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.relation.created"), new Object[0]);
            this.resetCreateFormValues();
        } else {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("label.relation.already.exists"), new Object[0]);
        }
        return "document_relations";
    }

    private static void putStatements(Map<String, Serializable> options, List<Statement> statements) {
        options.put("statements", (Serializable)((Object)statements));
    }

    private static void putStatements(Map<String, Serializable> options, Statement statement) {
        LinkedList<Statement> statements = new LinkedList<Statement>();
        statements.add(statement);
        options.put("statements", statements);
    }

    @Override
    public void toggleCreateForm(ActionEvent event) {
        this.showCreateForm = this.showCreateForm == false;
    }

    private void resetCreateFormValues() {
        this.predicateUri = "";
        this.objectType = "";
        this.objectLiteralValue = "";
        this.objectUri = "";
        this.objectDocumentUid = "";
        this.objectDocumentTitle = "";
        this.comment = "";
        this.showCreateForm = false;
        this.popupDisplayed = false;
    }

    @Override
    public String deleteStatement(StatementInfo stmtInfo) throws ClientException {
        this.resetEventContext();
        if (stmtInfo != null && this.outgoingStatementsInfo != null && this.outgoingStatementsInfo.contains(stmtInfo)) {
            Statement stmt = stmtInfo.getStatement();
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            DocumentModel source = this.getCurrentDocument();
            String currentLifeCycleState = source.getCurrentLifeCycleState();
            options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
            options.put("graph", (Serializable)((Object)"default"));
            if (includeStatementsInEvents) {
                RelationActionsBean.putStatements(options, stmt);
            }
            this.notifyEvent("beforeRelationRemoval", source, options, null);
            this.relationManager.getGraphByName("default").remove(stmt);
            this.notifyEvent("afterRelationRemoval", source, options, null);
            this.resetStatements();
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.relation.deleted"), new Object[0]);
        }
        return "document_relations";
    }

    @Override
    public Boolean getShowCreateForm() {
        return this.showCreateForm;
    }

    protected void resetBeanCache(DocumentModel newCurrentDocumentModel) {
        this.resetStatements();
    }

    public Boolean getPopupDisplayed() {
        return this.popupDisplayed;
    }

    public void setPopupDisplayed(Boolean popupDisplayed) {
        this.popupDisplayed = popupDisplayed;
    }
}

