/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.services.smtp;

import com.ericdaugherty.mail.server.configuration.ConfigurationManager;
import com.ericdaugherty.mail.server.errors.NotFoundException;
import com.ericdaugherty.mail.server.info.EmailAddress;
import com.ericdaugherty.mail.server.info.User;
import com.ericdaugherty.mail.server.services.general.DeliveryService;
import com.ericdaugherty.mail.server.services.smtp.SMTPMessage;
import com.ericdaugherty.mail.server.services.smtp.SMTPRemoteSender;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMTPSender
implements Runnable {
    private static Log log = LogFactory.getLog((Class)SMTPSender.class);
    private static ConfigurationManager configurationManager = ConfigurationManager.getInstance();
    private boolean running = true;

    public void run() {
        while (this.running) {
            try {
                log.debug((Object)"Checking for SMTP messages to deliver");
                File smtpDirectory = new File(configurationManager.getMailDirectory() + File.separator + "smtp");
                if (smtpDirectory.exists() && smtpDirectory.isDirectory()) {
                    File[] files = smtpDirectory.listFiles();
                    int numFiles = files.length;
                    for (int index = 0; index < numFiles; ++index) {
                        try {
                            this.deliver(SMTPMessage.load(files[index].getAbsolutePath()));
                            continue;
                        }
                        catch (Throwable throwable) {
                            log.error((Object)("An error occured attempting to deliver an SMTP Message: " + throwable), throwable);
                        }
                    }
                }
                long sleepTime = configurationManager.getDeliveryIntervealMilliseconds();
                if (configurationManager.getDeliveryIntervealMilliseconds() < 10000L) {
                    Thread.sleep(sleepTime);
                    continue;
                }
                long totalSleepTime = sleepTime;
                while (totalSleepTime > 0L && this.running) {
                    if (totalSleepTime > 10000L) {
                        totalSleepTime -= 10000L;
                        Thread.sleep(10000L);
                        continue;
                    }
                    Thread.sleep(totalSleepTime);
                    totalSleepTime = 0L;
                }
            }
            catch (InterruptedException ie) {
                log.error((Object)"Sleeping Thread was interrupted.");
            }
            catch (Throwable throwable) {
                log.error((Object)("An error occured attempting to deliver an SMTP Message: " + throwable), throwable);
            }
        }
        log.warn((Object)"SMTPSender shut down gracefully.");
    }

    public void shutdown() {
        log.warn((Object)"Attempting to shut down SMTPSender.");
        this.running = false;
    }

    private void deliver(SMTPMessage message) {
        List toAddresses = message.getToAddresses();
        int numAddress = toAddresses.size();
        Vector failedAddress = new Vector();
        EmailAddress address = null;
        if (message.getScheduledDelivery().getTime() > System.currentTimeMillis()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping delivery of message " + message.getMessageLocation().getName() + " because the scheduled delivery time is still in the future: " + message.getScheduledDelivery()));
            }
            return;
        }
        for (int index = 0; index < numAddress; ++index) {
            try {
                address = (EmailAddress)toAddresses.get(index);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to deliver message from: " + message.getFromAddress().getAddress() + " to: " + address));
                }
                DeliveryService deliveryService = DeliveryService.getDeliveryService();
                try {
                    if (deliveryService.isLocalAddress(address)) {
                        this.deliverLocalMessage(address, message);
                    } else {
                        this.deliverRemoteMessage(address, message);
                    }
                }
                catch (NotFoundException e) {
                    log.info((Object)("Delivery attempted to unknown user: " + address.getAddress()));
                    this.bounceMessage(address, message);
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Delivery complete for message " + message.getMessageLocation().getName() + " to: " + address));
                continue;
            }
            catch (Throwable throwable) {
                log.error((Object)("Delivery failed for message from: " + message.getFromAddress().getAddress() + " to: " + address + " - " + throwable), throwable);
                failedAddress.addElement(toAddresses.get(index));
            }
        }
        if (failedAddress.size() == 0) {
            if (!message.getMessageLocation().delete()) {
                log.error((Object)("Error removed SMTP message after delivery!  This message may be redelivered. " + message.getMessageLocation().getName()));
            }
        } else {
            message.setToAddresses(failedAddress);
            int deliveryAttempts = message.getDeliveryAttempts();
            if (message.getFromAddress().getUsername().equalsIgnoreCase("MAILER_DAEMON")) {
                try {
                    log.info((Object)"Delivery of message from MAILER_DAEMON failed, moving to failed folder.");
                    message.moveToFailedFolder();
                }
                catch (Exception e) {
                    log.error((Object)"Unable to move failed message to 'failed' folder.");
                }
            } else if (deliveryAttempts < configurationManager.getDeliveryAttemptThreshold()) {
                message.setDeliveryAttempts(deliveryAttempts + 1);
                if (deliveryAttempts > 10) {
                    deliveryAttempts = 10;
                }
                long offset = (long)Math.pow(2.0, deliveryAttempts);
                Date schedTime = new Date(System.currentTimeMillis() + offset * 60L * 1000L);
                message.setScheduledDelivery(schedTime);
                try {
                    message.save();
                }
                catch (Exception exception) {
                    log.error((Object)"Error updating spooled message for next delivery.  Message may be re-delivered.", (Throwable)exception);
                }
            } else {
                for (int index = 0; index < failedAddress.size(); ++index) {
                    try {
                        EmailAddress bounce_address = (EmailAddress)failedAddress.elementAt(index);
                        this.bounceMessage(bounce_address, message);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("Problem bouncing message. " + message.getMessageLocation().getName()));
                    }
                }
                if (!message.getMessageLocation().delete()) {
                    log.error((Object)("Error removed SMTP message after bounce! This message may be re-bounced. " + message.getMessageLocation().getName()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverLocalMessage(EmailAddress address, SMTPMessage message) throws NotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delivering Message to local user: " + address.getAddress()));
        }
        User user = null;
        user = configurationManager.getUser(address);
        if (user == null) {
            log.debug((Object)"User not found, checking for default delivery options");
            if (configurationManager.isDefaultUserEnabled()) {
                EmailAddress defaultAddress = configurationManager.getDefaultUser();
                user = configurationManager.getUser(defaultAddress);
                if (user == null) {
                    throw new NotFoundException();
                }
                if (log.isDebugEnabled()) {
                    log.info((Object)("Delivering message addressed to: " + address + " to default user: " + defaultAddress));
                }
            } else {
                throw new NotFoundException("User does not exist and no default delivery options found.");
            }
        }
        File messageFile = null;
        BufferedWriter out = null;
        try {
            File userDirectory = user.getUserDirectory();
            messageFile = File.createTempFile("pop", ".jmsg", userDirectory);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Delivering to: " + messageFile.getAbsolutePath()));
            }
            out = new BufferedWriter(new FileWriter(messageFile));
            List dataLines = message.getDataLines();
            int numDataLines = dataLines.size();
            out.write("X-DeliveredTo: " + address.getAddress());
            out.write("\r\n");
            for (int index = 0; index < numDataLines; ++index) {
                out.write((String)dataLines.get(index));
                out.write("\r\n");
            }
        }
        catch (IOException ioe) {
            log.error((Object)"Error performing local delivery.", (Throwable)ioe);
            if (messageFile != null) {
                messageFile.delete();
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    log.error((Object)"Error closing output Stream.", (Throwable)ioe);
                }
            }
        }
    }

    private void deliverRemoteMessage(EmailAddress address, SMTPMessage message) throws NotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delivering Message to remote user: " + address));
        }
        new SMTPRemoteSender().sendMessage(address, message);
    }

    private void bounceMessage(EmailAddress address, SMTPMessage message) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Bouncing Messsage from " + message.getFromAddress().getAddress() + " to " + address.getAddress()));
        }
        SMTPMessage bounceMessage = new SMTPMessage();
        EmailAddress fromAddress = new EmailAddress("MAILER_DAEMON", configurationManager.getLocalDomains()[0]);
        bounceMessage.setFromAddress(fromAddress);
        bounceMessage.addToAddress(message.getFromAddress());
        bounceMessage.addDataLine("From: Mail Delivery Subsystem <MAILER-DAEMON@" + configurationManager.getLocalDomains()[0] + ">");
        bounceMessage.addDataLine("To: " + message.getFromAddress().getAddress());
        bounceMessage.addDataLine("Subject: Message Delivery Error.");
        bounceMessage.addDataLine("Date: " + new Date().toString());
        bounceMessage.addDataLine("");
        bounceMessage.addDataLine("Error delivering message to: " + address.getAddress());
        bounceMessage.addDataLine("This message will not be delivered.");
        bounceMessage.addDataLine("");
        bounceMessage.addDataLine("------------------");
        List dataLines = message.getDataLines();
        int numLines = dataLines.size();
        for (int index = 0; index < numLines; ++index) {
            bounceMessage.addDataLine((String)dataLines.get(index));
        }
        bounceMessage.addDataLine("");
        try {
            bounceMessage.save();
        }
        catch (Exception e) {
            log.error((Object)"Error storing outgoing 'bounce' email message");
            throw new RuntimeException();
        }
    }
}

