/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.services.smtp;

import com.ericdaugherty.mail.server.configuration.ConfigurationManager;
import com.ericdaugherty.mail.server.configuration.DefaultSmtpServer;
import com.ericdaugherty.mail.server.errors.NotFoundException;
import com.ericdaugherty.mail.server.info.EmailAddress;
import com.ericdaugherty.mail.server.services.smtp.SMTPMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class SMTPRemoteSender {
    private static Log log = LogFactory.getLog((String)SMTPRemoteSender.class.getName());
    private static ConfigurationManager configurationManager = ConfigurationManager.getInstance();
    private PrintWriter out;
    private BufferedReader in;
    private String username = "";
    private String password = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(EmailAddress address, SMTPMessage message) throws NotFoundException, RuntimeException {
        Socket socket = this.connect(address);
        try {
            socket.setSoTimeout(60000);
        }
        catch (SocketException e) {
            throw new RuntimeException("Unable to set the Socket SO Timeout: " + e.getMessage());
        }
        try {
            try {
                this.out = new PrintWriter(socket.getOutputStream(), true);
                this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.sendIntro(address, message);
                this.sendData(message);
                this.sendClose();
            }
            catch (IOException ioe) {
                throw new RuntimeException("IOException occured while talking to remote domain: " + address.getDomain());
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    log.error((Object)("Error closing socket: " + ioe));
                }
            }
        }
    }

    private Socket connect(EmailAddress address) {
        Socket socket = null;
        String[] mxEntries = null;
        String domain = address.getDomain();
        if (configurationManager.isDefaultSmtpServerEnabled()) {
            DefaultSmtpServer[] defaultMXEntries = configurationManager.getDefaultSmtpServers();
            for (int index = 0; index < defaultMXEntries.length; ++index) {
                DefaultSmtpServer mxEntry = defaultMXEntries[index];
                try {
                    socket = new Socket(mxEntry.getHost(), mxEntry.getPort());
                    this.username = mxEntry.getUsername();
                    this.password = mxEntry.getPassword();
                    return socket;
                }
                catch (Exception e) {
                    log.debug((Object)("Connection to SMTP Server: " + mxEntry + " failed with exception: " + e));
                    continue;
                }
            }
        } else {
            try {
                this.username = null;
                this.password = null;
                Record[] records = new Lookup(domain, 15).run();
                if (records == null) {
                    records = new Record[]{};
                    log.warn((Object)("DNS Lookup for domain: " + domain + " failed."));
                }
                mxEntries = new String[records.length];
                short priority = 0;
                short nextPriority = Short.MAX_VALUE;
                int mxIndex = 0;
                while (mxIndex < mxEntries.length) {
                    for (int i = 0; i < records.length; ++i) {
                        MXRecord mx = (MXRecord)records[i];
                        if (mx.getPriority() == priority) {
                            mxEntries[mxIndex++] = mx.getTarget().toString();
                            if (mxIndex < mxEntries.length) continue;
                            break;
                        }
                        if (mx.getPriority() >= nextPriority || mx.getPriority() <= priority) continue;
                        nextPriority = mx.getPriority();
                    }
                    priority = nextPriority;
                    nextPriority = Short.MAX_VALUE;
                }
            }
            catch (TextParseException e) {
                throw new RuntimeException("TextParseException while looking up domian MX Entry: " + e.getMessage());
            }
        }
        for (int index = 0; index < mxEntries.length; ++index) {
            String mxEntry = mxEntries[index];
            int port = 25;
            int indexPort = mxEntry.indexOf(":");
            if (indexPort >= 0) {
                try {
                    port = Integer.parseInt(mxEntry.substring(indexPort + 1));
                }
                catch (Exception e) {
                    System.out.println("Invalid defaultsmtpserver port: " + mxEntry.substring(indexPort + 1) + " - " + e);
                }
                if (indexPort == 0) {
                    mxEntry = "localhost";
                    mxEntries[index] = mxEntry + mxEntries[index];
                } else {
                    mxEntry = mxEntry.substring(0, indexPort);
                }
            }
            try {
                socket = new Socket(mxEntry, port);
                return socket;
            }
            catch (Exception e) {
                log.debug((Object)("Connection to SMTP Server: " + mxEntries[index] + " failed with exception: " + e));
                continue;
            }
        }
        throw new RuntimeException("Could not connect to any SMTP server for domain: " + domain);
    }

    private void sendIntro(EmailAddress address, SMTPMessage message) {
        String lastCode = null;
        lastCode = this.read();
        if (!lastCode.startsWith("220")) {
            throw new RuntimeException("Error talking to remote Server, code=" + lastCode);
        }
        this.write("EHLO " + configurationManager.getLocalDomains()[0]);
        lastCode = this.read();
        if (!lastCode.startsWith("250")) {
            this.write("HELO " + configurationManager.getLocalDomains()[0]);
            lastCode = this.read();
            if (!lastCode.startsWith("250")) {
                throw new RuntimeException("Error talking to remote Server, code=" + lastCode);
            }
        } else if (this.username != null) {
            this.write("AUTH LOGIN");
            lastCode = this.read();
            if (!lastCode.startsWith("334")) {
                throw new RuntimeException("Error talking to remote Server, code=" + lastCode);
            }
            this.write(new String(Base64.encodeBase64((byte[])this.username.getBytes())));
            lastCode = this.read();
            if (!lastCode.startsWith("334")) {
                throw new RuntimeException("Error talking to remote Server, code=" + lastCode);
            }
            this.write(new String(Base64.encodeBase64((byte[])this.password.getBytes())));
            lastCode = this.read();
            if (!lastCode.startsWith("235")) {
                throw new RuntimeException("Error talking to remote Server, code=" + lastCode);
            }
        }
        this.write("MAIL FROM:<" + message.getFromAddress().getAddress() + ">");
        lastCode = this.read();
        if (!lastCode.startsWith("250")) {
            throw new RuntimeException("Error talking to remote Server, code=" + lastCode);
        }
        this.write("RCPT TO:<" + address.getAddress() + ">");
        lastCode = this.read();
        if (!lastCode.startsWith("250")) {
            throw new RuntimeException("Error talking to remote Server, code=" + lastCode);
        }
    }

    private void sendData(SMTPMessage message) {
        this.write("DATA");
        if (!this.read().startsWith("354")) {
            throw new RuntimeException("Error talking to remote Server");
        }
        List dataLines = message.getDataLines();
        int numDataLines = dataLines.size();
        for (int index = 0; index < numDataLines; ++index) {
            this.write((String)dataLines.get(index));
        }
        this.write(".");
        if (!this.read().startsWith("250")) {
            throw new RuntimeException("Error talking to remote Server");
        }
    }

    private void sendClose() {
        this.write("QUIT");
        if (!this.read().startsWith("221")) {
            throw new RuntimeException("Error talking to remote Server");
        }
    }

    private String read() {
        try {
            String inputText = this.in.readLine();
            inputText = inputText == null ? "" : inputText.trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read Input: " + inputText));
            }
            if (inputText.length() < 3) {
                throw new RuntimeException("SMTP Response too short. Aborting Send. Response: " + inputText);
            }
            String responseCode = inputText.substring(0, 3);
            while (inputText.length() >= 4 && inputText.substring(3, 4).equals("-")) {
                inputText = this.in.readLine().trim();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Read Input: " + inputText));
            }
            return responseCode;
        }
        catch (IOException ioe) {
            log.error((Object)"Error reading from socket.", (Throwable)ioe);
            throw new RuntimeException();
        }
    }

    private void write(String message) {
        this.out.print(message + "\r\n");
        this.out.flush();
    }
}

