/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.services.smtp;

import com.ericdaugherty.mail.server.configuration.ConfigurationManager;
import com.ericdaugherty.mail.server.errors.InvalidAddressException;
import com.ericdaugherty.mail.server.info.EmailAddress;
import com.ericdaugherty.mail.server.info.User;
import com.ericdaugherty.mail.server.services.general.ConnectionProcessor;
import com.ericdaugherty.mail.server.services.general.DeliveryService;
import com.ericdaugherty.mail.server.services.smtp.SMTPMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMTPProcessor
implements ConnectionProcessor {
    private static Log log = LogFactory.getLog((String)SMTPMessage.class.getName());
    private static ConfigurationManager configurationManager = ConfigurationManager.getInstance();
    private boolean running = true;
    private ServerSocket serverSocket;
    private Socket socket;
    private String clientIp;
    private SMTPMessage message;
    private PrintWriter out;
    private BufferedReader in;
    private static final String WELCOME_MESSAGE = "220 Welcome to EricDaugherty's Java SMTP Server.";
    private static final String MESSAGE_DISCONNECT = "221 SMTP server signing off.";
    private static final String MESSAGE_OK = "250 OK";
    private static final String MESSAGE_COMMAND_ORDER_INVALID = "503 Command not allowed here.";
    private static final String MESSAGE_USER_NOT_LOCAL = "550 User does not exist.";
    private static final String MESSAGE_USER_INVALID = "451 Address is invalid.";
    private static final String MESSAGE_SEND_DATA = "354 Start mail input; end with <CRLF>.<CRLF>";
    private static final String MESSAGE_SAVE_MESSAGE_ERROR = "500 Error handling message.";
    private static final String MESSAGE_INVALID_COMMAND = "500 Command Unrecognized: ";
    private static final String MESSAGE_MESSAGE_TOO_LARGE = "552 Message size exceeds fixed maximum message size.";
    private static final String COMMAND_HELO = "HELO";
    private static final String COMMAND_RSET = "RSET";
    private static final String COMMAND_NOOP = "NOOP";
    private static final String COMMAND_QUIT = "QUIT";
    private static final String COMMAND_MAIL_FROM = "MAIL";
    private static final String COMMAND_RCPT_TO = "RCPT";
    private static final String COMMAND_DATA = "DATA";
    public int NONE = 0;
    public int HELO = 1;
    public int QUIT = 2;
    public int MAIL_FROM = 3;
    public int RCPT_TO = 4;
    public int DATA = 5;
    public int DATA_FINISHED = 6;
    public int RSET = 7;
    public int EHLO = 8;

    public void setSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void run() {
        try {
            this.serverSocket.setSoTimeout(10000);
        }
        catch (SocketException se) {
            log.fatal((Object)"Error initializing Socket Timeout in SMTPProcessor");
        }
        while (this.running) {
            try {
                this.socket = this.serverSocket.accept();
                this.socket.setSoTimeout(10000);
                this.out = new PrintWriter(this.socket.getOutputStream(), true);
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                InetAddress remoteAddress = this.socket.getInetAddress();
                this.clientIp = remoteAddress.getHostAddress();
                if (log.isInfoEnabled()) {
                    log.info((Object)(remoteAddress.getHostName() + "(" + this.clientIp + ") socket connected via SMTP."));
                }
                this.write(WELCOME_MESSAGE);
                this.message = new SMTPMessage();
                this.handleCommands();
            }
            catch (InterruptedIOException iioe) {
            }
            catch (Throwable e) {
                log.debug((Object)"Disconnecting Exception:", e);
                log.info((Object)"Disconnecting");
                try {
                    this.write(MESSAGE_DISCONNECT);
                }
                catch (Exception e1) {
                    log.debug((Object)"Error sending disconnect message.", (Throwable)e1);
                }
                try {
                    if (this.socket == null) continue;
                    this.socket.close();
                }
                catch (IOException ioe) {
                    log.debug((Object)"Error disconnecting.", (Throwable)ioe);
                }
            }
        }
        log.warn((Object)"SMTPProcessor shut down gracefully");
    }

    public void shutdown() {
        log.warn((Object)"Shutting down SMTPProcessor.");
        this.running = false;
    }

    private void checkQuit(String command) {
        if (command.equals(COMMAND_QUIT)) {
            log.debug((Object)"User has QUIT the session.");
            throw new RuntimeException();
        }
    }

    private void handleCommands() {
        int lastCommand = this.NONE;
        while (true) {
            String inputString = this.read();
            String command = this.parseCommand(inputString);
            String argument = this.parseArgument(inputString);
            if (command.equals(COMMAND_HELO)) {
                this.write("250 Hello " + argument);
                lastCommand = this.HELO;
                continue;
            }
            if (command.equals(COMMAND_NOOP)) {
                this.write(MESSAGE_OK);
                continue;
            }
            if (command.equals(COMMAND_RSET)) {
                this.message = new SMTPMessage();
                this.write(MESSAGE_OK);
                lastCommand = this.RSET;
                continue;
            }
            if (command.equals(COMMAND_MAIL_FROM) && inputString.toUpperCase().startsWith("MAIL FROM:")) {
                if (lastCommand == this.HELO || lastCommand == this.NONE || lastCommand == this.RSET || lastCommand == this.EHLO) {
                    if (!this.handleMailFrom(inputString)) continue;
                    lastCommand = this.MAIL_FROM;
                    continue;
                }
                this.write(MESSAGE_COMMAND_ORDER_INVALID);
                continue;
            }
            if (command.equals(COMMAND_RCPT_TO) && inputString.toUpperCase().startsWith("RCPT TO:")) {
                if (lastCommand == this.MAIL_FROM || lastCommand == this.RCPT_TO) {
                    this.handleRcptTo(inputString);
                    lastCommand = this.RCPT_TO;
                    continue;
                }
                this.write(MESSAGE_COMMAND_ORDER_INVALID);
                continue;
            }
            if (command.equals(COMMAND_DATA)) {
                if (lastCommand == this.RCPT_TO && this.message.getToAddresses().size() > 0) {
                    this.handleData();
                    this.message = new SMTPMessage();
                    lastCommand = this.RSET;
                    continue;
                }
                this.write(MESSAGE_COMMAND_ORDER_INVALID);
                continue;
            }
            this.write(MESSAGE_INVALID_COMMAND + command);
        }
    }

    private boolean handleMailFrom(String inputString) {
        String fromAddress = this.parseAddress(inputString.substring(10));
        try {
            if (fromAddress == null || fromAddress.trim().equals("")) {
                this.message.setFromAddress(new EmailAddress());
                this.message.setFromAddress(new EmailAddress("unknown@example.com"));
                log.debug((Object)"MAIL FROM is empty, using unknown@example.com");
            } else {
                EmailAddress address = new EmailAddress(fromAddress);
                this.message.setFromAddress(address);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MAIL FROM: " + fromAddress));
                }
            }
            this.write(MESSAGE_OK);
            return true;
        }
        catch (InvalidAddressException iae) {
            log.debug((Object)("Unable to parse From Address: " + fromAddress));
            this.write(MESSAGE_USER_INVALID);
            return false;
        }
    }

    private void handleRcptTo(String inputString) {
        block8: {
            String toAddress = this.parseAddress(inputString.substring(8));
            try {
                EmailAddress address = new EmailAddress(toAddress);
                DeliveryService deliveryService = DeliveryService.getDeliveryService();
                if (deliveryService.acceptAddress(address, this.clientIp, this.message.getFromAddress())) {
                    User localUser = configurationManager.getUser(address);
                    if (localUser != null) {
                        EmailAddress[] addresses = localUser.getDeliveryAddresses();
                        for (int index = 0; index < addresses.length; ++index) {
                            this.message.addToAddress(addresses[index]);
                        }
                    } else {
                        this.message.addToAddress(address);
                    }
                    this.write(MESSAGE_OK);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RCTP TO: " + address.getAddress() + " accepted."));
                    }
                    break block8;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Invalid delivery address for incoming mail: " + toAddress + " from client: " + this.clientIp + " / " + this.message.getFromAddress()));
                }
                throw new InvalidAddressException();
            }
            catch (InvalidAddressException iae) {
                this.write(MESSAGE_USER_NOT_LOCAL);
                log.debug((Object)("RCTP TO: " + toAddress + " rejected."));
                return;
            }
        }
    }

    private void handleData() {
        long maxSize = configurationManager.getMaximumMessageSize() * 1024 * 1024;
        this.write(MESSAGE_SEND_DATA);
        this.message.addDataLine("X-RecievedDate: " + new Date());
        this.message.addDataLine("Received: by EricDaugherty's JES SMTP " + configurationManager.getLocalDomains()[0] + " from client: " + this.clientIp);
        try {
            String inputString = this.in.readLine();
            while (!inputString.equals(".")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read Data: " + inputString));
                }
                this.message.addDataLine(inputString);
                inputString = this.in.readLine();
                if (this.message.getSize() <= maxSize) continue;
                log.warn((Object)("Message Rejected.  Message larger than max allowed size (" + configurationManager.getMaximumMessageSize() + " MB)"));
                this.write(MESSAGE_MESSAGE_TOO_LARGE);
                throw new RuntimeException("Aborting Connection.  Message size too large.");
            }
            log.debug((Object)"Data Input Complete.");
        }
        catch (IOException ioe) {
            log.error((Object)"An error occured while retrieving the message data.", (Throwable)ioe);
            throw new RuntimeException();
        }
        try {
            this.message.save();
            this.write(MESSAGE_OK);
        }
        catch (Exception se) {
            this.write(MESSAGE_SAVE_MESSAGE_ERROR);
            throw new RuntimeException(se.getMessage());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Message " + this.message.getMessageLocation().getName() + " accepted for delivery."));
        }
    }

    private String read() {
        try {
            String inputLine = this.in.readLine().trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read Input: " + inputLine));
            }
            return inputLine;
        }
        catch (IOException ioe) {
            log.error((Object)"Error reading from socket.", (Throwable)ioe);
            throw new RuntimeException();
        }
    }

    private void write(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing: " + message));
        }
        this.out.print(message + "\r\n");
        this.out.flush();
    }

    private String parseCommand(String inputString) {
        int index = inputString.indexOf(" ");
        if (index == -1) {
            String command = inputString.toUpperCase();
            this.checkQuit(command);
            return command;
        }
        String command = inputString.substring(0, index).toUpperCase();
        this.checkQuit(command);
        return command;
    }

    private String parseArgument(String inputString) {
        int index = inputString.indexOf(" ");
        if (index == -1) {
            return "";
        }
        return inputString.substring(index + 1);
    }

    private String parseAddress(String address) {
        int index = address.indexOf("<");
        if (index != -1) {
            address = address.substring(index + 1);
        }
        if ((index = address.indexOf(">")) != -1) {
            address = address.substring(0, index);
        }
        return address;
    }
}

