/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.services.smtp;

import com.ericdaugherty.mail.server.configuration.ConfigurationManager;
import com.ericdaugherty.mail.server.errors.InvalidAddressException;
import com.ericdaugherty.mail.server.info.EmailAddress;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMTPMessage
implements Serializable {
    private static final String DELIMITER = "\r\n";
    private static final String FILE_VERSION = "1.0";
    private static Log log = LogFactory.getLog((String)SMTPMessage.class.getName());
    private static ConfigurationManager configurationManager = ConfigurationManager.getInstance();
    private Date timeReceived;
    private Date scheduledDelivery;
    private int deliveryAttempts;
    private EmailAddress fromAddress;
    private List toAddresses = new ArrayList();
    private List dataLines = new ArrayList();
    private File messageLocation = null;
    private long size = 0L;

    public SMTPMessage() {
        Date now;
        this.timeReceived = now = new Date();
        this.scheduledDelivery = now;
        this.deliveryAttempts = 0;
    }

    public Date getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(Date timeReceived) {
        this.timeReceived = timeReceived;
    }

    public Date getScheduledDelivery() {
        return this.scheduledDelivery;
    }

    public void setScheduledDelivery(Date scheduledDelivery) {
        this.scheduledDelivery = scheduledDelivery;
    }

    public int getDeliveryAttempts() {
        return this.deliveryAttempts;
    }

    public void setDeliveryAttempts(int deliveryAttempts) {
        this.deliveryAttempts = deliveryAttempts;
    }

    public EmailAddress getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(EmailAddress fromAddress) {
        this.fromAddress = fromAddress;
    }

    public List getToAddresses() {
        return this.toAddresses;
    }

    public void setToAddresses(List toAddresses) {
        this.toAddresses = toAddresses;
    }

    public void addToAddress(EmailAddress toAddress) {
        this.toAddresses.add(toAddress);
    }

    public List getDataLines() {
        return this.dataLines;
    }

    public void addDataLine(String line) {
        this.size += (long)line.length();
        this.dataLines.add(line);
    }

    public File getMessageLocation() {
        return this.messageLocation;
    }

    public void setMessageLocation(File messageLocation) {
        this.messageLocation = messageLocation;
    }

    public long getSize() {
        if (this.size == 0L) {
            Iterator i = this.dataLines.iterator();
            while (i.hasNext()) {
                this.size += (long)((String)i.next()).length();
            }
        }
        return this.size;
    }

    public void moveToFailedFolder() throws Exception {
        String newLocation;
        File messageLocation;
        File failedDir = new File(configurationManager.getMailDirectory() + File.separator + "failed");
        if (!failedDir.exists()) {
            log.info((Object)("failed directory does not exist.  Creating: " + failedDir.getAbsolutePath()));
            if (!failedDir.mkdirs()) {
                log.error((Object)("Error creating failed directory: " + failedDir.getAbsolutePath() + ".  No incoming mail will be accepted!"));
                throw new Exception("Unable to create failed Directory.");
            }
        }
        if (!(messageLocation = this.getMessageLocation()).renameTo(new File(newLocation = configurationManager.getMailDirectory() + File.separator + "failed" + File.separator + messageLocation.getName()))) {
            log.error((Object)"moveToFailedFolder failed.  Message was not renamed.");
            throw new Exception("moveToFailedFolder failed.  Message was not renamed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws Exception {
        File messageFile;
        File smtpDirectory = new File(configurationManager.getMailDirectory() + File.separator + "smtp");
        if (!smtpDirectory.exists()) {
            log.info((Object)("SMTP Mail directory does not exist.  Creating: " + smtpDirectory.getAbsolutePath()));
            if (!smtpDirectory.mkdirs()) {
                log.error((Object)("Error creating SMTP Mail directory: " + smtpDirectory.getAbsolutePath() + ".  No incoming mail will be accepted!"));
                throw new Exception("Unable to create SMTP Mail Directory.");
            }
        }
        if ((messageFile = this.getMessageLocation()) == null) {
            messageFile = File.createTempFile("smtp", ".ser", smtpDirectory);
            this.setMessageLocation(messageFile);
        }
        FileWriter writer = new FileWriter(messageFile);
        try {
            writer.write(FILE_VERSION);
            writer.write(DELIMITER);
            writer.write(this.getFromAddress().toString());
            writer.write(DELIMITER);
            writer.write(SMTPMessage.flattenAddresses(this.getToAddresses()));
            writer.write(DELIMITER);
            writer.write(String.valueOf(this.getTimeReceived().getTime()));
            writer.write(DELIMITER);
            writer.write(String.valueOf(this.getScheduledDelivery().getTime()));
            writer.write(DELIMITER);
            writer.write(String.valueOf(this.getDeliveryAttempts()));
            writer.write(DELIMITER);
            List dataLines = this.getDataLines();
            for (int index = 0; index < dataLines.size(); ++index) {
                writer.write((String)dataLines.get(index));
                writer.write(DELIMITER);
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("Unable to close spool file for SMTPMessage " + this.messageLocation.getAbsolutePath()));
            }
        }
    }

    public static SMTPMessage load(String filename) throws Exception {
        File messageFile = new File(filename);
        FileReader fileReader = new FileReader(messageFile);
        BufferedReader reader = new BufferedReader(fileReader);
        try {
            String version = reader.readLine();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading SMTP Message " + messageFile.getName() + " version " + version));
            }
            if (!FILE_VERSION.equals(version)) {
                log.error((Object)("Error loading SMTP Message.  Can not handle file version: " + version));
                throw new IOException("Invalid file version: " + version);
            }
            SMTPMessage message = new SMTPMessage();
            message.setMessageLocation(messageFile);
            message.setFromAddress(new EmailAddress(reader.readLine()));
            message.setToAddresses(SMTPMessage.inflateAddresses(reader.readLine()));
            message.setTimeReceived(new Date(Long.parseLong(reader.readLine())));
            message.setScheduledDelivery(new Date(Long.parseLong(reader.readLine())));
            message.setDeliveryAttempts(Integer.parseInt(reader.readLine()));
            String inputLine = reader.readLine();
            while (inputLine != null) {
                message.addDataLine(inputLine);
                inputLine = reader.readLine();
            }
            SMTPMessage sMTPMessage = message;
            return sMTPMessage;
        }
        catch (InvalidAddressException invalidAddressException) {
            throw new IOException("Unable to parse the address from the stored file.");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Unable to parse the data from the stored file into a number.  " + numberFormatException.toString());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static String flattenAddresses(Collection addresses) {
        StringBuffer toAddresses = new StringBuffer();
        Iterator addressIterator = addresses.iterator();
        while (addressIterator.hasNext()) {
            EmailAddress address = (EmailAddress)addressIterator.next();
            toAddresses.append(address.toString());
            toAddresses.append(",");
        }
        toAddresses.deleteCharAt(toAddresses.length() - 1);
        return toAddresses.toString();
    }

    private static List inflateAddresses(String addresses) {
        StringTokenizer addressTokenizer = new StringTokenizer(addresses, ",");
        ArrayList<EmailAddress> addressList = new ArrayList<EmailAddress>();
        try {
            while (addressTokenizer.hasMoreTokens()) {
                EmailAddress address = new EmailAddress(addressTokenizer.nextToken());
                addressList.add(address);
            }
            return addressList;
        }
        catch (InvalidAddressException invalidAddressException) {
            log.error((Object)("Unable to parse to address read from database.  Full String is: " + addresses), (Throwable)invalidAddressException);
            throw new RuntimeException("Error parsing address.  Message Delivery Failed.");
        }
    }
}

