/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.services.pop3;

import com.ericdaugherty.mail.server.configuration.ConfigurationManager;
import com.ericdaugherty.mail.server.info.EmailAddress;
import com.ericdaugherty.mail.server.info.Message;
import com.ericdaugherty.mail.server.info.User;
import com.ericdaugherty.mail.server.services.general.ConnectionProcessor;
import com.ericdaugherty.mail.server.services.general.DeliveryService;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Pop3Processor
extends Thread
implements ConnectionProcessor {
    private static Log log = LogFactory.getLog((String)Pop3Processor.class.getName());
    private static ConfigurationManager configurationManager = ConfigurationManager.getInstance();
    private boolean running = true;
    private ServerSocket serverSocket;
    private Socket socket;
    private String clientIp;
    private User user = null;
    private PrintWriter out;
    private BufferedReader in;
    private static final String WELCOME_MESSAGE = "+OK EricDaugherty's Java Pop Server Ready";
    private static final String MESSAGE_DISCONNECT = "+OK Pop server signing off.";
    private static final String MESSAGE_OK = "+OK";
    private static final String MESSAGE_INVALID_COMMAND = "-ERR Unknown command: ";
    private static final String MESSAGE_TOO_FEW_ARGUMENTS = "-ERR Too few arguments for this command.";
    private static final String MESSAGE_NEED_USER_DOMAIN = "-ERR User names must contain the username and domain.  ex: \"root@mydomain.com\"";
    private static final String MESSAGE_USER_ACCEPTED = "+OK Password required for ";
    private static final String MESSAGE_LOGIN_SUCCESSFUL = "+OK Login successful";
    private static final String MESSAGE_USER_MAILBOX_LOCKED = "-ERR User's Mailbox is locked";
    private static final String MESSAGE_INVALID_LOGIN = "-ERR Password supplied is incorrect for user: ";
    private static final String MESSAGE_NOT_A_NUMBER = "-ERR Command requires a valid number as an argument.";
    private static final String MESSAGE_NO_SUCH_MESSAGE = "-ERR No such message.";
    private static final String MESSAGE_ALREADY_DELETED = "-ERR Message already deleted.";
    private static final String COMMAND_QUIT = "QUIT";
    private static final String COMMAND_USER = "USER";
    private static final String COMMAND_PASS = "PASS";
    private static final String COMMAND_STAT = "STAT";
    private static final String COMMAND_LIST = "LIST";
    private static final String COMMAND_RETR = "RETR";
    private static final String COMMAND_DELE = "DELE";
    private static final String COMMAND_NOOP = "NOOP";
    private static final String COMMAND_RSET = "REST";
    private static final String COMMAND_TOP = "TOP";
    private static final String COMMAND_UIDL = "UIDL";

    public void setSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void run() {
        try {
            this.serverSocket.setSoTimeout(1000);
        }
        catch (SocketException se) {
            log.fatal((Object)"Error initializing Socket Timeout in Pop3Processor");
        }
        while (this.running) {
            try {
                this.socket = this.serverSocket.accept();
                this.out = new PrintWriter(this.socket.getOutputStream(), true);
                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                InetAddress remoteAddress = this.socket.getInetAddress();
                this.clientIp = remoteAddress.getHostAddress();
                if (log.isInfoEnabled()) {
                    log.info((Object)(remoteAddress.getHostName() + "(" + this.clientIp + ") socket connected via POP3."));
                }
                this.write(WELCOME_MESSAGE);
                this.user = this.authenticate();
                this.user.reset();
                this.handleCommands();
            }
            catch (InterruptedIOException iioe) {
            }
            catch (Throwable e) {
                log.debug((Object)"Disconnecting Exception:", e);
                log.info((Object)"Disconnecting");
                if (this.user != null) {
                    EmailAddress userAddress = new EmailAddress(this.user.getUsername(), this.user.getDomain());
                    DeliveryService.getDeliveryService().unlockMailbox(userAddress);
                }
                try {
                    this.write(MESSAGE_DISCONNECT);
                }
                catch (Exception e1) {
                    log.debug((Object)"Error sending disconnect message.", (Throwable)e1);
                }
                try {
                    if (this.socket == null) continue;
                    this.socket.close();
                }
                catch (IOException ioe) {
                    log.debug((Object)"Error disconnecting.", (Throwable)ioe);
                }
            }
        }
        log.warn((Object)"Pop3Processor shut down gracefully");
    }

    public void shutdown() {
        log.warn((Object)"Shutting down Pop3Processor.");
        this.running = false;
    }

    private void checkQuit(String command) {
        if (command.equals(COMMAND_QUIT)) {
            log.debug((Object)"User has QUIT the session.");
            if (this.user != null) {
                Message[] messages = this.user.getMessages();
                int numMessage = messages.length;
                Message currentMessage = null;
                for (int index = 0; index < numMessage; ++index) {
                    currentMessage = messages[index];
                    if (!currentMessage.isDeleted()) continue;
                    messages[index].getMessageLocation().delete();
                }
            }
            throw new RuntimeException();
        }
    }

    private User authenticate() {
        String argument;
        String command;
        String inputString;
        String username = "";
        String domain = "";
        String password = "";
        EmailAddress address = null;
        DeliveryService deliveryService = DeliveryService.getDeliveryService();
        boolean userAccepted = false;
        while (!userAccepted) {
            inputString = this.read();
            command = this.parseCommand(inputString);
            argument = this.parseArgument(inputString);
            if (command.equals(COMMAND_USER)) {
                if (argument.equals("")) {
                    this.write(MESSAGE_TOO_FEW_ARGUMENTS);
                    continue;
                }
                int atIndex = argument.indexOf("@");
                if (atIndex == -1) {
                    this.write(MESSAGE_NEED_USER_DOMAIN);
                    continue;
                }
                username = argument.substring(0, atIndex);
                address = new EmailAddress(username, domain = argument.substring(atIndex + 1));
                if (deliveryService.isMailboxLocked(address)) {
                    this.write(MESSAGE_USER_MAILBOX_LOCKED);
                    continue;
                }
                this.write(MESSAGE_USER_ACCEPTED + argument);
                userAccepted = true;
                continue;
            }
            this.write(MESSAGE_INVALID_COMMAND + command);
        }
        boolean passwordAccepted = false;
        while (!passwordAccepted) {
            inputString = this.read();
            command = this.parseCommand(inputString);
            argument = this.parseArgument(inputString);
            if (command.equals(COMMAND_PASS)) {
                if (argument.equals("")) {
                    this.write(MESSAGE_TOO_FEW_ARGUMENTS);
                    continue;
                }
                password = argument;
                passwordAccepted = true;
                continue;
            }
            this.write(MESSAGE_INVALID_COMMAND + command);
        }
        User user = configurationManager.getUser(address);
        if (user != null && user.isPasswordValid(password)) {
            deliveryService.ipAuthenticated(this.clientIp);
            deliveryService.lockMailbox(address);
            this.write(MESSAGE_LOGIN_SUCCESSFUL);
            if (log.isInfoEnabled()) {
                log.info((Object)("User: " + address.getAddress() + " logged in successfully."));
            }
            return user;
        }
        this.write(MESSAGE_INVALID_LOGIN + username);
        log.info((Object)("Login failed for user: " + username + "@" + domain));
        throw new RuntimeException();
    }

    private void handleCommands() {
        while (true) {
            String inputString = this.read();
            String command = this.parseCommand(inputString);
            String argument = this.parseArgument(inputString);
            if (command.equals(COMMAND_STAT)) {
                this.handleStat();
                continue;
            }
            if (command.equals(COMMAND_LIST)) {
                this.handleList(argument);
                continue;
            }
            if (command.equals(COMMAND_RETR)) {
                this.handleRetr(argument);
                continue;
            }
            if (command.equals(COMMAND_DELE)) {
                this.handleDele(argument);
                continue;
            }
            if (command.equals(COMMAND_NOOP)) {
                this.write(MESSAGE_OK);
                continue;
            }
            if (command.equals(COMMAND_RSET)) {
                this.handleRset();
                continue;
            }
            if (command.equals(COMMAND_TOP)) {
                this.handleTop(argument);
                continue;
            }
            if (command.equals(COMMAND_UIDL)) {
                this.handleUidl(argument);
                continue;
            }
            this.write(MESSAGE_INVALID_COMMAND + command);
        }
    }

    private void handleStat() {
        this.write("+OK " + this.user.getNumberOfMessage() + " " + this.user.getSizeOfAllMessage());
    }

    private void handleList(String argument) {
        if (argument.equals("")) {
            long numMessages = this.user.getNumberOfMessage();
            long sizeMessage = this.user.getSizeOfAllMessage();
            this.write("+OK " + numMessages + " messages (" + sizeMessage + " octets)");
            int index = 0;
            while ((long)index < numMessages) {
                this.write(index + 1 + " " + this.user.getMessage(index + 1).getMessageLocation().length());
                ++index;
            }
            this.write(".");
        } else {
            int messageNumber = 0;
            try {
                messageNumber = Integer.parseInt(argument);
            }
            catch (NumberFormatException nfe) {
                this.write(MESSAGE_NOT_A_NUMBER);
                return;
            }
            long numMessages = this.user.getNumberOfMessage();
            if ((long)messageNumber > numMessages || this.user.getMessage(messageNumber).isDeleted()) {
                this.write(MESSAGE_NO_SUCH_MESSAGE);
                return;
            }
            this.write("+OK " + messageNumber + " " + this.user.getMessage(messageNumber).getMessageLocation().length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRetr(String argument) {
        int messageNumber = 0;
        try {
            messageNumber = Integer.parseInt(argument);
        }
        catch (NumberFormatException nfe) {
            this.write(MESSAGE_NOT_A_NUMBER);
            return;
        }
        long numMessages = this.user.getNumberOfMessage();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Is Msg Deleted: " + this.user.getMessage(messageNumber).isDeleted()));
            log.debug((Object)("Message: " + messageNumber + " of " + numMessages));
        }
        if ((long)messageNumber > numMessages || this.user.getMessage(messageNumber).isDeleted()) {
            this.write(MESSAGE_NO_SUCH_MESSAGE);
            return;
        }
        this.write(MESSAGE_OK);
        BufferedReader fileIn = null;
        try {
            fileIn = new BufferedReader(new FileReader(this.user.getMessage(messageNumber).getMessageLocation()));
            String currentLine = fileIn.readLine();
            while (currentLine != null) {
                this.write(currentLine);
                currentLine = fileIn.readLine();
            }
            this.write(".");
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)("Requested message for user " + this.user.getFullUsername() + " could not be found on disk."), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            log.error((Object)"Error retrieving message.", (Throwable)ioe);
            this.write("-ERR Error retrieving message");
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void handleDele(String argument) {
        int messageNumber = 0;
        try {
            messageNumber = Integer.parseInt(argument);
        }
        catch (NumberFormatException nfe) {
            this.write(MESSAGE_NOT_A_NUMBER);
            return;
        }
        long numMessages = this.user.getNumberOfMessage();
        if ((long)messageNumber > numMessages) {
            this.write(MESSAGE_NO_SUCH_MESSAGE);
        } else if (this.user.getMessage(messageNumber).isDeleted()) {
            this.write(MESSAGE_ALREADY_DELETED);
        } else {
            this.user.getMessage(messageNumber).setDeleted(true);
            this.write(MESSAGE_OK);
        }
    }

    private void handleRset() {
        Message[] messages = this.user.getMessages();
        int numMessage = messages.length;
        for (int index = 0; index < numMessage; ++index) {
            messages[index].setDeleted(false);
        }
        this.write(MESSAGE_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTop(String argument) {
        log.debug((Object)"In Top");
        int messageNumber = 0;
        int numLines = 0;
        int spaceIndex = argument.indexOf(" ");
        if (spaceIndex == -1) {
            this.write(MESSAGE_TOO_FEW_ARGUMENTS);
            return;
        }
        String arg1 = argument.substring(0, spaceIndex).trim();
        String arg2 = argument.substring(spaceIndex + 1).trim();
        try {
            messageNumber = Integer.parseInt(arg1);
            numLines = Integer.parseInt(arg2);
        }
        catch (NumberFormatException nfe) {
            this.write(MESSAGE_NOT_A_NUMBER);
            return;
        }
        long numMessages = this.user.getNumberOfMessage();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Is Msg Deleted: " + this.user.getMessage(messageNumber).isDeleted()));
            log.debug((Object)("Message: " + messageNumber + " of " + numMessages));
        }
        if ((long)messageNumber > numMessages || this.user.getMessage(messageNumber).isDeleted()) {
            this.write(MESSAGE_NO_SUCH_MESSAGE);
            return;
        }
        this.write(MESSAGE_OK);
        BufferedReader fileIn = null;
        try {
            fileIn = new BufferedReader(new FileReader(this.user.getMessage(messageNumber).getMessageLocation()));
            String currentLine = fileIn.readLine();
            while (currentLine != null && !currentLine.equals("")) {
                this.write(currentLine);
                currentLine = fileIn.readLine();
            }
            this.write(currentLine);
            currentLine = fileIn.readLine();
            for (int index = 0; index < numLines && currentLine != null; ++index) {
                this.write(currentLine);
                currentLine = fileIn.readLine();
            }
            this.write(".");
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)("Requested message for user " + this.user.getFullUsername() + " could not be found on disk."), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            log.error((Object)"Error retrieving message.", (Throwable)ioe);
            this.write("-ERR Error retrieving message");
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void handleUidl(String argument) {
        if (argument == null || argument.length() == 0) {
            long numMessages = this.user.getNumberOfMessage();
            this.write(MESSAGE_OK);
            int index = 0;
            while ((long)index < numMessages) {
                Message message = this.user.getMessage(index + 1);
                if (!message.isDeleted()) {
                    this.write(index + 1 + " " + message.getUniqueId());
                }
                ++index;
            }
            this.write(".");
        } else {
            int messageNumber = 0;
            try {
                messageNumber = Integer.parseInt(argument);
            }
            catch (NumberFormatException nfe) {
                this.write(MESSAGE_NOT_A_NUMBER);
                return;
            }
            long numMessages = this.user.getNumberOfMessage();
            if ((long)messageNumber > numMessages || this.user.getMessage(messageNumber).isDeleted()) {
                this.write(MESSAGE_NO_SUCH_MESSAGE);
                return;
            }
            this.write("+OK " + messageNumber + " " + this.user.getMessage(messageNumber).getUniqueId());
        }
    }

    private String read() {
        try {
            String inputLine = this.in.readLine().trim();
            if (log.isDebugEnabled() && !inputLine.startsWith(COMMAND_PASS)) {
                log.debug((Object)("Read Input: " + inputLine));
            }
            return inputLine;
        }
        catch (IOException ioe) {
            log.error((Object)"Error reading from socket.", (Throwable)ioe);
            throw new RuntimeException();
        }
    }

    private void write(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing Output: " + message));
        }
        this.out.print(message + "\r\n");
        this.out.flush();
    }

    private String parseCommand(String inputString) {
        int index = inputString.indexOf(" ");
        if (index == -1) {
            String command = inputString.toUpperCase();
            this.checkQuit(command);
            return command;
        }
        String command = inputString.substring(0, index).toUpperCase();
        this.checkQuit(command);
        return command;
    }

    private String parseArgument(String inputString) {
        int index = inputString.indexOf(" ");
        if (index == -1) {
            return "";
        }
        return inputString.substring(index + 1).trim();
    }
}

