/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.services.general;

import com.ericdaugherty.mail.server.configuration.ConfigurationManager;
import com.ericdaugherty.mail.server.services.general.ConnectionProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceListener
implements Runnable {
    private static Log log = LogFactory.getLog((String)ServiceListener.class.getName());
    private ConnectionProcessor[] processors;
    private int port;
    private Class connectionProcessorClass;
    private int threads;
    private Thread[] threadPool = null;
    private ServerSocket serverSocket;

    public ServiceListener(int port, Class connectionProcessorClass, int threads) {
        this.port = port;
        this.connectionProcessorClass = connectionProcessorClass;
        this.threads = threads;
    }

    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting ServiceListener on port: " + this.port));
        }
        InetAddress listenAddress = ConfigurationManager.getInstance().getListenAddress();
        try {
            this.serverSocket = listenAddress == null ? new ServerSocket(this.port) : new ServerSocket(this.port, 50, listenAddress);
        }
        catch (IOException e) {
            String address = "localhost";
            if (listenAddress != null) {
                address = listenAddress.getHostAddress();
            }
            log.error((Object)("Could not create ServiceListener on address: " + address + " port: " + this.port + ".  No connections will be accepted on this port!"));
            return;
        }
        log.info((Object)("Accepting Connections on port: " + this.port));
        long threadCount = 0L;
        String threadNameBase = Thread.currentThread().getName();
        try {
            this.processors = new ConnectionProcessor[this.threads];
            this.threadPool = new Thread[this.threads];
            for (int index = 0; index < this.threads; ++index) {
                ConnectionProcessor processor;
                this.processors[index] = processor = (ConnectionProcessor)this.connectionProcessorClass.newInstance();
                processor.setSocket(this.serverSocket);
                this.threadPool[index] = new Thread((Runnable)processor, threadNameBase + ":" + ++threadCount);
                this.threadPool[index].start();
            }
        }
        catch (Exception e) {
            log.error((Object)("ServiceListener Connection failed on port: " + this.port + ".  Error: " + e));
        }
    }

    public void shutdown() {
        for (int index = 0; index < this.processors.length; ++index) {
            this.processors[index].shutdown();
            try {
                this.threadPool[index].join(10000L);
            }
            catch (InterruptedException ie) {
                log.error((Object)"Was interrupted while waiting for thread to die");
            }
            log.info((Object)"Thread gracefully terminated");
            this.threadPool[index] = null;
        }
        try {
            this.serverSocket.close();
            log.info((Object)"Server socket succcessfully closed");
        }
        catch (Exception e) {
            log.error((Object)"Failed to  close server socket", (Throwable)e);
        }
        this.serverSocket = null;
    }
}

