/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.services.general;

import com.ericdaugherty.mail.server.configuration.ConfigurationManager;
import com.ericdaugherty.mail.server.configuration.ConfigurationParameterContants;
import com.ericdaugherty.mail.server.info.EmailAddress;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeliveryService
implements ConfigurationParameterContants {
    private Log log = LogFactory.getLog(this.getClass());
    private static DeliveryService instance = null;
    private ConfigurationManager configurationManager = ConfigurationManager.getInstance();
    private Hashtable authenticatedIps = new Hashtable();
    private Hashtable lockedMailboxes = new Hashtable();

    protected DeliveryService() {
    }

    public static synchronized DeliveryService getDeliveryService() {
        if (instance == null) {
            instance = new DeliveryService();
        }
        return instance;
    }

    public boolean isLocalAddress(EmailAddress address) {
        return this.configurationManager.isLocalDomain(address.getDomain());
    }

    public boolean acceptAddress(EmailAddress address, String clientIp, EmailAddress clientFromAddress) {
        boolean isValid = false;
        isValid = this.isLocalAddress(address) || this.configurationManager.isEnablePOPBeforeSMTP() && this.isAuthenticated(clientIp) || this.isRelayApproved(clientIp, this.configurationManager.getRelayApprovedIpAddresses()) || this.isRelayApprovedForEmail(clientFromAddress, this.configurationManager.getRelayApprovedEmailAddresses());
        return isValid;
    }

    public void ipAuthenticated(String clientIp) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding authenticated IP address: " + clientIp));
        }
        this.authenticatedIps.put(clientIp, new Date());
    }

    public void lockMailbox(EmailAddress address) {
        this.lockedMailboxes.put(address.getAddress(), "");
    }

    public boolean isMailboxLocked(EmailAddress address) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Locking Mailbox: " + address.getAddress()));
        }
        return this.lockedMailboxes.containsKey(address.getAddress());
    }

    public void unlockMailbox(EmailAddress address) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Unlocking Mailbox: " + address.getAddress()));
        }
        this.lockedMailboxes.remove(address.getAddress());
    }

    private boolean isAuthenticated(String clientIp) {
        boolean retval = false;
        if (this.authenticatedIps.containsKey(clientIp)) {
            Date authenticationDate = (Date)this.authenticatedIps.get(clientIp);
            long currentTime = System.currentTimeMillis();
            long timeoutTime = authenticationDate.getTime() + this.configurationManager.getAuthenticationTimeoutMilliseconds();
            if (timeoutTime > currentTime) {
                retval = true;
            } else {
                this.authenticatedIps.remove(clientIp);
            }
        }
        return retval;
    }

    private boolean isRelayApproved(String clientIp, String[] approvedAddresses) {
        for (int index = 0; index < approvedAddresses.length; ++index) {
            String approvedAddress = approvedAddresses[index];
            if (clientIp.equals(approvedAddress)) {
                return true;
            }
            int wildcardIndex = approvedAddress.indexOf("*");
            if (wildcardIndex == -1) continue;
            boolean isMatch = true;
            StringTokenizer clientIpTokenizer = new StringTokenizer(clientIp, ".");
            StringTokenizer approvedAddressTokenizer = new StringTokenizer(approvedAddress, ".");
            while (clientIpTokenizer.hasMoreTokens()) {
                try {
                    String approvedAddressToken;
                    String clientIpToken = clientIpTokenizer.nextToken().trim();
                    if (clientIpToken.equals(approvedAddressToken = approvedAddressTokenizer.nextToken().trim()) || approvedAddressToken.equals("*")) continue;
                    isMatch = false;
                    break;
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.log.warn((Object)("Invalid ApprovedAddress found: " + approvedAddress + ".  Skipping."));
                    isMatch = false;
                    break;
                }
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    private boolean isRelayApprovedForEmail(EmailAddress clientFromEmail, String[] approvedEmailAddresses) {
        for (int index = 0; index < approvedEmailAddresses.length; ++index) {
            String approvedEmailAddress = approvedEmailAddresses[index].trim();
            if (clientFromEmail.getAddress().equalsIgnoreCase(approvedEmailAddress)) {
                return true;
            }
            if (!approvedEmailAddress.startsWith("@")) continue;
            String domain = approvedEmailAddress.substring(1);
            if (!clientFromEmail.getDomain().endsWith(domain)) continue;
            return true;
        }
        return false;
    }
}

