/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.info;

import com.ericdaugherty.mail.server.configuration.ConfigurationManager;
import com.ericdaugherty.mail.server.configuration.PasswordManager;
import com.ericdaugherty.mail.server.info.EmailAddress;
import com.ericdaugherty.mail.server.info.Message;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class User {
    private String username;
    private String domain;
    private String password;
    private EmailAddress[] forwardAddresses;
    private Message[] messages = null;
    private ConfigurationManager configurationManager = null;
    private Log log = LogFactory.getLog(this.getClass());

    public User(EmailAddress address, ConfigurationManager configurationManager) {
        this.username = address.getUsername().trim().toLowerCase();
        this.domain = address.getDomain().trim().toLowerCase();
        this.configurationManager = configurationManager;
    }

    public User(EmailAddress address) {
        this(address, ConfigurationManager.getInstance());
    }

    public boolean isPasswordValid(String plainTextPassword) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authenticating User: " + this.getFullUsername()));
        }
        boolean result = this.getPassword().equals(PasswordManager.encryptPassword(plainTextPassword));
        if (this.log.isDebugEnabled() && !result) {
            this.log.debug((Object)("Authentication Failed for User: " + this.getFullUsername()));
        }
        return result;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullUsername() {
        return User.getFullUsername(this.username, this.domain);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public EmailAddress[] getForwardAddresses() {
        return this.forwardAddresses;
    }

    public void setForwardAddresses(EmailAddress[] forwardAddresses) {
        this.forwardAddresses = forwardAddresses;
    }

    public EmailAddress[] getDeliveryAddresses() {
        if (this.forwardAddresses != null && this.forwardAddresses.length > 0) {
            return this.forwardAddresses;
        }
        return new EmailAddress[]{new EmailAddress(this.getUsername(), this.getDomain())};
    }

    public Message[] getMessages() {
        if (this.messages == null) {
            File directory = this.getUserDirectory();
            String[] fileNames = directory.list();
            int numMessage = fileNames.length;
            this.messages = new Message[numMessage];
            for (int index = 0; index < numMessage; ++index) {
                Message currentMessage = new Message();
                currentMessage.setMessageLocation(new File(directory, fileNames[index]));
                this.messages[index] = currentMessage;
            }
        }
        return this.messages;
    }

    public Message getMessage(int messageNumber) {
        return this.getMessages()[messageNumber - 1];
    }

    public long getNumberOfMessage() {
        return this.getMessages().length;
    }

    public long getSizeOfAllMessage() {
        Message[] message = this.getMessages();
        long totalSize = 0L;
        for (int index = 0; index < message.length; ++index) {
            totalSize += message[index].getMessageLocation().length();
        }
        return totalSize;
    }

    public File getUserDirectory() {
        String mailDirectory = this.configurationManager.getMailDirectory();
        File directory = new File(mailDirectory + File.separator + "users" + File.separator + this.getFullUsername());
        if (!directory.exists()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Directory for user: " + this.getFullUsername() + "does not exist, creating..."));
            }
            directory.mkdirs();
        }
        if (!directory.isDirectory()) {
            this.log.error((Object)("User Directory: " + directory.getAbsolutePath() + " for user: " + this.getFullUsername() + " does not exist."));
            throw new RuntimeException("User's Directory path: " + directory.getAbsolutePath() + " is not a directory!");
        }
        return directory;
    }

    public void reset() {
        this.messages = null;
    }

    private static String getFullUsername(String username, String domain) {
        return username + "@" + domain;
    }
}

