/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.info;

import com.ericdaugherty.mail.server.errors.InvalidAddressException;
import java.io.Serializable;

public class EmailAddress
implements Serializable {
    private String _username = "";
    private String _domain = "";
    private boolean _isEmpty = false;

    public EmailAddress() {
        this._isEmpty = true;
    }

    public EmailAddress(String fullAddress) throws InvalidAddressException {
        this.setFullAddress(fullAddress);
    }

    public EmailAddress(String username, String domain) {
        this.setUsername(username);
        this.setDomain(domain);
    }

    public String toString() {
        return this.getAddress();
    }

    public String getUsername() {
        if (this._isEmpty) {
            return "";
        }
        return this._username;
    }

    public void setUsername(String username) {
        this._isEmpty = false;
        this._username = username.trim().toLowerCase();
    }

    public String getDomain() {
        if (this._isEmpty) {
            return "";
        }
        return this._domain;
    }

    public void setDomain(String domain) {
        this._isEmpty = false;
        this._domain = domain.trim().toLowerCase();
    }

    public String getAddress() {
        return this.getFullAddress(this.getUsername(), this.getDomain());
    }

    public void setAddress(String fullAddress) throws InvalidAddressException {
        this.setFullAddress(fullAddress);
    }

    private String getFullAddress(String username, String domain) {
        if (this._isEmpty) {
            return "";
        }
        StringBuffer fullAddress = new StringBuffer(username);
        fullAddress.append("@");
        fullAddress.append(domain);
        return fullAddress.toString();
    }

    private void setFullAddress(String fullAddress) throws InvalidAddressException {
        int index = fullAddress.indexOf("@");
        if (index == -1) {
            throw new InvalidAddressException();
        }
        this.setUsername(fullAddress.substring(0, index));
        this.setDomain(fullAddress.substring(index + 1));
        this._isEmpty = false;
    }
}

