/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server.configuration;

import com.ericdaugherty.mail.server.configuration.ConfigurationParameterContants;
import com.ericdaugherty.mail.server.configuration.DefaultSmtpServer;
import com.ericdaugherty.mail.server.configuration.PasswordManager;
import com.ericdaugherty.mail.server.errors.InvalidAddressException;
import com.ericdaugherty.mail.server.info.EmailAddress;
import com.ericdaugherty.mail.server.info.User;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationManager
implements ConfigurationParameterContants {
    private static ConfigurationManager instance;
    private File generalConfigurationFile;
    private long generalConfigurationFileTimestamp;
    private File userConfigurationFile;
    private long userConfigurationFileTimestamp;
    private boolean userConfModified = false;
    private Log log = LogFactory.getLog(this.getClass());
    private String mailDirectory;
    private String[] localDomains;
    private int executeThreadCount;
    private InetAddress listenAddress;
    private int smtpPort;
    private int pop3Port;
    private long authenticationTimeoutMilliseconds;
    private boolean enablePOPBeforeSMTP;
    private String[] relayApprovedIpAddresses;
    private String[] relayApprovedEmailAddresses;
    private boolean defaultSmtpServerEnabled;
    private DefaultSmtpServer[] defaultSmtpServers;
    private boolean defaultUserEnabled;
    private EmailAddress defaultUser;
    private long deliveryIntervalSeconds;
    private int deliveryAttemptThreshold;
    private int maximumMessageSize;
    private Map users;
    private static final String LF = "\r\n";
    private static final String USER_PROPERTIES_HEADER = "# Java Email Server (JES) User Configuration\r\n#\r\n# All users are defined in this file.  To add a user, follow\r\n# the following pattern:\r\n# user.<username@domain>=<plain text password>\r\n#\r\n# The plain text password will be converted to a hash when the file\r\n# is first loaded by the server.\r\n#\r\n# Additional configuration such as forward addresses can be specified as:\r\n# userprop.<username@domain>.forwardAddresses=<Comma list of forward addresses>\r\n#\r\n# When a message is received for a local user, the user's address will be replaced\r\n# with the addresses in the forwardAddresses property.  If you also wish to have\r\n# a copy delivered to the local user, you may add the user's local address to\r\n# the forwardAddresses property\r\n";

    private ConfigurationManager(File generalConfigurationFile, File userConfigurationFile) {
        this.generalConfigurationFile = generalConfigurationFile;
        this.userConfigurationFile = userConfigurationFile;
    }

    public static synchronized ConfigurationManager initialize(String configurationDirectory) throws RuntimeException {
        String generalConfigFilename = "mail.conf";
        String userConfigFilename = "user.conf";
        if (instance != null) {
            throw new RuntimeException("Configurationmanager:initialize() called more than once!");
        }
        File generalConfigFile = new File(configurationDirectory, generalConfigFilename);
        if (!generalConfigFile.exists() || !generalConfigFile.isFile()) {
            throw new RuntimeException("Invalid mail.conf ConfigurationFile! " + generalConfigFile.getAbsolutePath());
        }
        File userConfigFile = new File(configurationDirectory, userConfigFilename);
        if (!userConfigFile.exists() || !userConfigFile.isFile()) {
            throw new RuntimeException("Invalid user.conf ConfigurationFile! " + userConfigFile.getAbsolutePath());
        }
        instance = new ConfigurationManager(generalConfigFile, userConfigFile);
        instance.setMailDirectory(configurationDirectory);
        instance.loadProperties();
        instance.new ConfigurationFileWatcher().start();
        return instance;
    }

    public static synchronized ConfigurationManager getInstance() {
        if (instance == null) {
            throw new RuntimeException("ConfigurationManager can not be accessed before it is initialized!");
        }
        return instance;
    }

    public void loadProperties() {
        this.loadGeneralProperties();
        this.loadUserProperties();
    }

    public String getMailDirectory() {
        return this.mailDirectory;
    }

    public int getDeliveryAttemptThreshold() {
        return this.deliveryAttemptThreshold;
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public void setMailDirectory(String mailDirectory) {
        this.mailDirectory = mailDirectory;
    }

    public String[] getLocalDomains() {
        return this.localDomains;
    }

    public boolean isLocalDomain(String domain) {
        domain = domain.toLowerCase();
        if (this.localDomains != null && this.localDomains.length > 0) {
            int numDomains = this.localDomains.length;
            for (int index = 0; index < numDomains; ++index) {
                if (!this.localDomains[index].equals(domain)) continue;
                return true;
            }
        }
        return false;
    }

    public void setLocalDomains(String[] localDomains) {
        this.localDomains = localDomains;
    }

    public int getExecuteThreadCount() {
        return this.executeThreadCount;
    }

    public void setExecuteThreadCount(int executeThreadCount) {
        this.executeThreadCount = executeThreadCount;
    }

    public InetAddress getListenAddress() {
        return this.listenAddress;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public int getPop3Port() {
        return this.pop3Port;
    }

    public void setPop3Port(int pop3Port) {
        this.pop3Port = pop3Port;
    }

    public User getUser(EmailAddress address) {
        User user = (User)this.users.get(address.getAddress());
        if (this.log.isInfoEnabled() && user == null) {
            this.log.info((Object)("Tried to load non-existent user: " + address.getAddress()));
        }
        return user;
    }

    public long getAuthenticationTimeoutMilliseconds() {
        return this.authenticationTimeoutMilliseconds;
    }

    public void setAuthenticationTimeoutMinutes(long minutes) {
        this.authenticationTimeoutMilliseconds = minutes * 60L * 1000L;
    }

    public boolean isEnablePOPBeforeSMTP() {
        return this.enablePOPBeforeSMTP;
    }

    public void setEnablePOPBeforeSMTP(boolean enablePOPBeforeSMTP) {
        this.enablePOPBeforeSMTP = enablePOPBeforeSMTP;
    }

    public String[] getRelayApprovedIpAddresses() {
        return this.relayApprovedIpAddresses;
    }

    public void setRelayApprovedIpAddresses(String[] relayApprovedIpAddresses) {
        this.relayApprovedIpAddresses = relayApprovedIpAddresses;
    }

    public String[] getRelayApprovedEmailAddresses() {
        return this.relayApprovedEmailAddresses;
    }

    public void setRelayApprovedEmailAddresses(String[] relayApprovedEmailAddresses) {
        this.relayApprovedEmailAddresses = relayApprovedEmailAddresses;
    }

    public boolean isDefaultSmtpServerEnabled() {
        return this.defaultSmtpServerEnabled;
    }

    public void setDefaultSmtpServerEnabled(boolean defaultSmtpServerEnabled) {
        this.defaultSmtpServerEnabled = defaultSmtpServerEnabled;
    }

    public DefaultSmtpServer[] getDefaultSmtpServers() {
        return this.defaultSmtpServers;
    }

    public void setDefaultSmtpServers(DefaultSmtpServer[] defaultSmtpServers) {
        this.defaultSmtpServers = defaultSmtpServers;
    }

    public boolean isDefaultUserEnabled() {
        return this.defaultUserEnabled;
    }

    public void setDefaultUserEnabled(boolean defaultUserEnabled) {
        this.defaultUserEnabled = defaultUserEnabled;
    }

    public EmailAddress getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(EmailAddress defaultUser) {
        this.defaultUser = defaultUser;
    }

    public long getDeliveryIntervalSeconds() {
        return this.deliveryIntervalSeconds;
    }

    public long getDeliveryIntervealMilliseconds() {
        return this.deliveryIntervalSeconds * 1000L;
    }

    public void setDeliveryIntervalSeconds(long deliveryIntervalSeconds) {
        this.deliveryIntervalSeconds = deliveryIntervalSeconds;
    }

    private void loadGeneralProperties() {
        String defaultUserString;
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(this.generalConfigurationFile);
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error Loading Properties File!  Unable to continue Operation.");
        }
        String domains = properties.getProperty("domains", "");
        this.localDomains = ConfigurationManager.tokenize(domains.trim().toLowerCase());
        this.log.info((Object)("Loaded " + this.localDomains.length + " local domains."));
        if (domains.length() == 0) {
            throw new RuntimeException("No Local Domains defined!  Can not run without local domains defined.");
        }
        String threadsString = properties.getProperty("threads", "5");
        try {
            this.executeThreadCount = Integer.parseInt(threadsString);
        }
        catch (NumberFormatException nfe) {
            this.log.warn((Object)"Invalid value for property: threads.  Using default value of 5.");
            this.executeThreadCount = 5;
        }
        String listenAddressString = properties.getProperty("listen.address", "");
        listenAddressString.trim();
        if (listenAddressString.length() > 0) {
            try {
                this.listenAddress = InetAddress.getByName(listenAddressString);
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException("Invalid value for property: listen.address.  Server will listen on all addresses.  " + unknownHostException);
            }
        } else {
            this.listenAddress = null;
        }
        String smtpPortString = properties.getProperty("smtpport");
        String pop3PortString = properties.getProperty("pop3port");
        this.smtpPort = this.parsePort(smtpPortString, 25);
        this.pop3Port = this.parsePort(pop3PortString, 110);
        this.enablePOPBeforeSMTP = Boolean.valueOf(properties.getProperty("relay.popbeforesmtp", "false"));
        String timoutString = properties.getProperty("relay.popbeforesmtp.timeout", "10");
        try {
            this.setAuthenticationTimeoutMinutes(Long.parseLong(timoutString));
        }
        catch (NumberFormatException nfe) {
            this.log.warn((Object)"Invalid value for property: relay.popbeforesmtp.timeout. Defaulting to 10.");
            this.setAuthenticationTimeoutMinutes(10L);
        }
        String ipAddresses = properties.getProperty("relay.ipaddresses", "");
        this.setRelayApprovedIpAddresses(ConfigurationManager.tokenize(ipAddresses));
        String emailAddresses = properties.getProperty("relay.emailaddresses", "");
        this.setRelayApprovedEmailAddresses(ConfigurationManager.tokenize(emailAddresses));
        String smtpServers = properties.getProperty("defaultsmtpservers", "").trim();
        if (smtpServers.length() > 0) {
            this.defaultSmtpServerEnabled = true;
            String[] raw = ConfigurationManager.tokenize(smtpServers);
            this.defaultSmtpServers = new DefaultSmtpServer[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                String credentials;
                String server;
                int slash = raw[i].indexOf(47);
                if (slash == -1) {
                    server = raw[i];
                    credentials = null;
                } else {
                    server = raw[i].substring(0, slash);
                    credentials = raw[i].substring(slash + 1);
                }
                this.defaultSmtpServers[i] = new DefaultSmtpServer();
                this.defaultSmtpServers[i].setPort(25);
                int colon = server.indexOf(58);
                if (colon == -1) {
                    this.defaultSmtpServers[i].setHost(server);
                } else {
                    this.defaultSmtpServers[i].setHost(server.substring(0, colon));
                    this.defaultSmtpServers[i].setPort(Integer.parseInt(server.substring(colon + 1)));
                }
                if (this.defaultSmtpServers[i].getHost().length() == 0) {
                    this.defaultSmtpServers[i].setHost("localhost");
                }
                if (credentials == null) continue;
                colon = credentials.indexOf(58);
                this.defaultSmtpServers[i].setUsername(credentials.substring(0, colon));
                this.defaultSmtpServers[i].setPassword(credentials.substring(colon + 1));
            }
        } else {
            this.defaultSmtpServerEnabled = false;
            this.defaultSmtpServers = new DefaultSmtpServer[0];
        }
        if ((defaultUserString = properties.getProperty("defaultuser", "").trim()).length() > 0) {
            try {
                this.defaultUser = new EmailAddress(defaultUserString);
                this.defaultUserEnabled = true;
            }
            catch (InvalidAddressException e) {
                throw new RuntimeException("Invalid address for default user: " + defaultUserString);
            }
        } else {
            this.defaultUser = null;
            this.defaultUserEnabled = false;
        }
        String deliveryIntervalString = properties.getProperty("smtpdelivery.interval", "10");
        try {
            this.setDeliveryIntervalSeconds(Long.parseLong(deliveryIntervalString));
        }
        catch (NumberFormatException nfe) {
            this.setDeliveryIntervalSeconds(10L);
        }
        try {
            this.deliveryAttemptThreshold = Integer.parseInt(properties.getProperty("smtpdelivery.threshold", "10"));
        }
        catch (NumberFormatException numberFormatException) {
            this.log.warn((Object)"Invalid value for property: smtpdelivery.threshold. Defaulting to 10.");
            this.deliveryAttemptThreshold = 10;
        }
        try {
            this.maximumMessageSize = Integer.parseInt(properties.getProperty("smtp.messagesize", "5"));
        }
        catch (NumberFormatException numberFormatException) {
            this.log.warn((Object)"Invalid value for property: smtp.messagesize. Defaulting to 5.");
            this.deliveryAttemptThreshold = 5;
        }
        this.generalConfigurationFileTimestamp = this.generalConfigurationFile.lastModified();
    }

    private void loadUserProperties() {
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(this.userConfigurationFile);
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error Loading Properties File!  Unable to continue Operation.");
        }
        this.userConfModified = false;
        HashMap<String, User> users = new HashMap<String, User>();
        Enumeration<Object> propertyKeys = properties.keys();
        while (propertyKeys.hasMoreElements()) {
            String key = (String)propertyKeys.nextElement();
            if (!key.startsWith("user.")) continue;
            String fullUsername = key.substring("user.".length());
            String correctedUsername = fullUsername.toLowerCase();
            try {
                users.put(correctedUsername, this.loadUser(fullUsername, properties));
            }
            catch (InvalidAddressException e) {
                this.log.warn((Object)("Skipping user: " + fullUsername + ".  Address is invalid."));
            }
        }
        this.users = users;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Loaded " + users.size() + " users from user.conf"));
        }
        if (this.userConfModified) {
            try {
                FileOutputStream out = new FileOutputStream(this.userConfigurationFile);
                properties.store(out, USER_PROPERTIES_HEADER);
                this.log.info((Object)"Changes to user.conf persisted to disk.");
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to store changes to user.conf!  Plain text passwords were not hashed!");
            }
        }
        this.userConfigurationFileTimestamp = this.userConfigurationFile.lastModified();
    }

    public static String[] tokenize(String value) {
        if (value == null || value.trim().equals("")) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(value, ",");
        Vector<String> tokenVector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            tokenVector.addElement(stringTokenizer.nextToken().trim());
        }
        String[] values = new String[tokenVector.size()];
        return tokenVector.toArray(values);
    }

    private int parsePort(String stringValue, int defaultValue) {
        int value = defaultValue;
        if (stringValue != null && stringValue.length() > 0) {
            try {
                value = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                this.log.warn((Object)("Error parsing port string: " + stringValue + " using default value: " + defaultValue));
            }
        }
        return value;
    }

    private User loadUser(String fullAddress, Properties properties) throws InvalidAddressException {
        EmailAddress address = new EmailAddress(fullAddress);
        User user = new User(address);
        String password = properties.getProperty("user." + fullAddress);
        if (password.length() != 60) {
            password = PasswordManager.encryptPassword(password);
            properties.setProperty("user." + fullAddress, password);
            if (password == null) {
                this.log.error((Object)("Error encrypting plaintext password from user.conf for user " + fullAddress));
                throw new RuntimeException("Error encrypting password for user: " + fullAddress);
            }
            this.userConfModified = true;
        }
        user.setPassword(password);
        String forwardAddressesString = properties.getProperty("userprop." + fullAddress + ".forwardAddresses");
        String[] forwardAddresses = new String[]{};
        if (forwardAddressesString != null && forwardAddressesString.trim().length() >= 0) {
            forwardAddresses = ConfigurationManager.tokenize(forwardAddressesString);
        }
        ArrayList<EmailAddress> addressList = new ArrayList<EmailAddress>(forwardAddresses.length);
        for (int index = 0; index < forwardAddresses.length; ++index) {
            try {
                addressList.add(new EmailAddress(forwardAddresses[index]));
                continue;
            }
            catch (InvalidAddressException e) {
                this.log.warn((Object)("Forward address: " + forwardAddresses[index] + " for user " + user.getFullUsername() + " is invalid and will be ignored."));
            }
        }
        EmailAddress[] emailAddresses = new EmailAddress[addressList.size()];
        emailAddresses = addressList.toArray(emailAddresses);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(emailAddresses.length + " forward addresses load for user: " + user.getFullUsername()));
        }
        user.setForwardAddresses(emailAddresses);
        return user;
    }

    class ConfigurationFileWatcher
    extends Thread {
        public ConfigurationFileWatcher() {
            super("User Config Watchdog");
            this.setDaemon(true);
        }

        public void run() {
            long sleepTime = 10000L;
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(sleepTime);
                        if (ConfigurationManager.this.generalConfigurationFile.lastModified() > ConfigurationManager.this.generalConfigurationFileTimestamp) {
                            ConfigurationManager.this.log.info((Object)"General Configuration File Changed, reloading...");
                            ConfigurationManager.this.loadGeneralProperties();
                        }
                        if (ConfigurationManager.this.userConfigurationFile.lastModified() <= ConfigurationManager.this.userConfigurationFileTimestamp) continue;
                        ConfigurationManager.this.log.info((Object)"User Configuration File Changed, reloading...");
                        ConfigurationManager.this.loadUserProperties();
                    }
                }
                catch (Throwable throwable) {
                    ConfigurationManager.this.log.error((Object)("Error in ConfigurationWatcher thread.  Thread will continue to execute. " + throwable), throwable);
                    continue;
                }
                break;
            }
        }
    }
}

