/*
 * Decompiled with CFR 0.152.
 */
package com.ericdaugherty.mail.server;

import com.ericdaugherty.mail.server.ShutdownService;
import com.ericdaugherty.mail.server.configuration.ConfigurationManager;
import com.ericdaugherty.mail.server.services.general.ServiceListener;
import com.ericdaugherty.mail.server.services.pop3.Pop3Processor;
import com.ericdaugherty.mail.server.services.smtp.SMTPProcessor;
import com.ericdaugherty.mail.server.services.smtp.SMTPSender;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mail {
    private static ServiceListener popListener;
    private static ServiceListener smtpListener;
    private static SMTPSender smtpSender;
    private static ShutdownService shutdownService;
    private static Thread smtpSenderThread;
    private static Thread shutdownServiceThread;
    private static Log log;

    public static void shutdown(String[] args) {
        log.debug((Object)"NT Service requested application shutdown.");
        Mail.shutdown();
    }

    public static void shutdown() {
        log.warn((Object)"Shutting down Mail Server.  Server will shut down in 60 seconds.");
        popListener.shutdown();
        smtpListener.shutdown();
        smtpSender.shutdown();
        try {
            smtpSenderThread.join(10000L);
        }
        catch (InterruptedException ie) {
            log.error((Object)"Was interrupted while waiting for thread to die");
        }
        log.info((Object)"Thread gracefully terminated");
        smtpSenderThread = null;
    }

    public static void main(String[] args) {
        try {
            String directory = Mail.getConfigurationDirectory(args);
            Mail.initializeLogging(directory);
            ConfigurationManager configurationManager = ConfigurationManager.initialize(directory);
            int executeThreads = configurationManager.getExecuteThreadCount();
            int port = configurationManager.getPop3Port();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting POP3 Service on port: " + port));
            }
            popListener = new ServiceListener(port, Pop3Processor.class, executeThreads);
            new Thread((Runnable)popListener, "POP3").start();
            port = configurationManager.getSmtpPort();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting SMTP Service on port: " + port));
            }
            smtpListener = new ServiceListener(port, SMTPProcessor.class, executeThreads);
            new Thread((Runnable)smtpListener, "SMTP").start();
            smtpSender = new SMTPSender();
            smtpSenderThread = new Thread((Runnable)smtpSender, "SMTPSender");
            smtpSenderThread.start();
            shutdownService = new ShutdownService();
            shutdownServiceThread = new Thread(shutdownService);
            Runtime.getRuntime().addShutdownHook(shutdownServiceThread);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("The application failed to initialize.");
            System.err.println(runtimeException.getMessage());
            runtimeException.printStackTrace();
            System.exit(0);
        }
    }

    private static String getConfigurationDirectory(String[] args) {
        String directory = ".";
        if (args.length == 1) {
            directory = args[0];
        } else {
            File directoryFile = new File(directory);
            if (directoryFile.exists()) {
                System.out.println("Configuration Directory not specified.  Using \"" + directoryFile.getAbsolutePath() + "\"");
            } else {
                System.out.println("Usage:  java com.ericdaugherty.mail.server.Mail <configuration directory>");
                throw new RuntimeException("Unable to load the configuration file.");
            }
        }
        return directory;
    }

    private static void initializeLogging(String configurationDirectory) {
        File logConfigurationFile = new File(configurationDirectory, "log.conf");
        if (!logConfigurationFile.exists()) {
            Mail.initializeDefaultLogging(logConfigurationFile);
        } else {
            boolean enableLog4j = false;
            try {
                Class<?> propertyConfigurator = Class.forName("org.apache.log4j.PropertyConfigurator");
                Method configureMethod = propertyConfigurator.getMethod("configureAndWatch", String.class);
                configureMethod.invoke(null, logConfigurationFile.getAbsolutePath());
                log = LogFactory.getLog((Class)Mail.class);
                log.info((Object)"Logger using log4j.");
                enableLog4j = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("Found log4j Class but method configureAndWatch(String) is not available.");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Found log4j Class but method configureAndWatch(String) caused an IllegalAccessException.");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable targetException = invocationTargetException.getTargetException();
                System.err.println("Error occured while configuring log4j: " + targetException);
            }
            if (!enableLog4j) {
                Mail.initializeDefaultLogging(logConfigurationFile);
            }
        }
    }

    private static void initializeDefaultLogging(File logConfigurationFile) {
        String DEFAULT_THRESHOLD;
        String threshold = DEFAULT_THRESHOLD = "info";
        if (logConfigurationFile.exists()) {
            try {
                Properties logConfigurationProperties = new Properties();
                logConfigurationProperties.load(new FileInputStream(logConfigurationFile));
                threshold = logConfigurationProperties.getProperty("defaultthreshold", DEFAULT_THRESHOLD);
                threshold = threshold.trim();
                if (!(threshold.equals("debug") || threshold.equals("info") || threshold.equals("warn") || threshold.equals("error") || threshold.equals("fatal"))) {
                    System.err.println("Invalid value for property defaultthreshold: " + threshold);
                    threshold = DEFAULT_THRESHOLD;
                }
            }
            catch (IOException ioException) {
                System.err.println("Error loading properties from: " + logConfigurationFile.getAbsolutePath() + ". " + ioException);
                threshold = DEFAULT_THRESHOLD;
            }
        }
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", threshold);
        log = LogFactory.getLog((Class)Mail.class);
        log.warn((Object)"log.conf file not found.  Using default log configuration.");
    }

    static {
        log = null;
    }
}

