/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.tests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.runtime.api.Framework;

public class Helper {
    public static final String DELETE_TRANSITION = "delete";
    public static final String FILE1_CONTENT = "Noodles with rice";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in, String charset) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[256];
        try {
            int n;
            while ((n = in.read(buf)) != -1) {
                os.write(buf, 0, n);
            }
        }
        finally {
            in.close();
        }
        return os.toString(charset);
    }

    public static GregorianCalendar getCalendar(int year, int month, int day, int hours, int minutes, int seconds) {
        TimeZone tz = TimeZone.getTimeZone("GMT-02:00");
        return Helper.getCalendar(year, month, day, hours, minutes, seconds, tz);
    }

    public static GregorianCalendar getCalendar(int year, int month, int day, int hours, int minutes, int seconds, TimeZone tz) {
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance(tz);
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, 0);
        return cal;
    }

    public static Map<String, String> makeNuxeoRepository(CoreSession session) throws Exception {
        HashMap<String, String> info = new HashMap<String, String>();
        DocumentModelImpl folder1 = new DocumentModelImpl("/", "testfolder1", "Folder");
        folder1.setPropertyValue("dc:title", (Serializable)((Object)"testfolder1_Title"));
        folder1 = session.createDocument((DocumentModel)folder1);
        DocumentModelImpl file1 = new DocumentModelImpl("/testfolder1", "testfile1", "File");
        file1.setPropertyValue("dc:title", (Serializable)((Object)"testfile1_Title"));
        file1.setPropertyValue("dc:description", (Serializable)((Object)"testfile1_description"));
        String content = FILE1_CONTENT;
        String filename = "testfile.txt";
        ByteArrayBlob blob1 = new ByteArrayBlob(content.getBytes("UTF-8"), "text/plain");
        blob1.setFilename(filename);
        file1.setPropertyValue("content", (Serializable)blob1);
        GregorianCalendar cal1 = Helper.getCalendar(2007, 3, 1, 12, 0, 0);
        file1.setPropertyValue("dc:created", (Serializable)cal1);
        file1.setPropertyValue("dc:modified", (Serializable)cal1);
        file1.setPropertyValue("dc:creator", (Serializable)((Object)"michael"));
        file1.setPropertyValue("dc:lastContributor", (Serializable)((Object)"john"));
        file1.setPropertyValue("dc:coverage", (Serializable)((Object)"foo/bar"));
        file1.setPropertyValue("dc:subjects", (Serializable)new String[]{"foo", "gee/moo"});
        file1 = session.createDocument((DocumentModel)file1);
        ACLImpl acl = new ACLImpl();
        acl.add((Object)new ACE("bob", "Browse", true));
        ACPImpl acp = new ACPImpl();
        acp.addACL((ACL)acl);
        file1.setACP((ACP)acp, true);
        DocumentModelImpl file2 = new DocumentModelImpl("/testfolder1", "testfile2", "File");
        file2.setPropertyValue("dc:title", (Serializable)((Object)"testfile2_Title"));
        file2.setPropertyValue("dc:description", (Serializable)((Object)"something"));
        GregorianCalendar cal2 = Helper.getCalendar(2007, 4, 1, 12, 0, 0);
        file2.setPropertyValue("dc:created", (Serializable)cal2);
        file2.setPropertyValue("dc:creator", (Serializable)((Object)"pete"));
        file2.setPropertyValue("dc:contributors", (Serializable)new String[]{"pete", "bob"});
        file2.setPropertyValue("dc:lastContributor", (Serializable)((Object)"bob"));
        file2.setPropertyValue("dc:coverage", (Serializable)((Object)"football"));
        file2 = session.createDocument((DocumentModel)file2);
        acl = new ACLImpl();
        acl.add((Object)new ACE("bob", "Browse", true));
        acp = new ACPImpl();
        acp.addACL((ACL)acl);
        file2.setACP((ACP)acp, true);
        DocumentModelImpl file3 = new DocumentModelImpl("/testfolder1", "testfile3", "Note");
        file3.setPropertyValue("note", (Serializable)((Object)"this is a note"));
        file3.setPropertyValue("dc:title", (Serializable)((Object)"testfile3_Title"));
        file3.setPropertyValue("dc:description", (Serializable)((Object)"testfile3_desc1 testfile3_desc2,  testfile3_desc3"));
        file3.setPropertyValue("dc:contributors", (Serializable)new String[]{"bob", "john"});
        file3.setPropertyValue("dc:lastContributor", (Serializable)((Object)"john"));
        file3 = session.createDocument((DocumentModel)file3);
        DocumentModelImpl folder2 = new DocumentModelImpl("/", "testfolder2", "Folder");
        folder2.setPropertyValue("dc:title", (Serializable)((Object)"testfolder2_Title"));
        folder2 = session.createDocument((DocumentModel)folder2);
        DocumentModelImpl folder3 = new DocumentModelImpl("/testfolder2", "testfolder3", "Folder");
        folder3.setPropertyValue("dc:title", (Serializable)((Object)"testfolder3_Title"));
        folder3 = session.createDocument((DocumentModel)folder3);
        DocumentModelImpl folder4 = new DocumentModelImpl("/testfolder2", "testfolder4", "Folder");
        folder4.setPropertyValue("dc:title", (Serializable)((Object)"testfolder4_Title"));
        folder4 = session.createDocument((DocumentModel)folder4);
        DocumentModelImpl file4 = new DocumentModelImpl("/testfolder2/testfolder3", "testfile4", "File");
        file4.setPropertyValue("dc:title", (Serializable)((Object)"testfile4_Title"));
        file4.setPropertyValue("dc:description", (Serializable)((Object)"something"));
        file4 = session.createDocument((DocumentModel)file4);
        DocumentModelImpl file5 = new DocumentModelImpl("/testfolder1", "testfile5", "File");
        file5.setPropertyValue("dc:title", (Serializable)((Object)"title5"));
        file5 = session.createDocument((DocumentModel)file5);
        file5.followTransition(DELETE_TRANSITION);
        session.saveDocument((DocumentModel)file5);
        info.put("file5id", file5.getId());
        session.save();
        ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
        DatabaseHelper.DATABASE.sleepForFulltext();
        return info;
    }

    public static String createUserWorkspace(CoreSession repo, String username) throws ClientException {
        DocumentModelImpl container = new DocumentModelImpl("/", "UserWorkspaceRoot", "UserWorkspaceRoot");
        container = repo.createDocument((DocumentModel)container);
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{new ACE("Everyone", "Everything", false)});
        acp.addACL((ACL)acl);
        container.setACP((ACP)acp, true);
        DocumentModelImpl ws = new DocumentModelImpl(container.getPathAsString(), username, "Workspace");
        ws = repo.createDocument((DocumentModel)ws);
        ACPImpl acp2 = new ACPImpl();
        ACLImpl acl2 = new ACLImpl();
        acl2.setACEs(new ACE[]{new ACE(username, "Everything", true)});
        acp2.addACL((ACL)acl2);
        ws.setACP((ACP)acp2, true);
        repo.save();
        return ws.getPathAsString();
    }
}

