/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.login;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;

public class GroupImpl
implements Group {
    private Vector<Principal> groupMembers = new Vector(50, 100);
    private String group;

    public GroupImpl(String groupName) {
        this.group = groupName;
    }

    public boolean addMember(Principal user) {
        if (this.groupMembers.contains(user)) {
            return false;
        }
        if (this.group.equals(((Object)user).toString())) {
            throw new IllegalArgumentException();
        }
        this.groupMembers.addElement(user);
        return true;
    }

    public boolean removeMember(Principal user) {
        return this.groupMembers.removeElement(user);
    }

    public Enumeration<? extends Principal> members() {
        return this.groupMembers.elements();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        return this.group.equals(other.toString());
    }

    public boolean equals(Group other) {
        return this.equals((Object)other);
    }

    public String toString() {
        return this.group;
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    public boolean isMember(Principal member) {
        if (this.groupMembers.contains(member)) {
            return true;
        }
        Vector<Group> alreadySeen = new Vector<Group>(10);
        return this.isMemberRecurse(member, alreadySeen);
    }

    public String getName() {
        return this.group;
    }

    boolean isMemberRecurse(Principal member, Vector<Group> alreadySeen) {
        Enumeration<? extends Principal> e = this.members();
        while (e.hasMoreElements()) {
            GroupImpl g;
            boolean mem = false;
            Principal p = e.nextElement();
            if (((Object)p).equals(member)) {
                return true;
            }
            if (p instanceof GroupImpl) {
                g = (GroupImpl)((Object)p);
                alreadySeen.addElement(this);
                if (!alreadySeen.contains(g)) {
                    mem = g.isMemberRecurse(member, alreadySeen);
                }
            } else if (p instanceof Group && !alreadySeen.contains(g = (Group)p)) {
                mem = g.isMember(member);
            }
            if (!mem) continue;
            return mem;
        }
        return false;
    }
}

