/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.automation.client.model.Blob;

public class StringBlob
extends Blob {
    private static final long serialVersionUID = -7170366401800302228L;
    protected final String content;
    protected String charset;

    public StringBlob(String content) {
        this.content = content;
    }

    public StringBlob(String fileName, String content) {
        super(fileName, null);
        this.content = content;
    }

    public StringBlob(String fileName, String content, String mimeType) {
        super(fileName, mimeType);
        this.content = content;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public InputStream getStream() throws IOException {
        byte[] bytes = this.charset == null ? this.content.getBytes() : this.content.getBytes(this.charset);
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public String toString() {
        return this.content;
    }
}

