/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.HasFile;

public class FileBlob
extends Blob
implements HasFile {
    private static final long serialVersionUID = 1L;
    protected final File file;

    public FileBlob(File file) {
        super(file.getName(), FileBlob.getMimeTypeFromExtension(file.getPath()));
        this.file = file;
    }

    @Override
    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public static String getMimeTypeFromExtension(String path) {
        return "application/octet-stream";
    }
}

