/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.models;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.theme.models.ModelType;

public abstract class AbstractModel
implements Model {
    private final List<Model> items = new ArrayList<Model>();

    @Override
    public String getModelTypeName() {
        ModelType modelType = this.getModelType();
        if (modelType == null) {
            return null;
        }
        return modelType.getTypeName();
    }

    @Override
    public ModelType getModelType() {
        String className = this.getClass().getCanonicalName();
        return Manager.getThemeManager().getModelByClassname(className);
    }

    @Override
    public Model addItem(Model model) throws ModelException {
        ModelType modelType = this.getModelType();
        if (modelType == null) {
            throw new ModelException("Model type not found: " + this.getModelTypeName());
        }
        if (!this.getModelType().getAllowedTypes().contains(model.getModelTypeName())) {
            throw new ModelException("Model type: " + model.getModelTypeName() + " not allowed in: " + this.getModelTypeName());
        }
        this.items.add(model);
        return model;
    }

    @Override
    public Model insertItem(int index, Model model) throws ModelException {
        if (!this.getModelType().getAllowedTypes().contains(model.getModelTypeName())) {
            throw new ModelException("Model type: " + model.getModelTypeName() + " not allowed in: " + this.getModelTypeName());
        }
        this.items.add(index, model);
        return model;
    }

    @Override
    public List<Model> getItems() {
        return this.items;
    }

    @Override
    public boolean hasItems() {
        return !this.items.isEmpty();
    }
}

