/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.update.PackageType;

public class DownloadingPackageSource
implements PackageSource {
    protected static final Log log = LogFactory.getLog(DownloadingPackageSource.class);

    @Override
    public String getName() {
        return "Downloading";
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        List<DownloadingPackage> pkgs = cdm.listDownloadingPackages();
        for (DownloadingPackage pkg : pkgs) {
            result.add(pkg);
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        List<DownloadablePackage> all = this.listPackages();
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : all) {
            if (!pkg.getType().equals((Object)type)) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    public void flushCache() {
    }
}

