/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.EventTransactionListener;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.AsyncEventExecutor;
import org.nuxeo.ecm.core.event.impl.EventBundleImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventListenerList;
import org.nuxeo.ecm.core.event.impl.ShallowEvent;
import org.nuxeo.ecm.core.event.jms.AsyncProcessorConfig;
import org.nuxeo.ecm.core.event.tx.BulkExecutor;
import org.nuxeo.ecm.core.event.tx.PostCommitSynchronousRunner;
import org.nuxeo.runtime.api.Framework;

public class EventServiceImpl
implements EventService,
EventServiceAdmin {
    public static final VMID VMID = new VMID();
    private static final Log log = LogFactory.getLog(EventServiceImpl.class);
    protected static final ThreadLocal<CompositeEventBundle> compositeBundle = new ThreadLocal<CompositeEventBundle>(){

        @Override
        protected CompositeEventBundle initialValue() {
            return new CompositeEventBundle();
        }
    };
    protected final ListenerList txListeners = new ListenerList();
    protected final EventListenerList listenerDescriptors = new EventListenerList();
    protected final AsyncEventExecutor asyncExec = AsyncEventExecutor.create();
    protected boolean blockAsyncProcessing = false;
    protected boolean blockSyncPostCommitProcessing = false;
    protected boolean bulkModeEnabled = false;

    public void shutdown() {
        this.shutdown(0L);
    }

    public void shutdown(long timeout) {
        this.waitForAsyncCompletion(timeout);
        this.asyncExec.shutdown(timeout);
    }

    @Deprecated
    public int getActiveAsyncTaskCount() {
        return this.asyncExec.getUnfinishedCount();
    }

    @Override
    public void waitForAsyncCompletion() {
        this.waitForAsyncCompletion(0L);
    }

    @Override
    public void waitForAsyncCompletion(long timeout) {
        long t0 = System.currentTimeMillis();
        while (this.asyncExec.getUnfinishedCount() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (timeout <= 0L || System.currentTimeMillis() <= t0 + timeout) continue;
            break;
        }
    }

    @Override
    public void addEventListener(EventListenerDescriptor listener) {
        try {
            this.listenerDescriptors.add(listener);
            log.debug((Object)("Registered event listener: " + listener.getName()));
        }
        catch (Exception e) {
            log.error((Object)("Failed to register event listener: " + listener.getName()), (Throwable)e);
        }
    }

    @Override
    public void removeEventListener(EventListenerDescriptor listener) {
        try {
            this.listenerDescriptors.removeDescriptor(listener);
            log.debug((Object)("Unregistered event listener: " + listener.getName()));
        }
        catch (Exception e) {
            log.error((Object)("Failed to unregister event listener: " + listener.getName()), (Throwable)e);
        }
    }

    protected EventStats getEventStats() {
        try {
            return (EventStats)Framework.getService(EventStats.class);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to lookup event stats service", (Throwable)e);
            return null;
        }
    }

    @Override
    public void fireEvent(String name, EventContext context) throws ClientException {
        this.fireEvent(new EventImpl(name, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(Event event) throws ClientException {
        if (!event.isInline()) {
            Object b;
            ShallowEvent shallowEvent = ShallowEvent.create(event);
            if (event.isImmediate()) {
                b = new EventBundleImpl();
                ((EventBundleImpl)b).push(shallowEvent);
                this.fireEventBundle((EventBundle)b);
            } else {
                b = compositeBundle.get();
                ((CompositeEventBundle)b).push(shallowEvent);
                if (!((CompositeEventBundle)b).transacted && event.isCommitEvent()) {
                    this.handleTxCommited();
                }
            }
        }
        String ename = event.getName();
        EventStats stats = this.getEventStats();
        for (EventListenerDescriptor desc : this.listenerDescriptors.getEnabledInlineListenersDescriptors()) {
            if (!desc.acceptEvent(ename)) continue;
            try {
                long t0 = System.currentTimeMillis();
                desc.asEventListener().handleEvent(event);
                if (stats == null) continue;
                stats.logSyncExec(desc, System.currentTimeMillis() - t0);
            }
            catch (Throwable t) {
                log.error((Object)"Error during sync listener execution", t);
            }
            finally {
                if (event.isMarkedForRollBack()) {
                    throw new RuntimeException("Exception during sync listener execution, rollingback");
                }
                if (!event.isCanceled()) continue;
                return;
            }
        }
    }

    @Override
    public void fireEventBundle(EventBundle event) throws ClientException {
        boolean comesFromJMS = false;
        if (event instanceof ReconnectedEventBundle && ((ReconnectedEventBundle)event).comesFromJMS()) {
            comesFromJMS = true;
        }
        if (this.bulkModeEnabled) {
            List<Object> listeners = new ArrayList();
            if (!this.blockSyncPostCommitProcessing) {
                listeners = this.listenerDescriptors.getEnabledSyncPostCommitListenersDescriptors();
            }
            if (!this.blockAsyncProcessing) {
                listeners.addAll(this.listenerDescriptors.getEnabledAsyncPostCommitListenersDescriptors());
            }
            if (!listeners.isEmpty()) {
                BulkExecutor bulkExecutor = new BulkExecutor(listeners, event);
                bulkExecutor.run();
            }
            return;
        }
        if (this.blockSyncPostCommitProcessing) {
            log.debug((Object)"Dropping PostCommit handler execution");
        } else if (comesFromJMS) {
            log.debug((Object)"Deactivating sync post-commit listener since we are called from JMS");
        } else {
            List<EventListenerDescriptor> syncPCDescs = this.listenerDescriptors.getEnabledSyncPostCommitListenersDescriptors();
            if (syncPCDescs != null && !syncPCDescs.isEmpty()) {
                PostCommitSynchronousRunner syncRunner = new PostCommitSynchronousRunner(syncPCDescs, event);
                syncRunner.run();
            }
        }
        if (this.blockAsyncProcessing) {
            log.debug((Object)"Dopping bundle");
            return;
        }
        if (AsyncProcessorConfig.forceJMSUsage() && !comesFromJMS) {
            log.debug((Object)"Skipping async exec, this will be triggered via JMS");
        } else {
            this.asyncExec.run(this.listenerDescriptors.getEnabledAsyncPostCommitListenersDescriptors(), event);
        }
    }

    @Override
    public void fireEventBundleSync(EventBundle event) throws ClientException {
        for (EventListenerDescriptor desc : this.listenerDescriptors.getEnabledSyncPostCommitListenersDescriptors()) {
            desc.asPostCommitListener().handleEvent(event);
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getEnabledAsyncPostCommitListenersDescriptors()) {
            desc.asPostCommitListener().handleEvent(event);
        }
    }

    @Override
    public List<EventListener> getEventListeners() {
        return this.listenerDescriptors.getInLineListeners();
    }

    @Override
    public List<PostCommitEventListener> getPostCommitEventListeners() {
        ArrayList<PostCommitEventListener> result = new ArrayList<PostCommitEventListener>();
        result.addAll(this.listenerDescriptors.getSyncPostCommitListeners());
        result.addAll(this.listenerDescriptors.getAsyncPostCommitListeners());
        return result;
    }

    @Override
    public void transactionStarted() {
        this.handleTxStarted();
    }

    @Override
    public void transactionCommitted() throws ClientException {
        this.handleTxCommited();
    }

    @Override
    public void transactionRolledback() {
        this.handleTxRollbacked();
    }

    @Override
    public boolean isTransactionStarted() {
        return EventServiceImpl.compositeBundle.get().transacted;
    }

    public EventListenerList getEventListenerList() {
        return this.listenerDescriptors;
    }

    @Override
    public EventListenerList getListenerList() {
        return this.listenerDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListenerEnabledFlag(String listenerName, boolean enabled) {
        if (!this.listenerDescriptors.getListenerNames().contains(listenerName)) {
            return;
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getAsyncPostCommitListenersDescriptors()) {
            if (!desc.getName().equals(listenerName)) continue;
            desc.setEnabled(enabled);
            EventServiceImpl eventServiceImpl = this;
            synchronized (eventServiceImpl) {
                this.listenerDescriptors.recomputeEnabledListeners();
            }
            return;
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getSyncPostCommitListenersDescriptors()) {
            if (!desc.getName().equals(listenerName)) continue;
            desc.setEnabled(enabled);
            EventServiceImpl eventServiceImpl = this;
            synchronized (eventServiceImpl) {
                this.listenerDescriptors.recomputeEnabledListeners();
            }
            return;
        }
        for (EventListenerDescriptor desc : this.listenerDescriptors.getInlineListenersDescriptors()) {
            if (!desc.getName().equals(listenerName)) continue;
            desc.setEnabled(enabled);
            EventServiceImpl eventServiceImpl = this;
            synchronized (eventServiceImpl) {
                this.listenerDescriptors.recomputeEnabledListeners();
            }
            return;
        }
    }

    @Override
    public int getActiveThreadsCount() {
        return this.asyncExec.getActiveCount();
    }

    @Override
    public int getEventsInQueueCount() {
        return this.asyncExec.getUnfinishedCount();
    }

    @Override
    public boolean isBlockAsyncHandlers() {
        return this.blockAsyncProcessing;
    }

    @Override
    public boolean isBlockSyncPostCommitHandlers() {
        return this.blockSyncPostCommitProcessing;
    }

    @Override
    public void setBlockAsyncHandlers(boolean blockAsyncHandlers) {
        this.blockAsyncProcessing = blockAsyncHandlers;
    }

    @Override
    public void setBlockSyncPostCommitHandlers(boolean blockSyncPostComitHandlers) {
        this.blockSyncPostCommitProcessing = blockSyncPostComitHandlers;
    }

    @Override
    public boolean isBulkModeEnabled() {
        return this.bulkModeEnabled;
    }

    @Override
    public void setBulkModeEnabled(boolean bulkModeEnabled) {
        this.bulkModeEnabled = bulkModeEnabled;
    }

    @Override
    public void addTransactionListener(EventTransactionListener listener) {
        this.txListeners.add((Object)listener);
    }

    @Override
    public void removeTransactionListener(EventTransactionListener listener) {
        this.txListeners.remove((Object)listener);
    }

    protected void handleTxStarted() {
        EventServiceImpl.compositeBundle.get().transacted = true;
        for (Object listener : this.txListeners.getListeners()) {
            ((EventTransactionListener)listener).transactionStarted();
        }
    }

    protected void handleTxRollbacked() {
        compositeBundle.remove();
        for (Object listener : this.txListeners.getListeners()) {
            ((EventTransactionListener)listener).transactionRollbacked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTxCommited() {
        CompositeEventBundle b = compositeBundle.get();
        try {
            for (EventBundle bundle : b.byRepository.values()) {
                try {
                    this.fireEventBundle(bundle);
                }
                catch (ClientException e) {
                    log.error((Object)("Error while processing " + bundle), (Throwable)e);
                }
            }
            for (Object listener : this.txListeners.getListeners()) {
                ((EventTransactionListener)listener).transactionCommitted();
            }
        }
        finally {
            compositeBundle.remove();
        }
    }

    private static class CompositeEventBundle {
        static final long serialVersionUID = 1L;
        boolean transacted;
        final Map<String, EventBundle> byRepository = new HashMap<String, EventBundle>();

        private CompositeEventBundle() {
        }

        void push(Event event) {
            String repositoryName = event.getContext().getRepositoryName();
            if (!this.byRepository.containsKey(repositoryName)) {
                this.byRepository.put(repositoryName, new EventBundleImpl());
            }
            this.byRepository.get(repositoryName).push(event);
        }
    }
}

