/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.crypto.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jsecurity.codec.Base64;
import org.jsecurity.codec.CodecException;
import org.jsecurity.codec.CodecSupport;
import org.jsecurity.codec.Hex;
import org.jsecurity.crypto.hash.Hash;

public abstract class AbstractHash
extends CodecSupport
implements Hash {
    private byte[] bytes = null;
    private String hexEncoded = null;
    private String base64Encoded = null;

    public AbstractHash() {
    }

    public AbstractHash(Object source) throws CodecException {
        this(source, null, 1);
    }

    public AbstractHash(Object source, Object salt) throws CodecException {
        this(source, salt, 1);
    }

    public AbstractHash(Object source, Object salt, int hashIterations) throws CodecException {
        byte[] sourceBytes = this.toBytes(source);
        byte[] saltBytes = null;
        if (salt != null) {
            saltBytes = this.toBytes(salt);
        }
        byte[] hashedBytes = this.hash(sourceBytes, saltBytes, hashIterations);
        this.setBytes(hashedBytes);
    }

    protected abstract String getAlgorithmName();

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] alreadyHashedBytes) {
        this.bytes = alreadyHashedBytes;
        this.hexEncoded = null;
        this.base64Encoded = null;
    }

    protected MessageDigest getDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "No native '" + algorithmName + "' MessageDigest instance available on the current JVM.";
            throw new IllegalStateException(msg, e);
        }
    }

    protected byte[] hash(byte[] bytes) {
        return this.hash(bytes, null, 1);
    }

    protected byte[] hash(byte[] bytes, byte[] salt) {
        return this.hash(bytes, salt, 1);
    }

    protected byte[] hash(byte[] bytes, byte[] salt, int hashIterations) {
        MessageDigest md = this.getDigest(this.getAlgorithmName());
        if (salt != null) {
            md.reset();
            md.update(salt);
        }
        byte[] hashed = md.digest(bytes);
        int iterations = hashIterations - 1;
        for (int i = 0; i < iterations; ++i) {
            md.reset();
            hashed = md.digest(hashed);
        }
        return hashed;
    }

    public String toHex() {
        if (this.hexEncoded == null) {
            this.hexEncoded = Hex.encodeToString(this.getBytes());
        }
        return this.hexEncoded;
    }

    public String toBase64() {
        if (this.base64Encoded == null) {
            this.base64Encoded = Base64.encodeToString(this.getBytes());
        }
        return this.base64Encoded;
    }

    public String toString() {
        return this.toHex();
    }

    public boolean equals(Object o) {
        if (o instanceof Hash) {
            Hash other = (Hash)o;
            return Arrays.equals(this.getBytes(), other.getBytes());
        }
        return false;
    }

    public int hashCode() {
        return this.toHex().hashCode();
    }
}

