/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.filter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingFilter
implements Filter {
    private static final Log log = LogFactory.getLog(LoggingFilter.class);
    private static int REQUEST_NO = 0;
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("EEE MMM dd hh:mm:ss a z yyyy", Locale.US);
    private String logDir;
    private boolean prettyPrint = true;
    private boolean logHeaders = true;
    private int indent = -1;

    public void init(FilterConfig cfg) throws ServletException {
        String val;
        this.logDir = cfg.getInitParameter("LogDir");
        if (null == this.logDir) {
            this.logDir = System.getProperty("java.io.tmpdir");
        }
        if (null == this.logDir) {
            this.logDir = "." + File.separator;
        }
        if (!this.logDir.endsWith(File.separator)) {
            this.logDir = this.logDir + File.separator;
        }
        if (null != (val = cfg.getInitParameter("Indent"))) {
            this.indent = Integer.parseInt(val);
        }
        if (this.indent < 0) {
            this.indent = 4;
        }
        if (null != (val = cfg.getInitParameter("PrettyPrint"))) {
            this.prettyPrint = Boolean.parseBoolean(val);
        }
        if (null != (val = cfg.getInitParameter("LogHeaders"))) {
            this.logHeaders = Boolean.parseBoolean(val);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        log.debug((Object)"Logging filter doFilter");
        if (resp instanceof HttpServletResponse && req instanceof HttpServletRequest) {
            LoggingRequestWrapper logReq = new LoggingRequestWrapper((HttpServletRequest)req);
            LoggingResponseWrapper logResponse = new LoggingResponseWrapper((HttpServletResponse)resp);
            int reqNo = LoggingFilter.getNextRequestNumber();
            String requestFileName = this.getRequestFileName(reqNo);
            String cType = logReq.getContentType();
            String xmlRequest = logReq.getPayload();
            StringBuffer sb = new StringBuffer();
            if (this.logHeaders) {
                this.logHeaders(logReq, sb);
            }
            if (xmlRequest != null && xmlRequest.length() > 0) {
                if (this.prettyPrint) {
                    xmlRequest = LoggingFilter.prettyPrint(xmlRequest, this.indent);
                }
            } else {
                xmlRequest = "";
            }
            xmlRequest = sb.toString() + xmlRequest;
            log.debug((Object)("Found request: " + requestFileName + ": " + xmlRequest));
            this.writeTextToFile(requestFileName, xmlRequest);
            chain.doFilter((ServletRequest)logReq, (ServletResponse)logResponse);
            sb = new StringBuffer();
            cType = logResponse.getContentType();
            String responseFileName = this.getResponseFileName(reqNo);
            if (this.logHeaders) {
                this.logHeaders(logResponse, req.getProtocol(), sb);
            }
            if (cType != null && cType.contains("xml")) {
                String xmlResponse = this.prettyPrint ? LoggingFilter.prettyPrint(logResponse.getPayload(), this.indent) : logResponse.getPayload();
                xmlResponse = sb.toString() + xmlResponse;
                log.debug((Object)("Found response: " + responseFileName + ": " + xmlResponse));
                this.writeTextToFile(responseFileName, xmlResponse);
            } else if (cType != null && cType.contains("html")) {
                String xmlResponse = sb.toString() + logResponse.getPayload();
                log.debug((Object)("Found response: " + responseFileName + ": " + xmlResponse));
                this.writeTextToFile(responseFileName, xmlResponse);
            } else {
                this.writeTextToFile(responseFileName, "Unknown reponse content format: " + cType);
            }
        } else {
            chain.doFilter(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTextToFile(String filename, String content) {
        PrintWriter pw = null;
        FileWriter fw = null;
        try {
            fw = new FileWriter(filename);
            pw = new PrintWriter(fw);
            Scanner scanner = new Scanner(content);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                pw.println(line);
            }
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String prettyPrint(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void logHeaders(LoggingRequestWrapper req, StringBuffer sb) {
        sb.append(req.getMethod());
        sb.append(" ");
        sb.append(req.getRequestURI());
        sb.append(" ");
        sb.append(req.getProtocol());
        sb.append("\n");
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement().toString();
            headerName = headerName.substring(0, 1).toUpperCase() + headerName.substring(1);
            sb.append(headerName + ": ");
            sb.append(req.getHeader(headerName));
            sb.append("\n");
        }
        sb.append("\n");
    }

    private void logHeaders(LoggingResponseWrapper resp, String protocol, StringBuffer sb) {
        sb.append(protocol);
        sb.append(" ");
        sb.append(String.valueOf(resp.getStatus()));
        sb.append("\n");
        Map<String, String> headers = resp.getHeaders();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            sb.append(header.getKey());
            sb.append(": ");
            sb.append(header.getValue());
            sb.append("\n");
        }
        sb.append("\n");
    }

    private String getRequestFileName(int no) {
        return this.logDir + String.format("%05d-request.log", no);
    }

    private String getResponseFileName(int no) {
        return this.logDir + String.format("%05d-response.log", no);
    }

    private static synchronized int getNextRequestNumber() {
        return REQUEST_NO++;
    }

    private class LoggingOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream baous = new ByteArrayOutputStream();
        private ServletOutputStream os;

        public LoggingOutputStream(ServletOutputStream os) {
            this.os = os;
        }

        public String getPayload() {
            return new String(this.baous.toString());
        }

        public void write(byte[] b, int off, int len) {
            try {
                this.baous.write(b, off, len);
                this.os.write(b, off, len);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void write(byte[] b) {
            try {
                this.baous.write(b);
                this.os.write(b);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void write(int ch) throws IOException {
            this.baous.write(ch);
            this.os.write(ch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoggingResponseWrapper
    extends HttpServletResponseWrapper {
        private LoggingOutputStream os;
        private int statusCode;
        private Map<String, String> headers;
        String encoding;

        public LoggingResponseWrapper(HttpServletResponse response) throws IOException {
            super(response);
            this.headers = new HashMap<String, String>();
            this.os = new LoggingOutputStream(response.getOutputStream());
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.os;
        }

        public String getPayload() {
            return this.os.getPayload();
        }

        public void addCookie(Cookie cookie) {
            super.addCookie(cookie);
            String value = this.headers.containsKey("Cookie") ? this.headers.get("Cookie") + "; " + cookie.toString() : cookie.toString();
            this.headers.put("Cookie", value);
        }

        public void setContentType(String type) {
            super.setContentType(type);
            if (this.headers.containsKey("Content-Type")) {
                String cType = this.headers.get("Content-Type");
                int pos = cType.indexOf(";charset=");
                if (pos < 0 && this.encoding != null) {
                    type = cType + ";charset=" + this.encoding;
                } else if (pos >= 0) {
                    this.encoding = null;
                }
            }
            this.headers.put("Content-Type", type);
        }

        public void setCharacterEncoding(String charset) {
            super.setCharacterEncoding(charset);
            this.encoding = charset;
            if (this.headers.containsKey("Content-Type")) {
                String cType = this.headers.get("Content-Type");
                int pos = cType.indexOf(";charset=");
                cType = pos >= 0 ? cType.substring(0, pos) + ";charset=" + this.encoding : cType + ";charset=" + this.encoding;
                this.headers.put("Content-Type", cType);
            }
        }

        public void setContentLength(int len) {
            super.setContentLength(len);
            this.headers.put("Content-Length", String.valueOf(len));
        }

        private String getDateString(long date) {
            return FORMAT.format(new Date(date));
        }

        public void setDateHeader(String name, long date) {
            super.setDateHeader(name, date);
            this.headers.put(name, String.valueOf(this.getDateString(date)));
        }

        public void addDateHeader(String name, long date) {
            super.addDateHeader(name, date);
            if (this.headers.containsKey(name)) {
                this.headers.put(name, this.headers.get(name) + "; " + this.getDateString(date));
            } else {
                this.headers.put(name, String.valueOf(this.getDateString(date)));
            }
        }

        public void setHeader(String name, String value) {
            super.setHeader(name, value);
            this.headers.put(name, String.valueOf(value));
        }

        public void addHeader(String name, String value) {
            super.addHeader(name, value);
            if (this.headers.containsKey(name)) {
                this.headers.put(name, this.headers.get(name) + "; " + value);
            } else {
                this.headers.put(name, String.valueOf(value));
            }
        }

        public void setIntHeader(String name, int value) {
            super.setIntHeader(name, value);
            this.headers.put(name, String.valueOf(value));
        }

        public void addIntHeader(String name, int value) {
            super.addIntHeader(name, value);
            if (this.headers.containsKey(name)) {
                this.headers.put(name, this.headers.get(name) + "; " + String.valueOf(value));
            } else {
                this.headers.put(name, String.valueOf(value));
            }
        }

        public void sendError(int sc) throws IOException {
            this.statusCode = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.statusCode = sc;
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.statusCode = 302;
            super.sendRedirect(location);
        }

        public void setStatus(int sc) {
            this.statusCode = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.statusCode;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }

    private class LoggingInputStream
    extends ServletInputStream {
        private ByteArrayOutputStream baous = new ByteArrayOutputStream();
        private ServletInputStream is;

        public LoggingInputStream(ServletInputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            int ch = this.is.read();
            if (ch != -1) {
                this.baous.write(ch);
            }
            return ch;
        }

        public int read(byte[] b) throws IOException {
            int ch = this.is.read(b);
            if (ch != -1) {
                this.baous.write(b);
            }
            return ch;
        }

        public int read(byte[] b, int o, int l) throws IOException {
            int ch = this.is.read(b, o, l);
            if (ch != -1) {
                this.baous.write(b);
            }
            return ch;
        }

        public int readLine(byte[] b, int o, int l) throws IOException {
            int ch = this.is.readLine(b, o, l);
            if (ch != -1) {
                this.baous.write(b, o, l);
            }
            return ch;
        }

        public String getPayload() {
            return this.baous.toString();
        }
    }

    private class LoggingRequestWrapper
    extends HttpServletRequestWrapper {
        private LoggingInputStream is;

        public LoggingRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            this.is = new LoggingInputStream(request.getInputStream());
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.is;
        }

        public String getPayload() {
            return this.is.getPayload();
        }
    }
}

