/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.text.XTextDocument;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.artofsolving.jodconverter.AbstractConversionTask;
import org.artofsolving.jodconverter.OfficeDocumentUtils;
import org.artofsolving.jodconverter.document.DocumentFamily;
import org.artofsolving.jodconverter.document.DocumentFormat;
import org.artofsolving.jodconverter.office.OfficeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardConversionTask
extends AbstractConversionTask {
    public static final String UPDATE_DOCUMENT_INDEX = "updateDocumentIndex";
    private final DocumentFormat outputFormat;
    private Map<String, ?> defaultLoadProperties;
    private DocumentFormat inputFormat;
    protected final Map<String, Serializable> params;

    public StandardConversionTask(File inputFile, File outputFile, DocumentFormat outputFormat, Map<String, Serializable> params) {
        super(inputFile, outputFile);
        this.outputFormat = outputFormat;
        if (params == null) {
            params = new HashMap<String, Serializable>();
        }
        this.params = params;
    }

    public StandardConversionTask(File inputFile, File outputFile, DocumentFormat outputFormat) {
        this(inputFile, outputFile, outputFormat, null);
    }

    public void setDefaultLoadProperties(Map<String, ?> defaultLoadProperties) {
        this.defaultLoadProperties = defaultLoadProperties;
    }

    public void setInputFormat(DocumentFormat inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Override
    protected Map<String, ?> getLoadProperties(File inputFile) {
        HashMap loadProperties = new HashMap();
        if (this.defaultLoadProperties != null) {
            loadProperties.putAll(this.defaultLoadProperties);
        }
        if (this.inputFormat != null && this.inputFormat.getLoadProperties() != null) {
            loadProperties.putAll(this.inputFormat.getLoadProperties());
        }
        return loadProperties;
    }

    @Override
    protected Map<String, ?> getStoreProperties(File outputFile, XComponent document) {
        DocumentFamily family = OfficeDocumentUtils.getDocumentFamily(document);
        return this.outputFormat.getStoreProperties(family);
    }

    @Override
    protected void handleDocumentLoaded(XComponent document) {
        if (this.updateDocumentIndexes()) {
            this.doUpdateDocumentIndexes(document);
        }
        super.handleDocumentLoaded(document);
    }

    protected boolean updateDocumentIndexes() {
        Serializable flag = this.params.get(UPDATE_DOCUMENT_INDEX);
        return flag != null && flag.toString().equalsIgnoreCase("true");
    }

    protected void doUpdateDocumentIndexes(XComponent document) {
        XTextDocument xDocument = OfficeUtils.cast(XTextDocument.class, document);
        if (xDocument != null) {
            XDocumentIndexesSupplier indexSupplier = OfficeUtils.cast(XDocumentIndexesSupplier.class, xDocument);
            XDocumentIndex index = null;
            if (indexSupplier != null) {
                XIndexAccess ia = indexSupplier.getDocumentIndexes();
                for (int i = 0; i < ia.getCount(); ++i) {
                    Object idx = null;
                    try {
                        idx = ia.getByIndex(i);
                        index = OfficeUtils.cast(XDocumentIndex.class, idx);
                        if (index == null) continue;
                        index.update();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

