/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.api.DefaultJndiContextFactory;
import org.nuxeo.ecm.platform.api.DefaultRepositoryConnector;
import org.nuxeo.ecm.platform.api.DefaultServiceConnector;
import org.nuxeo.ecm.platform.api.JndiContextFactory;
import org.nuxeo.ecm.platform.api.Platform;
import org.nuxeo.ecm.platform.api.RepositoryConnector;
import org.nuxeo.ecm.platform.api.RepositoryDescriptor;
import org.nuxeo.ecm.platform.api.ServerDescriptor;
import org.nuxeo.ecm.platform.api.ServiceConnector;
import org.nuxeo.ecm.platform.api.ServiceDescriptor;
import org.nuxeo.runtime.api.Framework;

@Deprecated
public class Server {
    private static final String jndiPrefix = "nuxeo/";
    private static final String jndiSuffix = "/remote";
    private final Platform platform;
    private final String name;
    private final String host;
    private final String port;
    private final Map<String, ServiceDescriptor> services;
    private final Map<String, RepositoryDescriptor> repositories;
    private final JndiContextFactory jndiContextFactory;
    private InitialContext jndiContext;
    private RepositoryConnector repositoryConnector;
    private ServiceConnector serviceConnector;

    public Server(Platform platform, ServerDescriptor descriptor) throws Exception {
        this.name = descriptor.name;
        this.platform = platform;
        this.services = new Hashtable<String, ServiceDescriptor>();
        this.repositories = new Hashtable<String, RepositoryDescriptor>();
        this.host = Framework.expandVars((String)descriptor.host);
        this.port = descriptor.port == null ? "1099" : descriptor.port;
        this.jndiContextFactory = descriptor.jndiContextFactory == null ? DefaultJndiContextFactory.getInstance() : (JndiContextFactory)descriptor.jndiContextFactory.newInstance();
        this.jndiContext = this.jndiContextFactory.createJndiContext(this.host, this.port);
        this.serviceConnector = descriptor.serviceConnector == null ? DefaultServiceConnector.getInstance() : (ServiceConnector)descriptor.serviceConnector.newInstance();
        this.repositoryConnector = descriptor.repositoryConnector == null ? DefaultRepositoryConnector.getInstance() : (RepositoryConnector)descriptor.repositoryConnector.newInstance();
        if (descriptor.services != null) {
            this.registerServices(descriptor.services.values());
        }
        if (descriptor.repositories != null) {
            this.registerRepositories(descriptor.repositories.values());
        }
    }

    public String getName() {
        return this.name;
    }

    public ServiceDescriptor getServiceDescriptor(String className) {
        return this.services.get(className);
    }

    public RepositoryDescriptor getRepositoryDescriptor(String className) {
        return this.repositories.get(className);
    }

    public final InitialContext getJndiContext() {
        return this.jndiContext;
    }

    public Object lookup(String jndiName) throws NamingException {
        return this.jndiContext.lookup(jndiName);
    }

    public Object getService(ServiceDescriptor sd) throws NamingException {
        return this.serviceConnector.connect(sd);
    }

    public CoreSession openRepository(RepositoryDescriptor rd, Map<String, Serializable> ctx) throws NamingException, ClientException {
        CoreSession session = this.repositoryConnector.connect(rd);
        if (session != null) {
            session.connect(rd.name, ctx);
        }
        return session;
    }

    void registerServices(Collection<ServiceDescriptor> services) {
        for (ServiceDescriptor sd : services) {
            sd.server = this;
            if (sd.jndiName == null) continue;
            if (sd.jndiName.startsWith("%")) {
                sd.jndiName = jndiPrefix + sd.jndiName.substring(1) + jndiSuffix;
            }
            this.services.put(sd.serviceClass, sd);
            if (sd.isPrivate) continue;
            this.platform.registerService(sd);
        }
    }

    void registerRepositories(Collection<RepositoryDescriptor> repositories) {
        for (RepositoryDescriptor rd : repositories) {
            rd.server = this;
            this.repositories.put(rd.name, rd);
            this.platform.registerRepository(rd);
        }
    }
}

