/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.magger;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.batik.css.engine.sac.CSSConditionFactory;
import org.apache.batik.css.engine.sac.CSSSelectorFactory;
import org.milyn.magger.CSSDocumentHandler;
import org.milyn.magger.CSSStylesheet;
import org.milyn.resource.ExternalResourceLocator;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SACMediaList;
import org.w3c.flute.parser.Parser;

public class CSSParser {
    private ExternalResourceLocator resourceLocator;

    public CSSParser(ExternalResourceLocator resourceLocator) {
        if (resourceLocator == null) {
            throw new IllegalArgumentException("null 'resourceLocator' arg in constructor call.");
        }
        this.resourceLocator = resourceLocator;
    }

    public CSSStylesheet parse(URI cssURI, SACMediaList media) throws CSSException, IOException {
        return this.parse(cssURI, media, new CSSStylesheet());
    }

    public CSSStylesheet parse(URI cssURI, SACMediaList media, CSSStylesheet styleSheet) throws CSSException, IOException {
        if (cssURI == null) {
            throw new IllegalArgumentException("null 'cssURI' arg in method call.");
        }
        InputStream cssStream = this.resourceLocator.getResource(cssURI.toString());
        if (cssStream == null) {
            throw new IOException("Failed to read CSS resource: " + cssURI);
        }
        InputSource cssSrc = new InputSource();
        cssSrc.setByteStream(cssStream);
        return this.parse(cssSrc, cssURI, media, styleSheet);
    }

    public CSSStylesheet parse(String cssString, URI baseURI, SACMediaList media) throws CSSException, IOException {
        if (cssString == null) {
            throw new IllegalArgumentException("null 'cssString' arg in method call.");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("null 'baseURI' arg in method call.");
        }
        InputSource cssSrc = new InputSource();
        cssSrc.setByteStream((InputStream)new ByteArrayInputStream(cssString.getBytes()));
        return this.parse(cssSrc, baseURI, media, null);
    }

    public CSSStylesheet parse(InputSource cssSrc, URI baseURI, SACMediaList media, CSSStylesheet styleSheet) throws CSSException, IOException {
        if (cssSrc == null) {
            throw new IllegalArgumentException("null 'cssSrc' arg in method call.");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("null 'baseURI' arg in method call.");
        }
        if (styleSheet == null) {
            styleSheet = new CSSStylesheet();
        }
        CSSDocumentHandler docHandler = new CSSDocumentHandler(styleSheet, baseURI, media, this.resourceLocator);
        Parser flute = new Parser();
        CSSConditionFactory cssConditionFactory = new CSSConditionFactory(null, "class", null, "id");
        flute.setDocumentHandler((DocumentHandler)docHandler);
        flute.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        flute.setConditionFactory((ConditionFactory)cssConditionFactory);
        flute.parseStyleSheet(cssSrc);
        return styleSheet;
    }
}

