/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import org.nuxeo.ecm.core.schema.types.PrimitiveType;

public final class IntegerType
extends PrimitiveType {
    public static final String ID = "integer";
    public static final IntegerType INSTANCE = new IntegerType();
    private static final long serialVersionUID = -2651899444936177530L;

    private IntegerType() {
        super(ID);
    }

    @Override
    public boolean validate(Object object) {
        return object instanceof Number;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt((String)value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Object decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public String encode(Object object) {
        if (object instanceof Integer) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        return object != null ? (String)object : "";
    }

    protected Object readResolve() {
        return INSTANCE;
    }
}

