/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeBindingException;
import org.nuxeo.runtime.api.Framework;

public class TypeRef<T extends Type>
implements Serializable {
    private static final Log log = LogFactory.getLog(TypeRef.class);
    private static final long serialVersionUID = -6701097679440511374L;
    public static final TypeRef<Type> NULL = new TypeRef<Type>("@builtin", "null", null){
        private static final long serialVersionUID = 1609430705796023481L;

        @Override
        public Type get() {
            return null;
        }
    };
    protected final String schema;
    protected final String name;
    protected transient T object;

    public TypeRef(String schema, String name, T object) {
        this.schema = schema;
        this.name = name;
        this.object = object;
    }

    public TypeRef(String schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public T get() {
        if (this.object == null) {
            try {
                this.object = this.load();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return this.object;
    }

    public boolean isLoaded() {
        return this.object == null;
    }

    public T reload() {
        try {
            this.object = this.load();
            return this.object;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public void reset() {
        this.object = null;
    }

    protected T load() throws Exception {
        TypeProvider provider = (TypeProvider)Framework.getLocalService(SchemaManager.class);
        if (provider != null) {
            return (T)provider.getType(this.schema, this.name);
        }
        throw new TypeBindingException("No type provider registered");
    }

    public int hashCode() {
        return this.schema.hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeRef) {
            TypeRef prx = (TypeRef)obj;
            return prx.schema.equals(this.schema) && prx.name.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return new StringBuffer(128).append(this.schema).append(':').append(this.name).toString();
    }
}

