/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.profile;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.milyn.assertion.AssertArgument;
import org.milyn.profile.DefaultProfileSet;
import org.milyn.profile.Profile;
import org.milyn.profile.ProfileSet;
import org.milyn.profile.ProfileStore;
import org.milyn.profile.UnknownProfileMemberException;

public class DefaultProfileStore
implements ProfileStore {
    private Hashtable<String, ProfileSet> store = new Hashtable();

    public ProfileSet getProfileSet(String profileMember) throws UnknownProfileMemberException {
        ProfileSet set = null;
        this.assertProfileMemberNameOK(profileMember);
        set = this.store.get(profileMember.trim().toLowerCase());
        if (set == null) {
            throw new UnknownProfileMemberException("Failed to get ProfileSet.  Unknown profile member name [" + profileMember + "]");
        }
        return set;
    }

    public void addProfileSet(ProfileSet profileSet) {
        AssertArgument.isNotNull(profileSet, "profileSet");
        this.assertProfileMemberNameOK(profileSet.getBaseProfile());
        if (profileSet == null) {
            throw new IllegalArgumentException("null 'profileSet' arg in method call.");
        }
        if (!(profileSet instanceof DefaultProfileSet)) {
            throw new IllegalArgumentException("'profileSet' arg must be an instanceof DefaultProfileSet.");
        }
        this.store.put(profileSet.getBaseProfile().trim().toLowerCase(), profileSet);
        this.expandProfiles();
    }

    public void expandProfiles() {
        for (Map.Entry<String, ProfileSet> entry : this.store.entrySet()) {
            DefaultProfileSet profileSet = (DefaultProfileSet)entry.getValue();
            Iterator iterator = profileSet.values().iterator();
            Vector<DefaultProfileSet> addOns = new Vector<DefaultProfileSet>();
            while (iterator.hasNext()) {
                Profile profile = (Profile)iterator.next();
                try {
                    DefaultProfileSet addOnProfileSet = (DefaultProfileSet)this.getProfileSet(profile.getName());
                    if (addOnProfileSet == null) continue;
                    addOns.add(addOnProfileSet);
                }
                catch (UnknownProfileMemberException e) {}
            }
            for (int i = 0; i < addOns.size(); ++i) {
                profileSet.addProfileSet((DefaultProfileSet)addOns.get(i));
            }
        }
    }

    private void assertProfileMemberNameOK(String profileMember) throws IllegalArgumentException {
        AssertArgument.isNotNullAndNotEmpty(profileMember, "profileMember");
    }

    public String toString() {
        StringBuffer storeDescription = new StringBuffer();
        for (Map.Entry<String, ProfileSet> entry : this.store.entrySet()) {
            String profileMemberName = entry.getKey();
            ProfileSet profileSet = entry.getValue();
            storeDescription.append(profileMemberName).append(": ").append(profileSet).append("\r\n");
        }
        return storeDescription.toString();
    }

    static class UnitTest {
        UnitTest() {
        }

        public static void addProfileSet(ProfileStore store, ProfileSet profileSet) {
            store.addProfileSet(profileSet);
        }
    }
}

