/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.restAPI;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.PooledActor;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;
import org.nuxeo.ecm.platform.syndication.serializer.SerializerHelper;
import org.nuxeo.ecm.platform.syndication.workflow.DashBoardItem;
import org.nuxeo.ecm.platform.syndication.workflow.DashBoardItemImpl;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class TasksRestlet
extends BaseStatelessNuxeoRestlet {
    private static final Log log = LogFactory.getLog(TasksRestlet.class);
    private static final String defaultFormat = "XML";
    private JbpmService jbpmService;

    public JbpmService getJbpmService() throws Exception {
        if (this.jbpmService == null) {
            this.jbpmService = (JbpmService)Framework.getService(JbpmService.class);
        }
        return this.jbpmService;
    }

    public void handle(Request request, Response response) {
        String allLabels;
        String repo = (String)request.getAttributes().get("repo");
        if (!this.initRepository(response, repo)) {
            return;
        }
        String format = request.getResourceRef().getQueryAsForm().getFirstValue("format");
        if (format == null) {
            format = defaultFormat;
        }
        String lang = request.getResourceRef().getQueryAsForm().getFirstValue("lang");
        String myTasksRequested = request.getResourceRef().getQueryAsForm().getFirstValue("mytasks");
        boolean wantMyTasks = true;
        if ("false".equalsIgnoreCase(myTasksRequested)) {
            wantMyTasks = false;
        }
        LinkedList<String> labels = new LinkedList<String>();
        if (lang != null && (allLabels = request.getResourceRef().getQueryAsForm().getFirstValue("labels")) != null) {
            for (String label : allLabels.split("\\,")) {
                labels.add(label);
            }
        }
        List<DashBoardItem> dashboardItems = null;
        try {
            dashboardItems = this.getDashboardItemsForUser((NuxeoPrincipal)TasksRestlet.getUserPrincipal((Request)request), repo, response, wantMyTasks);
        }
        catch (Exception e1) {
            TasksRestlet.handleError((Response)response, (Exception)e1);
        }
        ResultSummary summary = new ResultSummary();
        summary.setTitle("Tasks for " + TasksRestlet.getUserPrincipal((Request)request).getName());
        summary.setLink(TasksRestlet.getRestletFullUrl((Request)request));
        try {
            SerializerHelper.formatResult(summary, dashboardItems, response, format, null, TasksRestlet.getHttpRequest((Request)request), labels, lang);
        }
        catch (ClientException e) {
            TasksRestlet.handleError((Response)response, (Exception)((Object)e));
        }
    }

    private List<DashBoardItem> getDashboardTaskItemsForUser(NuxeoPrincipal user, String repository, Response response) throws Exception {
        ArrayList<DashBoardItem> results = new ArrayList<DashBoardItem>();
        List tasks = this.getJbpmService().getCurrentTaskInstances(user, TasksRestlet.getFilter());
        if (tasks != null) {
            for (TaskInstance task : tasks) {
                DocumentModel doc = null;
                try {
                    doc = this.getJbpmService().getDocumentModel(task, user);
                }
                catch (Exception e) {
                    log.warn((Object)e, (Throwable)e);
                }
                if (doc != null) {
                    results.add(new DashBoardItemImpl(task, doc));
                    continue;
                }
                log.warn((Object)String.format("User '%s' has a task of type '%s' on an unexisting or invisible document", user.getName(), task.getName()));
            }
        }
        return results;
    }

    private List<DashBoardItem> getDashboardItemsManagedByUser(NuxeoPrincipal user, String repository, Response response) throws Exception {
        ArrayList<DashBoardItem> results = new ArrayList<DashBoardItem>();
        List processes = this.getJbpmService().getCurrentProcessInstances(user, TasksRestlet.getFilter());
        if (processes != null) {
            for (ProcessInstance process : processes) {
                DocumentModel doc = null;
                try {
                    doc = this.getJbpmService().getDocumentModel(process, user);
                }
                catch (Exception e) {
                    log.warn((Object)e, (Throwable)e);
                }
                if (doc != null) {
                    Token token = process.getRootToken();
                    List notDone = this.jbpmService.getTaskInstances(Long.valueOf(process.getId()), null, null);
                    for (TaskInstance task : notDone) {
                        Set actors = task.getPooledActors();
                        StringBuilder names = new StringBuilder();
                        if (actors.isEmpty()) {
                            names.append("Workflow Not Started");
                        } else {
                            for (PooledActor actor : actors) {
                                String id;
                                if (!names.toString().equals("")) {
                                    names.append(",");
                                }
                                if ((id = actor.getActorId()).indexOf(58) == -1) {
                                    log.error((Object)("Unable to find to find a ':' in actor id:" + id));
                                    names.append(id);
                                    continue;
                                }
                                names.append(id.substring(id.indexOf(58) + 1));
                            }
                        }
                        DashBoardItemImpl item = new DashBoardItemImpl(task, doc);
                        item.prependToComment(names.toString());
                        results.add(item);
                    }
                    continue;
                }
                log.warn((Object)String.format("User '%s' has a process id of '%ld' on an unexisting or invisible document", user.getName(), process.getId()));
            }
        }
        return results;
    }

    private List<DashBoardItem> getDashboardItemsForUser(NuxeoPrincipal user, String repository, Response response, boolean myTasks) throws Exception {
        List<Object> currentUserTasks = new ArrayList();
        currentUserTasks = myTasks ? this.getDashboardTaskItemsForUser(user, repository, response) : this.getDashboardItemsManagedByUser(user, repository, response);
        return currentUserTasks;
    }

    public static JbpmListFilter getFilter() {
        return null;
    }

    protected boolean initRepository(Response res, String repoId) {
        RepositoryManager rm;
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        try {
            rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        }
        catch (Exception e1) {
            TasksRestlet.handleError((DOMDocument)result, (Response)res, (Exception)e1);
            return false;
        }
        Repository repo = null;
        repo = repoId == null ? rm.getDefaultRepository() : rm.getRepository(repoId);
        if (repo == null) {
            TasksRestlet.handleError((Response)res, (String)("Unable to get " + repoId + " repository"));
            return false;
        }
        try {
            this.session = repo.open();
        }
        catch (Exception e1) {
            TasksRestlet.handleError((DOMDocument)result, (Response)res, (Exception)e1);
            return false;
        }
        if (this.session == null) {
            TasksRestlet.handleError((DOMDocument)result, (Response)res, (String)("Unable to open " + repoId + " repository"));
            return false;
        }
        return true;
    }
}

