/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.restAPI;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;
import org.nuxeo.ecm.platform.syndication.serializer.SerializerHelper;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;

public abstract class BaseQueryModelRestlet
extends BaseStatelessNuxeoRestlet {
    protected static final String QPKEY = "QP";
    protected static final String SORT_PARAM_COLOMN = "criteria";
    protected static final String SORT_PARAM_ASCENDING = "ascending";
    protected static final String PAGE_PARAM = "page";
    protected static final String QPUSER = "$USER";
    private static final String defaultColumns = "dublincore.title,dublincore.description,dublincore.creator,url,icon,dublincore.created,dublincore.modified";
    private static final String defaultFormat = "XML";
    private static QueryModelService qmService;
    private static final Log log;
    protected boolean sortAscending = false;
    protected String sortColomn = "";

    protected abstract String getQueryModelName(Request var1);

    protected String getDefaultColumns() {
        return defaultColumns;
    }

    protected String getDefaultFormat() {
        return defaultFormat;
    }

    protected CoreSession getCoreSession(Request req, Response res, String repoName) {
        try {
            Repository repository = repoName == null ? ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository() : ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepository(repoName);
            if (repository == null) {
                throw new ClientException("Cannot get repository");
            }
            HashMap<String, Serializable> context = new HashMap<String, Serializable>();
            context.put("principal", BaseQueryModelRestlet.getSerializablePrincipal((Request)req));
            return repository.open(context);
        }
        catch (Exception e) {
            BaseQueryModelRestlet.handleError((Response)res, (Exception)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request req, Response res) {
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        QueryModelService qmService = this.getQueryModelService(result, res);
        if (qmService == null) {
            return;
        }
        String qmName = this.getQueryModelName(req);
        QueryModelDescriptor qmd = qmService.getQueryModelDescriptor(qmName);
        if (qmd == null) {
            BaseQueryModelRestlet.handleError((DOMDocument)result, (Response)res, (String)("can not find QueryModel " + qmName));
            return;
        }
        CoreSession session = this.getCoreSession(req, res, null);
        try {
            String columnsDefinition;
            PagedDocumentsProvider provider = this.getPageDocumentsProvider(session, qmd, req);
            Form form = req.getResourceRef().getQueryAsForm();
            String pageS = form.getFirstValue(PAGE_PARAM);
            int page = 0;
            if (pageS != null) {
                try {
                    page = Integer.parseInt(pageS);
                }
                catch (NumberFormatException e) {
                    page = 0;
                }
            }
            if (page >= provider.getNumberOfPages()) {
                BaseQueryModelRestlet.handleError((DOMDocument)result, (Response)res, (String)("No Page " + page + " available"));
                return;
            }
            String format = form.getFirstValue("format");
            if (format == null) {
                format = this.getDefaultFormat();
            }
            if ((columnsDefinition = form.getFirstValue("columns")) == null) {
                columnsDefinition = defaultColumns;
            }
            String lang = form.getFirstValue("lang");
            DocumentModelList dmList = provider.getPage(page);
            ResultSummary summary = new ResultSummary();
            summary.setTitle("Result for search " + qmName);
            summary.setDescription("Result for search " + qmName);
            summary.setAuthor(BaseQueryModelRestlet.getUserPrincipal((Request)req).getName());
            summary.setModificationDate(new Date());
            summary.setLink(BaseQueryModelRestlet.getRestletFullUrl((Request)req));
            summary.setPages(provider.getNumberOfPages());
            summary.setPageNumber(page);
            if (lang != null) {
                String[] cols = columnsDefinition.split(",");
                ArrayList<String> labels = new ArrayList<String>();
                for (String col : cols) {
                    labels.add("label." + col);
                }
                SerializerHelper.formatResult(summary, dmList, res, format, columnsDefinition, BaseQueryModelRestlet.getHttpRequest((Request)req), labels, lang);
            } else {
                SerializerHelper.formatResult(summary, dmList, res, format, columnsDefinition, BaseQueryModelRestlet.getHttpRequest((Request)req));
            }
        }
        catch (Exception e) {
            BaseQueryModelRestlet.handleError((Response)res, (Exception)e);
        }
        finally {
            try {
                Repository.close((CoreSession)session);
            }
            catch (Exception e) {
                log.error((Object)"Repository close failed", (Throwable)e);
            }
        }
    }

    protected QueryModelService getQueryModelService(DOMDocument result, Response res) {
        if (qmService == null) {
            try {
                qmService = (QueryModelService)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService");
                if (qmService == null) {
                    BaseQueryModelRestlet.handleError((DOMDocument)result, (Response)res, (String)"Unable to get QueryModel Service");
                    return null;
                }
            }
            catch (Exception e) {
                BaseQueryModelRestlet.handleError((DOMDocument)result, (Response)res, (Exception)e);
                return null;
            }
        }
        return qmService;
    }

    protected PagedDocumentsProvider getPageDocumentsProvider(CoreSession session, QueryModelDescriptor qmd, Request request) throws ClientException {
        Object[] parameters = null;
        List<Object> strParams = this.extractQueryParameters(request);
        if (strParams != null && !strParams.isEmpty()) {
            parameters = strParams.toArray();
        }
        SortInfo sorter = null;
        if (this.sortColomn != null && !"".equals(this.sortColomn)) {
            sorter = new SortInfo(this.sortColomn, this.sortAscending);
        }
        if (qmd.isStateless()) {
            QueryModel qm = new QueryModel(qmd);
            return qm.getResultsProvider(session, parameters, sorter);
        }
        String docType = qmd.getDocType();
        DocumentModel doc = this.extractNamedParameters(request, docType);
        QueryModel qm = new QueryModel(qmd, doc);
        return qm.getResultsProvider(session, null, sorter);
    }

    protected DocumentModel extractNamedParameters(Request req, String docType) throws PropertyException {
        DocumentModelImpl doc = new DocumentModelImpl(docType);
        for (Schema schema : BaseQueryModelRestlet.getSchemaManager().getDocumentType(docType).getSchemas()) {
            DataModelImpl dm = new DataModelImpl(schema.getName());
            for (Field field : schema.getFields()) {
                String localName = field.getName().getLocalName();
                String fName = schema.getName() + ':' + localName;
                String fValue = req.getResourceRef().getQueryAsForm().getFirstValue(fName);
                if (fValue == null) continue;
                if (localName.equalsIgnoreCase("coverage") || localName.equalsIgnoreCase("subjects") || localName.equalsIgnoreCase("currentLifeCycleStates")) {
                    dm.setData(localName, (Object)new Object[]{fValue});
                    continue;
                }
                dm.setData(localName, (Object)fValue);
            }
            doc.addDataModel((DataModel)dm);
        }
        return doc;
    }

    protected static SchemaManager getSchemaManager() {
        return (SchemaManager)Framework.getRuntime().getService(SchemaManager.class);
    }

    protected List<Object> extractQueryParameters(Request req) {
        ArrayList<Object> qp = new ArrayList<Object>();
        Form form = req.getResourceRef().getQueryAsForm();
        ArrayList rp = new ArrayList(form.getNames());
        Collections.sort(rp);
        for (String k : rp) {
            String param;
            if (k.startsWith(QPKEY) && (param = form.getFirstValue(k)) != null) {
                if (param.equals(QPUSER)) {
                    qp.add(BaseQueryModelRestlet.getUserPrincipal((Request)req).getName());
                } else {
                    qp.add(param);
                }
            }
            if (k.startsWith(SORT_PARAM_COLOMN)) {
                this.sortColomn = form.getFirstValue(k);
            }
            if (!k.startsWith(SORT_PARAM_ASCENDING)) continue;
            param = form.getFirstValue(k);
            if ("true".equalsIgnoreCase(param) || "1".equals(param)) {
                this.sortAscending = true;
                continue;
            }
            if (!"false".equalsIgnoreCase(param) && !"0".equals(param)) continue;
            this.sortAscending = false;
        }
        return qp;
    }

    static {
        log = LogFactory.getLog(BaseQueryModelRestlet.class);
    }
}

