/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.storage.sql.DatabaseH2;
import org.nuxeo.ecm.core.storage.sql.DatabasePostgreSQL;
import org.nuxeo.ecm.core.storage.sql.SQLRepositoryTestCase;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TXSQLRepositoryTestCase
extends SQLRepositoryTestCase {
    @Override
    public void setUp() throws Exception {
        this.setUpContainer();
        super.setUp();
        Environment.getDefault().setHostApplicationName("NXServer");
        this.fireFrameworkStarted();
        TransactionHelper.startTransaction();
        this.openSession();
    }

    protected void setUpContainer() throws Exception {
        NuxeoContainer.install();
    }

    @Override
    protected void deployRepositoryContrib() throws Exception {
        if (this.database instanceof DatabaseH2) {
            String contrib = "OSGI-INF/test-pooling-h2-contrib.xml";
            this.deployContrib("org.nuxeo.ecm.core.storage.sql.test", contrib);
        } else if (this.database instanceof DatabasePostgreSQL) {
            String contrib = "OSGI-INF/test-pooling-postgres-contrib.xml";
            this.deployContrib("org.nuxeo.ecm.core.storage.sql.test", contrib);
        } else {
            super.deployRepositoryContrib();
        }
    }

    protected boolean hasPoolingConfig() {
        return this.database instanceof DatabaseH2 || this.database instanceof DatabasePostgreSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            this.session.cancel();
            this.closeSession();
            if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                TransactionHelper.setTransactionRollbackOnly();
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
        finally {
            if (NuxeoContainer.isInstalled()) {
                NuxeoContainer.uninstall();
            }
            super.tearDown();
        }
    }
}

