/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public abstract class SQLRepositoryTestCase
extends NXRuntimeTestCase {
    private static final Log log = LogFactory.getLog(SQLRepositoryTestCase.class);
    @Deprecated
    public static final String REPOSITORY_NAME = DatabaseHelper.DATABASE.repositoryName;
    public CoreSession session;
    protected int initialOpenSessions;
    public DatabaseHelper database = DatabaseHelper.DATABASE;

    public SQLRepositoryTestCase() {
    }

    public SQLRepositoryTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.initialOpenSessions = CoreInstance.getInstance().getNumberOfSessions();
        super.setUp();
        this.deployBundle("org.nuxeo.ecm.core.schema");
        this.deployBundle("org.nuxeo.ecm.core.api");
        this.deployBundle("org.nuxeo.ecm.core");
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.deployBundle("org.nuxeo.ecm.core.storage.sql");
        this.database.setUp();
        this.deployRepositoryContrib();
    }

    protected void deployRepositoryContrib() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.storage.sql.test", this.database.getDeploymentContrib());
    }

    public void tearDown() throws Exception {
        ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
        super.tearDown();
        this.database.tearDown();
        CoreInstance core = CoreInstance.getInstance();
        int finalOpenSessions = core.getNumberOfSessions();
        int leakedOpenSessions = finalOpenSessions - this.initialOpenSessions;
        if (leakedOpenSessions != 0) {
            log.error((Object)String.format("There are %s open session(s) at tear down; it seems the test leaked %s session(s).", finalOpenSessions, leakedOpenSessions));
            for (CoreInstance.RegistrationInfo info : core.getRegistrationInfos()) {
                log.warn((Object)"Leaking session", (Throwable)info);
            }
        }
    }

    public void openSession() throws ClientException {
        if (this.session != null) {
            log.warn((Object)"Closing session for you");
            this.closeSession();
        }
        this.session = this.openSessionAs("Administrator");
        SQLRepositoryTestCase.assertNotNull((Object)this.session);
    }

    public CoreSession openSessionAs(String username) throws ClientException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("username", username);
        return CoreInstance.getInstance().open(this.database.repositoryName, context);
    }

    public CoreSession openSessionAs(NuxeoPrincipal principal) throws ClientException {
        HashMap<String, NuxeoPrincipal> context = new HashMap<String, NuxeoPrincipal>();
        context.put("principal", principal);
        return CoreInstance.getInstance().open(this.database.repositoryName, context);
    }

    public void closeSession() {
        this.closeSession(this.session);
        this.session = null;
    }

    public void closeSession(CoreSession session) {
        if (session != null) {
            CoreInstance.getInstance().close(session);
        }
    }
}

