/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.JUnitCore;
import org.nuxeo.ecm.core.storage.sql.DatabaseH2;
import org.nuxeo.ecm.core.storage.sql.TXSQLRepositoryTestCase;

public class NuxeoServerRunner {
    private static final Log log = LogFactory.getLog(NuxeoServerRunner.class);
    public static int shutdownPort = 4444;

    public static void getPortFromArgs(String[] args) {
        if (args.length == 2 && "-p".equals(args[0])) {
            try {
                shutdownPort = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String msg = "Using server shutdown port " + shutdownPort;
        log.info((Object)msg);
        System.out.println(msg);
    }

    public static void main(String[] args) {
        try {
            NuxeoServerRunner.getPortFromArgs(args);
            JUnitCore.runClasses((Class[])new Class[]{ToRun.class});
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static class Stopper {
        public static void main(String[] args) throws Exception {
            NuxeoServerRunner.getPortFromArgs(args);
            new Socket("127.0.0.1", shutdownPort);
        }
    }

    public static class ToRun
    extends TXSQLRepositoryTestCase {
        @Override
        protected void deployRepositoryContrib() throws Exception {
            this.deployContrib("org.nuxeo.ecm.core.storage.sql.test.tests", "OSGI-INF/test-backend-core-types-contrib.xml");
            if (this.database instanceof DatabaseH2) {
                String contrib = "OSGI-INF/test-server-pooling-h2-contrib.xml";
                this.deployContrib("org.nuxeo.ecm.core.storage.sql.test", contrib);
            } else {
                super.deployRepositoryContrib();
            }
        }

        public void test() throws Exception {
            new ServerSocket(shutdownPort).accept();
        }
    }
}

