/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DatabaseSQLServer
extends DatabaseHelper {
    public static DatabaseHelper INSTANCE = new DatabaseSQLServer();
    private static final String DEF_SERVER = "localhost";
    private static final String DEF_PORT = "1433";
    private static final String DEF_DATABASE = "nuxeojunittests";
    private static final String DEF_USER = "nuxeo";
    private static final String DEF_PASSWORD = "nuxeo";
    private static final String CONTRIB_XML = "OSGI-INF/test-repo-repository-mssql-contrib.xml";
    private static final String DRIVER = "net.sourceforge.jtds.jdbc.Driver";

    private void setProperties() {
        Framework.getProperties().setProperty("nuxeo.test.vcs.repository", this.repositoryName);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.server", DEF_SERVER);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.port", DEF_PORT);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.database", DEF_DATABASE);
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.user", "nuxeo");
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.password", "nuxeo");
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.driver", DRIVER);
        String url = String.format("jdbc:jtds:sqlserver://%s:%s/%s;user=%s;password=%s", System.getProperty("nuxeo.test.vcs.server"), System.getProperty("nuxeo.test.vcs.port"), System.getProperty("nuxeo.test.vcs.database"), System.getProperty("nuxeo.test.vcs.user"), System.getProperty("nuxeo.test.vcs.password"));
        DatabaseSQLServer.setProperty("nuxeo.test.vcs.url", url);
    }

    @Override
    public void setUp() throws Exception {
        Class.forName(DRIVER);
        this.setProperties();
        Connection connection = DriverManager.getConnection(System.getProperty("nuxeo.test.vcs.url"));
        DatabaseSQLServer.doOnAllTables(connection, null, null, "DROP TABLE [%s]");
        connection.close();
    }

    @Override
    public String getDeploymentContrib() {
        return CONTRIB_XML;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.xaDataSourceName = "net.sourceforge.jtds.jdbcx.JtdsDataSource";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("ServerName", System.getProperty("nuxeo.test.vcs.server"));
        properties.put("PortNumber", System.getProperty("nuxeo.test.vcs.port"));
        properties.put("DatabaseName", System.getProperty("nuxeo.test.vcs.database"));
        properties.put("User", System.getProperty("nuxeo.test.vcs.user"));
        properties.put("Password", System.getProperty("nuxeo.test.vcs.password"));
        properties.put("UseCursors", "true");
        descriptor.properties = properties;
        descriptor.fulltextAnalyzer = "french";
        descriptor.fulltextCatalog = "nuxeo";
        return descriptor;
    }

    @Override
    public void sleepForFulltext() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean supportsMultipleFulltextIndexes() {
        return false;
    }

    @Override
    public boolean supportsClustering() {
        return true;
    }
}

