/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DatabasePostgreSQL
extends DatabaseHelper {
    public static DatabaseHelper INSTANCE = new DatabasePostgreSQL();
    private static final String DEF_SERVER = "localhost";
    private static final String DEF_PORT = "5432";
    private static final String DEF_USER = "nuxeo";
    private static final String DEF_PASSWORD = "nuxeo";
    private static final String CONTRIB_XML = "OSGI-INF/test-repo-repository-postgresql-contrib.xml";
    private static final String DRIVER = "org.postgresql.Driver";

    protected void setProperties() {
        Framework.getProperties().setProperty("nuxeo.test.vcs.repository", this.repositoryName);
        DatabasePostgreSQL.setProperty("nuxeo.test.vcs.database", this.databaseName);
        DatabasePostgreSQL.setProperty("nuxeo.test.vcs.server", DEF_SERVER);
        DatabasePostgreSQL.setProperty("nuxeo.test.vcs.port", DEF_PORT);
        DatabasePostgreSQL.setProperty("nuxeo.test.vcs.user", "nuxeo");
        DatabasePostgreSQL.setProperty("nuxeo.test.vcs.password", "nuxeo");
        DatabasePostgreSQL.setProperty("nuxeo.test.vcs.driver", DRIVER);
        String url = String.format("jdbc:postgresql://%s:%s/%s", System.getProperty("nuxeo.test.vcs.server"), System.getProperty("nuxeo.test.vcs.port"), System.getProperty("nuxeo.test.vcs.database"));
        DatabasePostgreSQL.setProperty("nuxeo.test.vcs.url", url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        Class.forName(DRIVER);
        this.setProperties();
        Connection connection = DriverManager.getConnection(System.getProperty("nuxeo.test.vcs.url"), System.getProperty("nuxeo.test.vcs.user"), System.getProperty("nuxeo.test.vcs.password"));
        try {
            DatabasePostgreSQL.doOnAllTables(connection, null, "public", "DROP TABLE \"%s\" CASCADE");
        }
        finally {
            connection.close();
        }
    }

    @Override
    public String getDeploymentContrib() {
        return CONTRIB_XML;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.xaDataSourceName = "org.postgresql.xa.PGXADataSource";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("ServerName", System.getProperty("nuxeo.test.vcs.server"));
        properties.put("PortNumber", System.getProperty("nuxeo.test.vcs.port"));
        properties.put("DatabaseName", System.getProperty("nuxeo.test.vcs.database"));
        properties.put("User", System.getProperty("nuxeo.test.vcs.user"));
        properties.put("Password", System.getProperty("nuxeo.test.vcs.password"));
        descriptor.properties = properties;
        descriptor.fulltextAnalyzer = "french";
        descriptor.pathOptimizationsEnabled = true;
        descriptor.aclOptimizationsEnabled = true;
        return descriptor;
    }

    @Override
    public boolean supportsClustering() {
        return true;
    }
}

