/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DatabaseOracle
extends DatabaseHelper {
    private static final Log log = LogFactory.getLog(DatabaseOracle.class);
    public static DatabaseHelper INSTANCE = new DatabaseOracle();
    private static final String DEF_SERVER = "localhost";
    private static final String DEF_URL = "jdbc:oracle:thin:@localhost:1521:XE";
    private static final String DEF_USER = "nuxeo";
    private static final String DEF_PASSWORD = "nuxeo";
    private static final String CONTRIB_XML = "OSGI-INF/test-repo-repository-oracle-contrib.xml";
    private static final String DRIVER = "oracle.jdbc.driver.OracleDriver";

    private void setProperties() {
        Framework.getProperties().setProperty("nuxeo.test.vcs.repository", this.repositoryName);
        DatabaseOracle.setProperty("nuxeo.test.vcs.url", DEF_URL);
        DatabaseOracle.setProperty("nuxeo.test.vcs.user", "nuxeo");
        DatabaseOracle.setProperty("nuxeo.test.vcs.password", "nuxeo");
        DatabaseOracle.setProperty("nuxeo.test.vcs.driver", DRIVER);
    }

    @Override
    public void setUp() throws Exception {
        Class.forName(DRIVER);
        this.setProperties();
        Connection connection = DriverManager.getConnection(System.getProperty("nuxeo.test.vcs.url"), System.getProperty("nuxeo.test.vcs.user"), System.getProperty("nuxeo.test.vcs.password"));
        DatabaseOracle.doOnAllTables(connection, null, System.getProperty("nuxeo.test.vcs.user").toUpperCase(), "DROP TABLE \"%s\" CASCADE CONSTRAINTS PURGE");
        this.dropSequences(connection);
        connection.close();
    }

    public void dropSequences(Connection connection) throws Exception {
        ArrayList<String> sequenceNames = new ArrayList<String>();
        Statement st = connection.createStatement();
        ResultSet rs = st.executeQuery("SELECT SEQUENCE_NAME FROM USER_SEQUENCES");
        while (rs.next()) {
            String sequenceName = rs.getString(1);
            if (sequenceName.indexOf(36) != -1) continue;
            sequenceNames.add(sequenceName);
        }
        rs.close();
        for (String sequenceName : sequenceNames) {
            String sql = String.format("DROP SEQUENCE \"%s\"", sequenceName);
            log.trace((Object)("SQL: " + sql));
            st.execute(sql);
        }
        st.close();
    }

    @Override
    public String getDeploymentContrib() {
        return CONTRIB_XML;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.xaDataSourceName = "oracle.jdbc.xa.client.OracleXADataSource";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("URL", System.getProperty("nuxeo.test.vcs.url"));
        properties.put("User", System.getProperty("nuxeo.test.vcs.user"));
        properties.put("Password", System.getProperty("nuxeo.test.vcs.password"));
        descriptor.properties = properties;
        return descriptor;
    }

    @Override
    public boolean supportsClustering() {
        return true;
    }
}

