/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryFactory;

public abstract class DatabaseHelper {
    private static final Log log = LogFactory.getLog(DatabaseHelper.class);
    public static final String DB_PROPERTY = "nuxeo.test.vcs.db";
    public static final String DB_DEFAULT = "H2";
    public static DatabaseHelper DATABASE;
    public static final String DB_CLASS_NAME_BASE = "org.nuxeo.ecm.core.storage.sql.Database";
    protected static final Class<? extends RepositoryFactory> defaultRepositoryFactory;
    public static final String REPOSITORY_PROPERTY = "nuxeo.test.vcs.repository";
    public static final String DRIVER_PROPERTY = "nuxeo.test.vcs.driver";
    public static final String URL_PROPERTY = "nuxeo.test.vcs.url";
    public static final String SERVER_PROPERTY = "nuxeo.test.vcs.server";
    public static final String PORT_PROPERTY = "nuxeo.test.vcs.port";
    public static final String DATABASE_PROPERTY = "nuxeo.test.vcs.database";
    public static final String USER_PROPERTY = "nuxeo.test.vcs.user";
    public static final String PASSWORD_PROPERTY = "nuxeo.test.vcs.password";
    public static final String DEFAULT_DATABASE_NAME = "nuxeojunittests";
    protected String databaseName = "nuxeojunittests";
    public static final String DEFAULT_REPOSITORY_NAME = "test";
    public String repositoryName = "test";

    public static String setProperty(String name, String def) {
        String value = System.getProperty(name);
        if (value == null || value.equals("") || value.equals("${" + name + "}")) {
            System.setProperty(name, def);
        }
        return value;
    }

    public void setDatabaseName(String name) {
        this.databaseName = name;
    }

    public void setRepositoryName(String name) {
        this.repositoryName = name;
    }

    public static void setDatabaseForTests(String className) {
        try {
            DATABASE = (DatabaseHelper)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Database class not found: " + className);
        }
        String msg = "Database used for VCS tests: " + className;
        System.out.println(DatabaseHelper.class.getSimpleName() + ": " + msg);
        log.info((Object)msg);
    }

    public static void doOnAllTables(Connection connection, String catalog, String schemaPattern, String statement) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        LinkedList<String> tableNames = new LinkedList<String>();
        ResultSet rs = metadata.getTables(catalog, schemaPattern, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            if (tableName.indexOf(36) != -1 || "ACLR_USER_USERS".equals(tableName) || "ANCESTORS_ANCESTORS".equals(tableName)) continue;
            tableNames.add(tableName);
        }
        if (tableNames.remove("HIERARCHY")) {
            tableNames.add("HIERARCHY");
        }
        if (tableNames.remove("hierarchy")) {
            tableNames.add("hierarchy");
        }
        Statement st = connection.createStatement();
        for (String tableName : tableNames) {
            String sql = String.format(statement, tableName);
            log.trace((Object)("SQL: " + sql));
            st.execute(sql);
        }
        st.close();
    }

    public void setUp(Class<? extends RepositoryFactory> factoryClass) throws Exception {
        DatabaseHelper.setRepositoryFactory(factoryClass);
        this.setUp();
    }

    public abstract void setUp() throws Exception;

    public void tearDown() throws SQLException {
        this.setDatabaseName(DEFAULT_DATABASE_NAME);
        this.setRepositoryName(DEFAULT_REPOSITORY_NAME);
        DatabaseHelper.setRepositoryFactory(defaultRepositoryFactory);
    }

    public static void setRepositoryFactory(Class<? extends RepositoryFactory> factoryClass) {
        System.setProperty("nuxeo.test.vcs.repository-factory", factoryClass.getName());
    }

    public abstract String getDeploymentContrib();

    public abstract RepositoryDescriptor getRepositoryDescriptor();

    public void sleepForFulltext() {
    }

    public void maybeSleepToNextSecond() {
        if (!this.hasSubSecondResolution()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean hasSubSecondResolution() {
        return true;
    }

    public int getRecursiveRemovalDepthLimit() {
        return 0;
    }

    public boolean supportsClustering() {
        return false;
    }

    public boolean supportsMultipleFulltextIndexes() {
        return true;
    }

    static {
        defaultRepositoryFactory = SQLRepositoryFactory.class;
        DatabaseHelper.setProperty(DB_PROPERTY, DB_DEFAULT);
        String className = System.getProperty(DB_PROPERTY);
        if (className.indexOf(46) < 0) {
            className = DB_CLASS_NAME_BASE + className;
        }
        DatabaseHelper.setDatabaseForTests(className);
        DatabaseHelper.setRepositoryFactory(defaultRepositoryFactory);
    }
}

