/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DatabaseH2
extends DatabaseHelper {
    public static final DatabaseHelper INSTANCE = new DatabaseH2();
    private static final Log log = LogFactory.getLog(DatabaseH2.class);
    protected static final String DIRECTORY = "target/test/h2";
    protected static final String DEF_USER = "sa";
    protected static final String DEF_PASSWORD = "";
    protected static final String CONTRIB_XML = "OSGI-INF/test-repo-repository-h2-contrib.xml";
    protected static final String DRIVER = "org.h2.Driver";
    protected String h2Path;
    protected String origUrl;
    protected String url;
    protected Error owner;

    protected void setProperties() {
        this.url = String.format("jdbc:h2:%s/%s", this.h2Path, this.databaseName);
        this.origUrl = DatabaseH2.setProperty("nuxeo.test.vcs.url", this.url);
        Framework.getProperties().setProperty("nuxeo.test.vcs.repository", this.repositoryName);
        DatabaseH2.setProperty("nuxeo.test.vcs.database", this.databaseName);
        DatabaseH2.setProperty("nuxeo.test.vcs.user", DEF_USER);
        DatabaseH2.setProperty("nuxeo.test.vcs.password", DEF_PASSWORD);
        DatabaseH2.setProperty("nuxeo.test.vcs.driver", DRIVER);
    }

    @Override
    public void setUp() throws Exception {
        if (this.owner != null) {
            Error e = new Error("Second call to setUp() without tearDown()", this.owner);
            log.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        this.owner = new Error("Database not released");
        Class.forName(DRIVER);
        File dir = new File(DIRECTORY);
        FileUtils.deleteTree((File)dir);
        dir.mkdirs();
        this.h2Path = new File(dir, this.getId()).getAbsolutePath();
        this.setProperties();
    }

    protected String getId() {
        return "nuxeo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws SQLException {
        this.owner = null;
        if (this.origUrl == null) {
            System.clearProperty("nuxeo.test.vcs.url");
        } else {
            System.setProperty("nuxeo.test.vcs.url", this.origUrl);
        }
        try {
            Connection connection = DriverManager.getConnection(this.url, System.getProperty("nuxeo.test.vcs.user"), System.getProperty("nuxeo.test.vcs.password"));
            Statement st = connection.createStatement();
            String sql = "SHUTDOWN";
            log.trace((Object)sql);
            st.execute(sql);
            st.close();
            connection.close();
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    public String getDeploymentContrib() {
        return CONTRIB_XML;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.xaDataSourceName = "org.h2.jdbcx.JdbcDataSource";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("URL", this.url);
        properties.put("User", System.getProperty("nuxeo.test.vcs.user"));
        properties.put("Password", System.getProperty("nuxeo.test.vcs.password"));
        descriptor.properties = properties;
        return descriptor;
    }

    @Override
    public boolean supportsClustering() {
        return true;
    }
}

