/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.storage.sql.DatabaseHelper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class DatabaseDerby
extends DatabaseHelper {
    public static final DatabaseHelper INSTANCE = new DatabaseDerby();
    private static final String DIRECTORY = "target/test/derby";
    private static final String DEF_USER = "sa";
    private static final String DEF_PASSWORD = "";
    private static final String CONTRIB_XML = "OSGI-INF/test-repo-repository-derby-contrib.xml";
    private static final String LOG = "target/test/derby.log";
    private static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    protected String url;

    protected void setProperties() {
        Framework.getProperties().setProperty("nuxeo.test.vcs.repository", this.repositoryName);
        DatabaseDerby.setProperty("nuxeo.test.vcs.database", new File(DIRECTORY).getAbsolutePath());
        DatabaseDerby.setProperty("nuxeo.test.vcs.user", DEF_USER);
        DatabaseDerby.setProperty("nuxeo.test.vcs.password", DEF_PASSWORD);
        DatabaseDerby.setProperty("nuxeo.test.vcs.driver", DRIVER);
        this.url = String.format("jdbc:derby:%s;create=true", System.getProperty("nuxeo.test.vcs.database"));
        DatabaseDerby.setProperty("nuxeo.test.vcs.url", this.url);
    }

    @Override
    public void setUp() throws Exception {
        Class.forName(DRIVER).newInstance();
        File dbdir = new File(DIRECTORY);
        File parent = dbdir.getParentFile();
        FileUtils.deleteTree((File)dbdir);
        parent.mkdirs();
        System.setProperty("derby.stream.error.file", new File(LOG).getAbsolutePath());
        System.setProperty("derby.system.durability", "test");
        this.setProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws SQLException {
        SQLException ex = null;
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            if ("Derby system shutdown.".equals(message)) {
                return;
            }
            if ("org.apache.derby.jdbc.EmbeddedDriver is not registered with the JDBC driver manager".equals(message)) {
                return;
            }
            ex = e;
        }
        finally {
            super.tearDown();
        }
        throw new RuntimeException("Expected Derby shutdown exception instead", ex);
    }

    @Override
    public String getDeploymentContrib() {
        return CONTRIB_XML;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.xaDataSourceName = "org.apache.derby.jdbc.EmbeddedXADataSource";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("createDatabase", "create");
        properties.put("databaseName", System.getProperty("nuxeo.test.vcs.database"));
        properties.put("user", System.getProperty("nuxeo.test.vcs.user"));
        properties.put("password", System.getProperty("nuxeo.test.vcs.password"));
        descriptor.properties = properties;
        return descriptor;
    }

    @Override
    public boolean supportsMultipleFulltextIndexes() {
        return false;
    }
}

